/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.model.machine.variant;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.gregtechceu.gtceu.client.model.machine.MachineModelLoader;
import com.gregtechceu.gtceu.client.util.VariantRotationHelpers;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Transformation;
import java.lang.reflect.Type;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class VariantState
implements ModelState {
    private final Either<ResourceLocation, UnbakedModel> model;
    private final Transformation rotation;
    private final boolean uvLocked;
    private final int weight;
    private UnbakedModel resolvedModel;

    public VariantState(Either<ResourceLocation, UnbakedModel> model, Transformation rotation, boolean uvLocked, int weight) {
        this.model = model;
        this.rotation = rotation;
        this.uvLocked = uvLocked;
        this.weight = weight;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VariantState)) {
            return false;
        }
        VariantState variantState = (VariantState)other;
        return this.model.equals(variantState.model) && Objects.equals(this.rotation, variantState.rotation) && this.uvLocked == variantState.uvLocked && this.weight == variantState.weight;
    }

    public int hashCode() {
        int i = this.model.hashCode();
        i = 31 * i + this.rotation.hashCode();
        i = 31 * i + Boolean.valueOf(this.uvLocked).hashCode();
        return 31 * i + this.weight;
    }

    @Generated
    public Either<ResourceLocation, UnbakedModel> getModel() {
        return this.model;
    }

    @Generated
    public Transformation getRotation() {
        return this.rotation;
    }

    @Generated
    public boolean isUvLocked() {
        return this.uvLocked;
    }

    @Generated
    public int getWeight() {
        return this.weight;
    }

    @Generated
    public UnbakedModel getResolvedModel() {
        return this.resolvedModel;
    }

    @Generated
    public void setResolvedModel(UnbakedModel resolvedModel) {
        this.resolvedModel = resolvedModel;
    }

    public static class Deserializer
    implements JsonDeserializer<VariantState> {
        public VariantState deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            Either<ResourceLocation, UnbakedModel> model = MachineModelLoader.parseVariant(obj.get("model"), context);
            Transformation rot = this.getBlockRotation(obj);
            boolean isUvLock = GsonHelper.getAsBoolean((JsonObject)obj, (String)"uvlock", (boolean)false);
            int weight = this.getWeight(obj);
            return new VariantState(model, rot, isUvLock, weight);
        }

        protected Transformation getBlockRotation(JsonObject json) {
            int z;
            int y;
            int x = GsonHelper.getAsInt((JsonObject)json, (String)"x", (int)0);
            Transformation rotation = VariantRotationHelpers.getRotationTransform(x, y = GsonHelper.getAsInt((JsonObject)json, (String)"y", (int)0), z = GsonHelper.getAsInt((JsonObject)json, (String)"gtceu:z", (int)0));
            if (rotation != null) {
                return rotation;
            }
            throw new JsonParseException("Invalid ExtendedBlockModelRotation x: " + x + ", y: " + y + ", z: " + z);
        }

        protected int getWeight(JsonObject json) {
            int i = GsonHelper.getAsInt((JsonObject)json, (String)"weight", (int)1);
            if (i < 1) {
                throw new JsonParseException("Invalid weight " + i + " found, expected integer >= 1");
            }
            return i;
        }
    }
}

