/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer;

import com.gregtechceu.gtceu.client.model.IBlockEntityRendererBakedModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;

@OnlyIn(value=Dist.CLIENT)
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BlockEntityWithBERModelRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private final BlockRenderDispatcher blockRenderDispatcher;

    public BlockEntityWithBERModelRenderer(BlockEntityRendererProvider.Context context) {
        this.blockRenderDispatcher = context.getBlockRenderDispatcher();
    }

    public void render(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        BlockState blockState = blockEntity.getBlockState();
        BakedModel model = this.blockRenderDispatcher.getBlockModel(blockState);
        if (model instanceof IBlockEntityRendererBakedModel) {
            IBlockEntityRendererBakedModel berModel = (IBlockEntityRendererBakedModel)model;
            if (berModel.getBlockEntityType() != blockEntity.getType()) {
                return;
            }
            berModel.render(blockEntity, partialTick, poseStack, buffer, packedLight, packedOverlay);
        } else {
            ModelData modelData;
            Level level = blockEntity.getLevel();
            BlockPos pos = blockEntity.getBlockPos();
            if (level.getModelDataManager() == null || (modelData = level.getModelDataManager().getAt(pos)) == null) {
                modelData = ModelData.EMPTY;
            }
            long randomSeed = blockState.getSeed(pos);
            RandomSource random = RandomSource.create();
            random.setSeed(randomSeed);
            for (RenderType renderType : model.getRenderTypes(blockState, random, modelData)) {
                VertexConsumer consumer = buffer.getBuffer(renderType);
                this.blockRenderDispatcher.getModelRenderer().tesselateBlock((BlockAndTintGetter)level, model, blockState, pos, poseStack, consumer, true, random, randomSeed, OverlayTexture.NO_OVERLAY, modelData, renderType);
            }
        }
    }

    public boolean shouldRenderOffScreen(T blockEntity) {
        IBlockEntityRendererBakedModel berModel;
        BlockState blockState = blockEntity.getBlockState();
        BakedModel model = this.blockRenderDispatcher.getBlockModel(blockState);
        if (model instanceof IBlockEntityRendererBakedModel && (berModel = (IBlockEntityRendererBakedModel)model).getBlockEntityType() == blockEntity.getType()) {
            return berModel.shouldRenderOffScreen((BlockEntity)blockEntity);
        }
        return super.shouldRenderOffScreen(blockEntity);
    }

    public boolean shouldRender(T blockEntity, Vec3 cameraPos) {
        IBlockEntityRendererBakedModel berModel;
        BlockState blockState = blockEntity.getBlockState();
        BakedModel model = this.blockRenderDispatcher.getBlockModel(blockState);
        if (model instanceof IBlockEntityRendererBakedModel && (berModel = (IBlockEntityRendererBakedModel)model).getBlockEntityType() == blockEntity.getType()) {
            return berModel.shouldRender(blockEntity, cameraPos);
        }
        return super.shouldRender(blockEntity, cameraPos);
    }
}

