/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.monitor;

import com.gregtechceu.gtceu.client.renderer.monitor.IMonitorRenderer;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.CentralMonitorMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.monitor.MonitorGroup;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class MonitorTextRenderer
implements IMonitorRenderer {
    private static final float TEXT_SCALE = 0.0069444445f;
    private final List<Component> text;
    private final float scale;

    public MonitorTextRenderer(List<Component> text, double scale) {
        this.text = text;
        this.scale = (float)scale;
    }

    @Override
    public void render(CentralMonitorMachine machine, MonitorGroup group, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        try {
            BlockPos rel = group.getRow(0, machine::toRelative).get(0);
            int row = 0;
            int columns = group.getRow(0, machine::toRelative).size();
            poseStack.translate((float)rel.getX(), (float)rel.getY(), (float)rel.getZ());
            poseStack.scale(0.0069444445f * this.scale, 0.0069444445f * this.scale, 0.0069444445f * this.scale);
            float y = 9.0f;
            for (Component s : this.text) {
                boolean didAnything = false;
                for (FormattedCharSequence line : Minecraft.getInstance().font.split((FormattedText)s, Math.round((float)(columns * 135) / this.scale))) {
                    if (y >= 144.0f) {
                        try {
                            columns = group.getRow(++row, machine::toRelative).size();
                            y -= 144.0f;
                            poseStack.translate((float)(-rel.getX()) / (0.0069444445f * this.scale), (float)(-rel.getY()) / (0.0069444445f * this.scale), (float)(-rel.getZ()) / (0.0069444445f * this.scale));
                            rel = group.getRow(row, machine::toRelative).get(0);
                            poseStack.translate((float)rel.getX() / (0.0069444445f * this.scale), (float)rel.getY() / (0.0069444445f * this.scale), (float)rel.getZ() / (0.0069444445f * this.scale));
                        }
                        catch (IndexOutOfBoundsException e) {
                            return;
                        }
                    }
                    Minecraft.getInstance().font.drawInBatch(line, 9.0f, y, 0xFFFFFF, false, poseStack.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                    Objects.requireNonNull(Minecraft.getInstance().font);
                    y += 9.0f * this.scale;
                    didAnything = true;
                }
                if (didAnything) continue;
                Objects.requireNonNull(Minecraft.getInstance().font);
                y += 9.0f * this.scale;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }
}

