/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.block.explosive;

import com.gregtechceu.gtceu.common.entity.GTExplosiveEntity;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class GTExplosiveBlock
extends Block {
    private final boolean canRedstoneActivate;
    private final boolean explodeOnMine;
    private final int fuseLength;

    public GTExplosiveBlock(BlockBehaviour.Properties properties, boolean canRedstoneActivate, boolean explodeOnMine, int fuseLength) {
        super(properties.isValidSpawn((state, level, pos, ent) -> false).explosionResistance(1.0f));
        this.canRedstoneActivate = canRedstoneActivate;
        this.explodeOnMine = explodeOnMine;
        this.fuseLength = fuseLength;
    }

    protected abstract GTExplosiveEntity createEntity(@NotNull Level var1, @NotNull BlockPos var2, @Nullable LivingEntity var3);

    public boolean isCollisionShapeFullBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public boolean dropFromExplosion(Explosion explosion) {
        return false;
    }

    public void onCaughtFire(BlockState state, Level level, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
        this.explode(level, pos, igniter);
    }

    public void explode(Level level, BlockPos pos, @Nullable LivingEntity exploder) {
        if (!level.isClientSide) {
            GTExplosiveEntity entity = this.createEntity(level, pos, exploder);
            entity.setFuse(this.fuseLength);
            level.addFreshEntity((Entity)entity);
            level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.gameEvent((Entity)entity, GameEvent.PRIME_FUSE, pos);
        }
    }

    public void wasExploded(Level level, BlockPos pos, Explosion explosion) {
        if (!level.isClientSide) {
            GTExplosiveEntity entity = this.createEntity(level, pos, explosion.getIndirectSourceEntity());
            entity.setFuse(level.random.nextInt(this.fuseLength / 4) + this.fuseLength / 8);
            level.addFreshEntity((Entity)entity);
        }
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.getItemInHand(hand);
        if (!stack.isEmpty() && stack.is(CustomTags.TOOLS_IGNITER)) {
            this.explode(level, pos, (LivingEntity)player);
            level.removeBlock(pos, false);
            if (stack.isDamageableItem()) {
                stack.hurtAndBreak(1, (LivingEntity)player, p -> p.broadcastBreakEvent(hand));
            } else if (!player.isCreative()) {
                stack.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.use(state, level, pos, player, hand, hit);
    }

    public void playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (this.explodeOnMine && !player.isShiftKeyDown()) {
            this.explode(level, pos, (LivingEntity)player);
        }
        super.playerWillDestroy(level, pos, state, player);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        Arrow arrow;
        super.entityInside(state, level, pos, entity);
        if (!level.isClientSide && entity instanceof Arrow && (arrow = (Arrow)entity).isOnFire()) {
            LivingEntity living;
            Entity entity2 = arrow.getOwner();
            this.explode(level, pos, entity2 instanceof LivingEntity ? (living = (LivingEntity)entity2) : null);
            level.removeBlock(pos, false);
        }
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        if (this.canRedstoneActivate && level.hasNeighborSignal(pos)) {
            this.explode(level, pos, null);
            level.removeBlock(pos, false);
        }
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        Entity player;
        if (this.explodeOnMine && (player = (Entity)params.getOptionalParameter(LootContextParams.THIS_ENTITY)) != null && !player.isShiftKeyDown()) {
            return Collections.emptyList();
        }
        return super.getDrops(state, params);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (this.canRedstoneActivate && level.hasNeighborSignal(pos)) {
            this.explode(level, pos, null);
            level.removeBlock(pos, false);
        }
    }

    public void appendHoverText(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, level, tooltip, flag);
        if (this.explodeOnMine) {
            tooltip.add((Component)Component.translatable((String)"block.gtceu.explosive.breaking_tooltip"));
        }
        if (!this.canRedstoneActivate) {
            tooltip.add((Component)Component.translatable((String)"block.gtceu.explosive.lighting_tooltip"));
        }
    }
}

