/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.capability;

import com.gregtechceu.gtceu.api.placeholder.Placeholder;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class PlaceholderSavedData
extends SavedData {
    private final ServerLevel level;
    private final CompoundTag tag;

    public static PlaceholderSavedData getOrCreate(ServerLevel level) {
        return (PlaceholderSavedData)level.getDataStorage().computeIfAbsent(tag -> new PlaceholderSavedData(level, (CompoundTag)tag), () -> new PlaceholderSavedData(level), "gtceu_placeholder_data");
    }

    public PlaceholderSavedData(ServerLevel level) {
        this(level, new CompoundTag());
    }

    public PlaceholderSavedData(ServerLevel level, CompoundTag tag) {
        this.level = level;
        this.tag = tag.getCompound("data");
    }

    public CompoundTag getPlaceholderData(Placeholder placeholder) {
        if (!this.tag.contains(placeholder.getName())) {
            this.tag.put(placeholder.getName(), (Tag)new CompoundTag());
        }
        return this.tag.getCompound(placeholder.getName());
    }

    public CompoundTag save(CompoundTag tag) {
        tag.put("data", (Tag)this.tag);
        return tag;
    }
}

