/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.data;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.IComponentItem;
import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.api.item.LampBlockItem;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.registry.registrate.GTRegistrate;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.pipelike.cable.Insulation;
import com.gregtechceu.gtceu.common.registry.GTRegistration;
import com.tterrag.registrate.util.entry.RegistryEntry;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class GTCreativeModeTabs {
    public static RegistryEntry<CreativeModeTab> MATERIAL_FLUID = GTRegistration.REGISTRATE.defaultCreativeTab("material_fluid", builder -> builder.displayItems((CreativeModeTab.DisplayItemsGenerator)new RegistrateDisplayItemsGenerator("material_fluid", GTRegistration.REGISTRATE)).icon(() -> GTItems.FLUID_CELL.asStack()).title((Component)GTRegistration.REGISTRATE.addLang("itemGroup", GTCEu.id("material_fluid"), "GregTechCEu Material Fluid Containers")).build()).register();
    public static RegistryEntry<CreativeModeTab> MATERIAL_ITEM = GTRegistration.REGISTRATE.defaultCreativeTab("material_item", builder -> builder.displayItems((CreativeModeTab.DisplayItemsGenerator)new RegistrateDisplayItemsGenerator("material_item", GTRegistration.REGISTRATE)).icon(() -> ChemicalHelper.get(TagPrefix.ingot, GTMaterials.Aluminium)).title((Component)GTRegistration.REGISTRATE.addLang("itemGroup", GTCEu.id("material_item"), "GregTechCEu Material Items")).build()).register();
    public static RegistryEntry<CreativeModeTab> MATERIAL_BLOCK = GTRegistration.REGISTRATE.defaultCreativeTab("material_block", builder -> builder.displayItems((CreativeModeTab.DisplayItemsGenerator)new RegistrateDisplayItemsGenerator("material_block", GTRegistration.REGISTRATE)).icon(() -> ChemicalHelper.get(TagPrefix.block, GTMaterials.Gold)).title((Component)GTRegistration.REGISTRATE.addLang("itemGroup", GTCEu.id("material_block"), "GregTechCEu Material Blocks")).build()).register();
    public static RegistryEntry<CreativeModeTab> MATERIAL_PIPE = GTRegistration.REGISTRATE.defaultCreativeTab("material_pipe", builder -> builder.displayItems((CreativeModeTab.DisplayItemsGenerator)new RegistrateDisplayItemsGenerator("material_pipe", GTRegistration.REGISTRATE)).icon(() -> ChemicalHelper.get(Insulation.WIRE_DOUBLE.getTagPrefix(), GTMaterials.Copper)).title((Component)GTRegistration.REGISTRATE.addLang("itemGroup", GTCEu.id("material_pipe"), "GregTechCEu Material Pipes")).build()).register();
    public static RegistryEntry<CreativeModeTab> DECORATION = GTRegistration.REGISTRATE.defaultCreativeTab("decoration", builder -> builder.displayItems((CreativeModeTab.DisplayItemsGenerator)new RegistrateDisplayItemsGenerator("decoration", GTRegistration.REGISTRATE)).icon(() -> GTBlocks.COIL_CUPRONICKEL.asStack()).title((Component)GTRegistration.REGISTRATE.addLang("itemGroup", GTCEu.id("decoration"), "GregTechCEu Decoration Blocks")).build()).register();
    public static RegistryEntry<CreativeModeTab> TOOL = GTRegistration.REGISTRATE.defaultCreativeTab("tool", builder -> builder.displayItems((CreativeModeTab.DisplayItemsGenerator)new RegistrateDisplayItemsGenerator("tool", GTRegistration.REGISTRATE)).icon(() -> ToolHelper.get(GTToolType.WRENCH, GTMaterials.Steel)).title((Component)GTRegistration.REGISTRATE.addLang("itemGroup", GTCEu.id("tool"), "GregTechCEu Tools")).build()).register();
    public static RegistryEntry<CreativeModeTab> MACHINE = GTRegistration.REGISTRATE.defaultCreativeTab("machine", builder -> builder.displayItems((CreativeModeTab.DisplayItemsGenerator)new RegistrateDisplayItemsGenerator("machine", GTRegistration.REGISTRATE)).icon(() -> GTMachines.ELECTROLYZER[1].asStack()).title((Component)GTRegistration.REGISTRATE.addLang("itemGroup", GTCEu.id("machine"), "GregTechCEu Machines")).build()).register();
    public static RegistryEntry<CreativeModeTab> ITEM = GTRegistration.REGISTRATE.defaultCreativeTab("item", builder -> builder.displayItems((CreativeModeTab.DisplayItemsGenerator)new RegistrateDisplayItemsGenerator("item", GTRegistration.REGISTRATE)).icon(() -> GTItems.BASIC_TAPE.asStack()).title((Component)GTRegistration.REGISTRATE.addLang("itemGroup", GTCEu.id("item"), "GregTechCEu Items")).build()).register();

    public static void init() {
    }

    public static class RegistrateDisplayItemsGenerator
    implements CreativeModeTab.DisplayItemsGenerator {
        public final String name;
        public final GTRegistrate registrate;

        public RegistrateDisplayItemsGenerator(String name, GTRegistrate registrate) {
            this.name = name;
            this.registrate = registrate;
        }

        public void accept(@NotNull CreativeModeTab.ItemDisplayParameters itemDisplayParameters, @NotNull CreativeModeTab.Output output) {
            IGTTool tool;
            IComponentItem componentItem;
            Item item;
            RegistryEntry tab = this.registrate.get(this.name, Registries.CREATIVE_MODE_TAB);
            for (RegistryEntry entry : this.registrate.getAll(Registries.BLOCK)) {
                NonNullList list;
                if (!this.registrate.isInCreativeTab(entry, (RegistryEntry<CreativeModeTab>)tab) || (item = ((Block)entry.get()).asItem()) == Items.AIR) continue;
                if (item instanceof IComponentItem) {
                    componentItem = (IComponentItem)item;
                    list = NonNullList.create();
                    componentItem.fillItemCategory((CreativeModeTab)tab.get(), (NonNullList<ItemStack>)list);
                    list.forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
                    continue;
                }
                if (item instanceof IGTTool) {
                    tool = (IGTTool)item;
                    list = NonNullList.create();
                    tool.definition$fillItemCategory((CreativeModeTab)tab.get(), (NonNullList<ItemStack>)list);
                    list.forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
                    continue;
                }
                if (item instanceof LampBlockItem) {
                    LampBlockItem lamp = (LampBlockItem)item;
                    list = NonNullList.create();
                    lamp.fillItemCategory((CreativeModeTab)tab.get(), (NonNullList<ItemStack>)list);
                    list.forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
                    continue;
                }
                output.accept((ItemLike)item);
            }
            for (RegistryEntry entry : this.registrate.getAll(Registries.ITEM)) {
                NonNullList list;
                if (!this.registrate.isInCreativeTab(entry, (RegistryEntry<CreativeModeTab>)tab) || (item = (Item)entry.get()) instanceof BlockItem) continue;
                if (item instanceof IComponentItem) {
                    componentItem = (IComponentItem)item;
                    list = NonNullList.create();
                    componentItem.fillItemCategory((CreativeModeTab)tab.get(), (NonNullList<ItemStack>)list);
                    list.forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
                    continue;
                }
                if (item instanceof IGTTool) {
                    tool = (IGTTool)item;
                    list = NonNullList.create();
                    tool.definition$fillItemCategory((CreativeModeTab)tab.get(), (NonNullList<ItemStack>)list);
                    list.forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
                    continue;
                }
                output.accept((ItemLike)item);
            }
        }
    }
}

