/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.data;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.registry.MaterialRegistry;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKeys;
import com.gregtechceu.gtceu.api.registry.registrate.GTRegistrate;
import com.gregtechceu.gtceu.common.data.GTCreativeModeTabs;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.fluid.potion.PotionFluid;
import com.gregtechceu.gtceu.common.registry.GTRegistration;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.tterrag.registrate.util.entry.FluidEntry;
import java.util.function.Supplier;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;

public class GTFluids {
    public static final FluidEntry<PotionFluid> POTION = GTRegistration.REGISTRATE.fluid("potion", GTCEu.id("block/fluids/fluid.potion"), GTCEu.id("block/fluids/fluid.potion"), PotionFluid.PotionFluidType::new, PotionFluid::new).lang("Potion").source(PotionFluid::new).noBlock().noBucket().tag(new TagKey[]{CustomTags.POTION_FLUIDS}).register();

    public static void init() {
        GTFluids.handleNonMaterialFluids(GTMaterials.Water, (Fluid)Fluids.WATER);
        GTFluids.handleNonMaterialFluids(GTMaterials.Lava, (Fluid)Fluids.LAVA);
        GTFluids.handleNonMaterialFluids(GTMaterials.Milk, (Supplier<Fluid>)ForgeMod.MILK);
        ForgeMod.enableMilkFluid();
        GTRegistration.REGISTRATE.creativeModeTab(() -> GTCreativeModeTabs.MATERIAL_FLUID);
        for (MaterialRegistry registry : GTCEuAPI.materialManager.getRegistries()) {
            GTRegistrate registrate = registry.getRegistrate();
            for (Material material : registry.getAllMaterials()) {
                FluidProperty fluidProperty = material.getProperty(PropertyKey.FLUID);
                if (fluidProperty == null) continue;
                fluidProperty.registerFluids(material, registrate);
            }
        }
    }

    public static void handleNonMaterialFluids(@NotNull Material material, @NotNull Fluid fluid) {
        FluidProperty property = material.getProperty(PropertyKey.FLUID);
        property.getStorage().store(FluidStorageKeys.LIQUID, () -> fluid, null);
    }

    public static void handleNonMaterialFluids(@NotNull Material material, @NotNull Supplier<Fluid> fluid) {
        FluidProperty property = material.getProperty(PropertyKey.FLUID);
        property.getStorage().store(FluidStorageKeys.LIQUID, fluid, null);
    }
}

