/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.data;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.ICoilType;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.gui.widget.TankWidget;
import com.gregtechceu.gtceu.api.recipe.FacadeCoverRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeSerializer;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.ShapedEnergyTransferRecipe;
import com.gregtechceu.gtceu.api.recipe.ShapedFluidContainerRecipe;
import com.gregtechceu.gtceu.api.recipe.StrictShapedRecipe;
import com.gregtechceu.gtceu.api.recipe.ToolHeadReplaceRecipe;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.api.sound.ExistingSoundEntry;
import com.gregtechceu.gtceu.common.data.GCYMRecipeTypes;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTSoundEntries;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.FusionReactorMachine;
import com.gregtechceu.gtceu.common.machine.trait.customlogic.ArcFurnaceLogic;
import com.gregtechceu.gtceu.common.machine.trait.customlogic.BreweryLogic;
import com.gregtechceu.gtceu.common.machine.trait.customlogic.CannerLogic;
import com.gregtechceu.gtceu.common.machine.trait.customlogic.FormingPressLogic;
import com.gregtechceu.gtceu.common.machine.trait.customlogic.MaceratorLogic;
import com.gregtechceu.gtceu.common.recipe.condition.AdjacentFluidCondition;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.gregtechceu.gtceu.integration.kjs.GTRegistryInfo;
import com.gregtechceu.gtceu.integration.xei.entry.fluid.FluidEntryList;
import com.gregtechceu.gtceu.integration.xei.entry.fluid.FluidHolderSetList;
import com.gregtechceu.gtceu.integration.xei.handlers.fluid.CycleFluidEntryHandler;
import com.gregtechceu.gtceu.integration.xei.handlers.item.CycleItemStackHandler;
import com.gregtechceu.gtceu.utils.GTMath;
import com.gregtechceu.gtceu.utils.ResearchManager;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fml.ModLoader;

public class GTRecipeTypes {
    public static final String STEAM = "steam";
    public static final String ELECTRIC = "electric";
    public static final String GENERATOR = "generator";
    public static final String MULTIBLOCK = "multiblock";
    public static final String DUMMY = "dummy";
    public static final GTRecipeType STEAM_BOILER_RECIPES;
    public static final GTRecipeType FURNACE_RECIPES;
    public static final GTRecipeType ALLOY_SMELTER_RECIPES;
    public static final GTRecipeType ARC_FURNACE_RECIPES;
    public static final GTRecipeType ASSEMBLER_RECIPES;
    public static final GTRecipeType AUTOCLAVE_RECIPES;
    public static final GTRecipeType BENDER_RECIPES;
    public static final GTRecipeType BREWING_RECIPES;
    public static final GTRecipeType MACERATOR_RECIPES;
    public static final GTRecipeType CANNER_RECIPES;
    public static final GTRecipeType CENTRIFUGE_RECIPES;
    public static final GTRecipeType CHEMICAL_BATH_RECIPES;
    public static final GTRecipeType CHEMICAL_RECIPES;
    public static final GTRecipeType COMPRESSOR_RECIPES;
    public static final GTRecipeType CUTTER_RECIPES;
    public static final GTRecipeType DISTILLERY_RECIPES;
    public static final GTRecipeType ELECTROLYZER_RECIPES;
    public static final GTRecipeType ELECTROMAGNETIC_SEPARATOR_RECIPES;
    public static final GTRecipeType EXTRACTOR_RECIPES;
    public static final GTRecipeType EXTRUDER_RECIPES;
    public static final GTRecipeType FERMENTING_RECIPES;
    public static final GTRecipeType FLUID_HEATER_RECIPES;
    public static final GTRecipeType FLUID_SOLIDFICATION_RECIPES;
    public static final GTRecipeType FORGE_HAMMER_RECIPES;
    public static final GTRecipeType FORMING_PRESS_RECIPES;
    public static final GTRecipeType LATHE_RECIPES;
    public static final GTRecipeType MIXER_RECIPES;
    public static final GTRecipeType ORE_WASHER_RECIPES;
    public static final GTRecipeType PACKER_RECIPES;
    public static final GTRecipeType POLARIZER_RECIPES;
    public static final GTRecipeType LASER_ENGRAVER_RECIPES;
    public static final GTRecipeType SIFTER_RECIPES;
    public static final GTRecipeType THERMAL_CENTRIFUGE_RECIPES;
    public static final GTRecipeType WIREMILL_RECIPES;
    public static final GTRecipeType CIRCUIT_ASSEMBLER_RECIPES;
    public static final GTRecipeType GAS_COLLECTOR_RECIPES;
    public static final GTRecipeType AIR_SCRUBBER_RECIPES;
    public static final GTRecipeType RESEARCH_STATION_RECIPES;
    public static final GTRecipeType ROCK_BREAKER_RECIPES;
    public static final GTRecipeType SCANNER_RECIPES;
    public static final GTRecipeType COMBUSTION_GENERATOR_FUELS;
    public static final GTRecipeType GAS_TURBINE_FUELS;
    public static final GTRecipeType STEAM_TURBINE_FUELS;
    public static final GTRecipeType PLASMA_GENERATOR_FUELS;
    public static final GTRecipeType LARGE_BOILER_RECIPES;
    public static final GTRecipeType COKE_OVEN_RECIPES;
    public static final GTRecipeType PRIMITIVE_BLAST_FURNACE_RECIPES;
    public static final GTRecipeType BLAST_RECIPES;
    public static final GTRecipeType DISTILLATION_RECIPES;
    public static final GTRecipeType PYROLYSE_RECIPES;
    public static final GTRecipeType CRACKING_RECIPES;
    public static final GTRecipeType IMPLOSION_RECIPES;
    public static final GTRecipeType VACUUM_RECIPES;
    public static final GTRecipeType ASSEMBLY_LINE_RECIPES;
    public static final GTRecipeType LARGE_CHEMICAL_RECIPES;
    public static final GTRecipeType FUSION_RECIPES;
    public static final GTRecipeType DUMMY_RECIPES;

    public static GTRecipeType register(String name, String group, RecipeType<?> ... proxyRecipes) {
        GTRecipeType recipeType = new GTRecipeType(GTCEu.id(name), group, proxyRecipes);
        GTRegistries.register(BuiltInRegistries.RECIPE_TYPE, recipeType.registryName, recipeType);
        GTRegistries.register(BuiltInRegistries.RECIPE_SERIALIZER, recipeType.registryName, new GTRecipeSerializer());
        GTRegistries.RECIPE_TYPES.register(recipeType.registryName, recipeType);
        return recipeType;
    }

    public static void init() {
        GCYMRecipeTypes.init();
        if (GTCEu.Mods.isKubeJSLoaded()) {
            GTRegistryInfo.registerFor(GTRegistries.RECIPE_TYPES.getRegistryName());
        }
        ModLoader.get().postEvent(new GTCEuAPI.RegisterEvent(GTRegistries.RECIPE_TYPES, GTRecipeType.class));
        GTRegistries.RECIPE_TYPES.freeze();
        GTRegistries.register(BuiltInRegistries.RECIPE_SERIALIZER, GTCEu.id("machine"), GTRecipeSerializer.SERIALIZER);
        GTRegistries.register(BuiltInRegistries.RECIPE_SERIALIZER, GTCEu.id("crafting_facade_cover"), FacadeCoverRecipe.SERIALIZER);
        GTRegistries.register(BuiltInRegistries.RECIPE_SERIALIZER, GTCEu.id("crafting_shaped_strict"), StrictShapedRecipe.SERIALIZER);
        GTRegistries.register(BuiltInRegistries.RECIPE_SERIALIZER, GTCEu.id("crafting_shaped_energy_transfer"), ShapedEnergyTransferRecipe.SERIALIZER);
        GTRegistries.register(BuiltInRegistries.RECIPE_SERIALIZER, GTCEu.id("crafting_tool_head_replace"), ToolHeadReplaceRecipe.SERIALIZER);
        GTRegistries.register(BuiltInRegistries.RECIPE_SERIALIZER, GTCEu.id("crafting_shaped_fluid_container"), ShapedFluidContainerRecipe.SERIALIZER);
    }

    public static GTRecipeType get(String name) {
        return (GTRecipeType)GTRegistries.RECIPE_TYPES.get(GTCEu.id(name));
    }

    static {
        GTRegistries.RECIPE_TYPES.unfreeze();
        GTRegistries.RECIPE_CATEGORIES.unfreeze();
        STEAM_BOILER_RECIPES = GTRecipeTypes.register("steam_boiler", STEAM, new RecipeType[0]).setMaxIOSize(1, 0, 1, 1).setProgressBar(GuiTextures.PROGRESS_BAR_BOILER_FUEL.get(true), ProgressTexture.FillDirection.DOWN_TO_UP).onRecipeBuild((builder, provider) -> {
            int duration = builder.duration / 4;
            if (duration > 0) {
                LARGE_BOILER_RECIPES.copyFrom((GTRecipeBuilder)builder).duration(duration).save((Consumer<FinishedRecipe>)provider);
            }
        }).setMaxTooltips(1).setSound(GTSoundEntries.FURNACE);
        FURNACE_RECIPES = GTRecipeTypes.register("electric_furnace", ELECTRIC, RecipeType.SMELTING).setMaxIOSize(1, 1, 0, 0).setEUIO(IO.IN).prepareBuilder(recipeBuilder -> recipeBuilder.EUt(4L)).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.FURNACE_OVERLAY_1).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSteamProgressBar(GuiTextures.PROGRESS_BAR_ARROW_STEAM, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.FURNACE);
        ALLOY_SMELTER_RECIPES = GTRecipeTypes.register("alloy_smelter", ELECTRIC, new RecipeType[0]).setMaxIOSize(2, 1, 0, 0).setEUIO(IO.IN).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.FURNACE_OVERLAY_1).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setIconSupplier(() -> GTMachines.ALLOY_SMELTER[1].asStack()).setSteamProgressBar(GuiTextures.PROGRESS_BAR_ARROW_STEAM, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.FURNACE);
        ARC_FURNACE_RECIPES = GTRecipeTypes.register("arc_furnace", ELECTRIC, new RecipeType[0]).setMaxIOSize(1, 4, 1, 1).setEUIO(IO.IN).setProgressBar(GuiTextures.PROGRESS_BAR_ARC_FURNACE, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.ARC).onRecipeBuild((recipeBuilder, provider) -> {
            if (recipeBuilder.input.getOrDefault(FluidRecipeCapability.CAP, Collections.emptyList()).isEmpty() && recipeBuilder.tickInput.getOrDefault(FluidRecipeCapability.CAP, Collections.emptyList()).isEmpty()) {
                recipeBuilder.inputFluids(GTMaterials.Oxygen.getFluid(recipeBuilder.duration));
            }
        }).addCustomRecipeLogic(ArcFurnaceLogic.INSTANCE);
        ASSEMBLER_RECIPES = GTRecipeTypes.register("assembler", ELECTRIC, new RecipeType[0]).setMaxIOSize(9, 1, 1, 0).setEUIO(IO.IN).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.SLOT).setProgressBar(GuiTextures.PROGRESS_BAR_ASSEMBLER, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.ASSEMBLER);
        AUTOCLAVE_RECIPES = GTRecipeTypes.register("autoclave", ELECTRIC, new RecipeType[0]).setMaxIOSize(2, 2, 1, 1).setEUIO(IO.IN).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.DUST_OVERLAY).setSlotOverlay(true, false, (IGuiTexture)GuiTextures.CRYSTAL_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_CRYSTALLIZATION, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.FURNACE);
        BENDER_RECIPES = GTRecipeTypes.register("bender", ELECTRIC, new RecipeType[0]).setMaxIOSize(2, 1, 0, 0).setEUIO(IO.IN).setSlotOverlay(false, false, false, (IGuiTexture)GuiTextures.BENDER_OVERLAY).setSlotOverlay(false, false, true, (IGuiTexture)GuiTextures.INT_CIRCUIT_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_BENDING, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.MOTOR);
        BREWING_RECIPES = GTRecipeTypes.register("brewery", ELECTRIC, new RecipeType[0]).setMaxIOSize(1, 0, 1, 1).setEUIO(IO.IN).prepareBuilder(recipeBuilder -> recipeBuilder.duration(128).EUt(4L)).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.BREWER_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW_MULTIPLE, ProgressTexture.FillDirection.LEFT_TO_RIGHT).addCustomRecipeLogic(BreweryLogic.INSTANCE).setSound(GTSoundEntries.CHEMICAL);
        MACERATOR_RECIPES = GTRecipeTypes.register("macerator", ELECTRIC, new RecipeType[0]).setMaxIOSize(1, 4, 0, 0).setEUIO(IO.IN).prepareBuilder(recipeBuilder -> recipeBuilder.duration(150).EUt(2L)).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.CRUSHED_ORE_OVERLAY).setSlotOverlay(true, false, (IGuiTexture)GuiTextures.DUST_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_MACERATE, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setIconSupplier(() -> GTMachines.MACERATOR[1].asStack()).setSteamProgressBar(GuiTextures.PROGRESS_BAR_MACERATE_STEAM, ProgressTexture.FillDirection.LEFT_TO_RIGHT).addCustomRecipeLogic(MaceratorLogic.INSTANCE).setSound(GTSoundEntries.MACERATOR).addDataInfo(data -> LocalizationUtils.format((String)"gtceu.recipe.byproduct_tier", (Object[])new Object[]{GTValues.VNF[3]}));
        CANNER_RECIPES = GTRecipeTypes.register("canner", ELECTRIC, new RecipeType[0]).setMaxIOSize(2, 2, 1, 1).setEUIO(IO.IN).setSlotOverlay(false, false, false, (IGuiTexture)GuiTextures.CANNER_OVERLAY).setSlotOverlay(false, false, true, (IGuiTexture)GuiTextures.CANISTER_OVERLAY).setSlotOverlay(true, false, (IGuiTexture)GuiTextures.CANISTER_OVERLAY).setSlotOverlay(false, true, (IGuiTexture)GuiTextures.DARK_CANISTER_OVERLAY).setSlotOverlay(true, true, (IGuiTexture)GuiTextures.DARK_CANISTER_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_CANNER, ProgressTexture.FillDirection.LEFT_TO_RIGHT).addCustomRecipeLogic(CannerLogic.INSTANCE).setSound(GTSoundEntries.BATH);
        CENTRIFUGE_RECIPES = GTRecipeTypes.register("centrifuge", ELECTRIC, new RecipeType[0]).setMaxIOSize(2, 6, 1, 6).setEUIO(IO.IN).prepareBuilder(recipeBuilder -> recipeBuilder.EUt(5L)).setSlotOverlay(false, false, false, (IGuiTexture)GuiTextures.EXTRACTOR_OVERLAY).setSlotOverlay(false, false, true, (IGuiTexture)GuiTextures.CANISTER_OVERLAY).setSlotOverlay(false, true, true, (IGuiTexture)GuiTextures.CENTRIFUGE_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_EXTRACT, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.CENTRIFUGE);
        CHEMICAL_BATH_RECIPES = GTRecipeTypes.register("chemical_bath", ELECTRIC, new RecipeType[0]).setMaxIOSize(1, 6, 1, 1).setEUIO(IO.IN).prepareBuilder(recipeBuilder -> recipeBuilder.EUt(GTValues.VA[1])).setSlotOverlay(false, false, true, (IGuiTexture)GuiTextures.BREWER_OVERLAY).setSlotOverlay(true, false, false, (IGuiTexture)GuiTextures.DUST_OVERLAY).setSlotOverlay(true, false, true, (IGuiTexture)GuiTextures.DUST_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_MIXER, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.BATH);
        CHEMICAL_RECIPES = GTRecipeTypes.register("chemical_reactor", ELECTRIC, new RecipeType[0]).setMaxIOSize(2, 2, 3, 2).setEUIO(IO.IN).prepareBuilder(recipeBuilder -> recipeBuilder.EUt(GTValues.VA[1])).setSlotOverlay(false, false, false, (IGuiTexture)GuiTextures.MOLECULAR_OVERLAY_1).setSlotOverlay(false, false, true, (IGuiTexture)GuiTextures.MOLECULAR_OVERLAY_2).setSlotOverlay(false, true, false, (IGuiTexture)GuiTextures.MOLECULAR_OVERLAY_3).setSlotOverlay(false, true, true, (IGuiTexture)GuiTextures.MOLECULAR_OVERLAY_4).setSlotOverlay(true, false, (IGuiTexture)GuiTextures.VIAL_OVERLAY_1).setSlotOverlay(true, true, (IGuiTexture)GuiTextures.VIAL_OVERLAY_2).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW_MULTIPLE, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTValues.FOOLS.getAsBoolean() ? GTSoundEntries.SCIENCE : GTSoundEntries.CHEMICAL).onRecipeBuild((recipeBuilder, provider) -> LARGE_CHEMICAL_RECIPES.copyFrom((GTRecipeBuilder)recipeBuilder).save((Consumer<FinishedRecipe>)provider));
        COMPRESSOR_RECIPES = GTRecipeTypes.register("compressor", ELECTRIC, new RecipeType[0]).setMaxIOSize(1, 1, 0, 0).setEUIO(IO.IN).prepareBuilder(recipeBuilder -> recipeBuilder.duration(200).EUt(2L)).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.COMPRESSOR_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_COMPRESS, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setIconSupplier(() -> GTMachines.COMPRESSOR[1].asStack()).setSteamProgressBar(GuiTextures.PROGRESS_BAR_COMPRESS_STEAM, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.COMPRESSOR);
        CUTTER_RECIPES = GTRecipeTypes.register("cutter", ELECTRIC, new RecipeType[0]).setMaxIOSize(1, 2, 1, 0).setEUIO(IO.IN).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.SAWBLADE_OVERLAY).setSlotOverlay(true, false, false, (IGuiTexture)GuiTextures.CUTTER_OVERLAY).setSlotOverlay(true, false, true, (IGuiTexture)GuiTextures.DUST_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_SLICE, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.CUT).onRecipeBuild((recipeBuilder, provider) -> {
            if (recipeBuilder.input.getOrDefault(FluidRecipeCapability.CAP, Collections.emptyList()).isEmpty() && recipeBuilder.tickInput.getOrDefault(FluidRecipeCapability.CAP, Collections.emptyList()).isEmpty()) {
                recipeBuilder.copy(new ResourceLocation(recipeBuilder.id.toString() + "_water")).inputFluids(GTMaterials.Water.getFluid((int)GTMath.clamp((long)recipeBuilder.duration * recipeBuilder.EUt().getTotalEU() / 320L, 4L, 1000L))).duration(recipeBuilder.duration * 2).save((Consumer<FinishedRecipe>)provider);
                recipeBuilder.copy(new ResourceLocation(recipeBuilder.id.toString() + "_distilled_water")).inputFluids(GTMaterials.DistilledWater.getFluid((int)GTMath.clamp((long)recipeBuilder.duration * recipeBuilder.EUt().getTotalEU() / 426L, 3L, 750L))).duration((int)((double)recipeBuilder.duration * 1.5)).save((Consumer<FinishedRecipe>)provider);
                recipeBuilder.inputFluids(GTMaterials.Lubricant.getFluid((int)GTMath.clamp((long)recipeBuilder.duration * recipeBuilder.EUt().getTotalEU() / 1280L, 1L, 250L)));
            }
        });
        DISTILLERY_RECIPES = GTRecipeTypes.register("distillery", ELECTRIC, new RecipeType[0]).setMaxIOSize(1, 1, 1, 1).setEUIO(IO.IN).setSlotOverlay(false, true, (IGuiTexture)GuiTextures.BEAKER_OVERLAY_1).setSlotOverlay(true, true, (IGuiTexture)GuiTextures.BEAKER_OVERLAY_4).setSlotOverlay(true, false, (IGuiTexture)GuiTextures.DUST_OVERLAY).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.INT_CIRCUIT_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW_MULTIPLE, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.BOILER);
        ELECTROLYZER_RECIPES = GTRecipeTypes.register("electrolyzer", ELECTRIC, new RecipeType[0]).setMaxIOSize(2, 6, 1, 6).setEUIO(IO.IN).setSlotOverlay(false, false, false, (IGuiTexture)GuiTextures.LIGHTNING_OVERLAY_1).setSlotOverlay(false, false, true, (IGuiTexture)GuiTextures.CANISTER_OVERLAY).setSlotOverlay(false, true, true, (IGuiTexture)GuiTextures.LIGHTNING_OVERLAY_2).setProgressBar(GuiTextures.PROGRESS_BAR_EXTRACT, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.ELECTROLYZER);
        ELECTROMAGNETIC_SEPARATOR_RECIPES = GTRecipeTypes.register("electromagnetic_separator", ELECTRIC, new RecipeType[0]).setMaxIOSize(1, 3, 0, 0).setEUIO(IO.IN).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.CRUSHED_ORE_OVERLAY).setSlotOverlay(true, false, (IGuiTexture)GuiTextures.DUST_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_MAGNET, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.ARC);
        EXTRACTOR_RECIPES = GTRecipeTypes.register("extractor", ELECTRIC, new RecipeType[0]).setMaxIOSize(1, 1, 0, 1).setEUIO(IO.IN).prepareBuilder(recipeBuilder -> recipeBuilder.duration(400).EUt(2L)).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.EXTRACTOR_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_EXTRACT, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setIconSupplier(() -> GTMachines.EXTRACTOR[1].asStack()).setSteamProgressBar(GuiTextures.PROGRESS_BAR_EXTRACT_STEAM, ProgressTexture.FillDirection.LEFT_TO_RIGHT);
        EXTRUDER_RECIPES = GTRecipeTypes.register("extruder", ELECTRIC, new RecipeType[0]).setMaxIOSize(2, 1, 0, 0).setEUIO(IO.IN).setSlotOverlay(false, false, true, (IGuiTexture)GuiTextures.MOLD_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_EXTRUDER, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.COMPRESSOR);
        FERMENTING_RECIPES = GTRecipeTypes.register("fermenter", ELECTRIC, new RecipeType[0]).setMaxIOSize(1, 1, 1, 1).setEUIO(IO.IN).prepareBuilder(recipeBuilder -> recipeBuilder.EUt(2L)).setSlotOverlay(false, false, true, (IGuiTexture)GuiTextures.DUST_OVERLAY).setSlotOverlay(true, false, true, (IGuiTexture)GuiTextures.DUST_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.CHEMICAL);
        FLUID_HEATER_RECIPES = GTRecipeTypes.register("fluid_heater", ELECTRIC, new RecipeType[0]).setMaxIOSize(1, 0, 1, 1).setEUIO(IO.IN).setSlotOverlay(false, true, (IGuiTexture)GuiTextures.HEATING_OVERLAY_1).setSlotOverlay(true, true, (IGuiTexture)GuiTextures.HEATING_OVERLAY_2).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.INT_CIRCUIT_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.BOILER);
        FLUID_SOLIDFICATION_RECIPES = GTRecipeTypes.register("fluid_solidifier", ELECTRIC, new RecipeType[0]).setMaxIOSize(1, 1, 1, 0).setEUIO(IO.IN).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.SOLIDIFIER_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.COOLING);
        FORGE_HAMMER_RECIPES = GTRecipeTypes.register("forge_hammer", ELECTRIC, new RecipeType[0]).setMaxIOSize(1, 1, 0, 0).setEUIO(IO.IN).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.HAMMER_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_HAMMER, ProgressTexture.FillDirection.UP_TO_DOWN).setIconSupplier(() -> GTMachines.FORGE_HAMMER[1].asStack()).setSteamProgressBar(GuiTextures.PROGRESS_BAR_HAMMER_STEAM, ProgressTexture.FillDirection.UP_TO_DOWN).setSound(GTSoundEntries.FORGE_HAMMER);
        FORMING_PRESS_RECIPES = GTRecipeTypes.register("forming_press", ELECTRIC, new RecipeType[0]).setMaxIOSize(6, 1, 0, 0).setEUIO(IO.IN).setProgressBar(GuiTextures.PROGRESS_BAR_COMPRESS, ProgressTexture.FillDirection.LEFT_TO_RIGHT).addCustomRecipeLogic(FormingPressLogic.INSTANCE).setSound(GTSoundEntries.COMPRESSOR);
        LATHE_RECIPES = GTRecipeTypes.register("lathe", ELECTRIC, new RecipeType[0]).setMaxIOSize(1, 2, 0, 0).setEUIO(IO.IN).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.PIPE_OVERLAY_1).setSlotOverlay(true, false, false, (IGuiTexture)GuiTextures.PIPE_OVERLAY_2).setSlotOverlay(true, false, true, (IGuiTexture)GuiTextures.DUST_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_LATHE, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.CUT);
        MIXER_RECIPES = GTRecipeTypes.register("mixer", ELECTRIC, new RecipeType[0]).setMaxIOSize(6, 1, 2, 1).setEUIO(IO.IN).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.DUST_OVERLAY).setSlotOverlay(true, false, (IGuiTexture)GuiTextures.DUST_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_MIXER, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.MIXER);
        ORE_WASHER_RECIPES = GTRecipeTypes.register("ore_washer", ELECTRIC, new RecipeType[0]).setMaxIOSize(2, 3, 1, 0).setEUIO(IO.IN).prepareBuilder(recipeBuilder -> recipeBuilder.duration(400).EUt(16L)).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.CRUSHED_ORE_OVERLAY).setSlotOverlay(true, false, (IGuiTexture)GuiTextures.DUST_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_BATH, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.BATH);
        PACKER_RECIPES = GTRecipeTypes.register("packer", ELECTRIC, new RecipeType[0]).setMaxIOSize(2, 2, 0, 0).setEUIO(IO.IN).prepareBuilder(recipeBuilder -> recipeBuilder.EUt(12L).duration(10)).setSlotOverlay(false, false, true, (IGuiTexture)GuiTextures.BOX_OVERLAY).setSlotOverlay(true, false, (IGuiTexture)GuiTextures.BOXED_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_UNPACKER, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.ASSEMBLER);
        POLARIZER_RECIPES = GTRecipeTypes.register("polarizer", ELECTRIC, new RecipeType[0]).setMaxIOSize(1, 1, 0, 0).setEUIO(IO.IN).setProgressBar(GuiTextures.PROGRESS_BAR_MAGNET, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.ARC);
        LASER_ENGRAVER_RECIPES = GTRecipeTypes.register("laser_engraver", ELECTRIC, new RecipeType[0]).setMaxIOSize(2, 1, 0, 0).setEUIO(IO.IN).setSlotOverlay(false, false, true, (IGuiTexture)GuiTextures.LENS_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.ELECTROLYZER);
        SIFTER_RECIPES = GTRecipeTypes.register("sifter", ELECTRIC, new RecipeType[0]).setMaxIOSize(1, 6, 0, 0).setEUIO(IO.IN).setProgressBar(GuiTextures.PROGRESS_BAR_SIFT, ProgressTexture.FillDirection.UP_TO_DOWN).setSound(new ExistingSoundEntry(SoundEvents.SAND_PLACE, SoundSource.BLOCKS));
        THERMAL_CENTRIFUGE_RECIPES = GTRecipeTypes.register("thermal_centrifuge", ELECTRIC, new RecipeType[0]).setMaxIOSize(1, 3, 0, 0).setEUIO(IO.IN).prepareBuilder(recipeBuilder -> recipeBuilder.duration(400).EUt(30L)).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.CRUSHED_ORE_OVERLAY).setSlotOverlay(true, false, (IGuiTexture)GuiTextures.DUST_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.CENTRIFUGE);
        WIREMILL_RECIPES = GTRecipeTypes.register("wiremill", ELECTRIC, new RecipeType[0]).setMaxIOSize(2, 1, 0, 0).setEUIO(IO.IN).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.WIREMILL_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_WIREMILL, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.MOTOR);
        CIRCUIT_ASSEMBLER_RECIPES = GTRecipeTypes.register("circuit_assembler", ELECTRIC, new RecipeType[0]).setMaxIOSize(6, 1, 1, 0).setEUIO(IO.IN).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.CIRCUIT_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_CIRCUIT_ASSEMBLER, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.ASSEMBLER).onRecipeBuild((recipeBuilder, provider) -> {
            if (recipeBuilder.input.getOrDefault(FluidRecipeCapability.CAP, Collections.emptyList()).isEmpty() && recipeBuilder.tickInput.getOrDefault(FluidRecipeCapability.CAP, Collections.emptyList()).isEmpty()) {
                recipeBuilder.copy(new ResourceLocation(recipeBuilder.id.toString() + "_soldering_alloy")).inputFluids(GTMaterials.SolderingAlloy.getFluid(Math.max(1, 72 * recipeBuilder.getSolderMultiplier()))).save((Consumer<FinishedRecipe>)provider);
                recipeBuilder.inputFluids(GTMaterials.Tin.getFluid(Math.max(1, 144 * recipeBuilder.getSolderMultiplier())));
            }
        });
        GAS_COLLECTOR_RECIPES = GTRecipeTypes.register("gas_collector", ELECTRIC, new RecipeType[0]).setMaxIOSize(1, 0, 0, 1).setEUIO(IO.IN).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.INT_CIRCUIT_OVERLAY).setSlotOverlay(true, true, (IGuiTexture)GuiTextures.CENTRIFUGE_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_GAS_COLLECTOR, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setOffsetVoltageText(true).setSound(GTSoundEntries.COOLING);
        AIR_SCRUBBER_RECIPES = GTRecipeTypes.register("air_scrubber", ELECTRIC, new RecipeType[0]).setMaxIOSize(1, 3, 1, 3).setEUIO(IO.IN).setProgressBar(GuiTextures.PROGRESS_BAR_GAS_COLLECTOR, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.COOLING);
        RESEARCH_STATION_RECIPES = GTRecipeTypes.register("research_station", ELECTRIC, new RecipeType[0]).setMaxIOSize(2, 1, 0, 0).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.SCANNER_OVERLAY).setSlotOverlay(true, false, (IGuiTexture)GuiTextures.RESEARCH_STATION_OVERLAY).setScanner(true).setMaxTooltips(4).setSound(GTValues.FOOLS.getAsBoolean() ? GTSoundEntries.SCIENCE : GTSoundEntries.COMPUTATION);
        ROCK_BREAKER_RECIPES = GTRecipeTypes.register("rock_breaker", ELECTRIC, new RecipeType[0]).setMaxIOSize(1, 4, 0, 0).setEUIO(IO.IN).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.DUST_OVERLAY).setSlotOverlay(true, false, (IGuiTexture)GuiTextures.CRUSHED_ORE_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_MACERATE, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setIconSupplier(() -> GTMachines.ROCK_CRUSHER[1].asStack()).setSteamProgressBar(GuiTextures.PROGRESS_BAR_MACERATE_STEAM, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setUiBuilder((recipe, widgetGroup) -> {
            ArrayList<HolderSet<Fluid>> fluids = new ArrayList<HolderSet<Fluid>>();
            for (RecipeCondition condition : recipe.conditions) {
                if (!(condition instanceof AdjacentFluidCondition)) continue;
                AdjacentFluidCondition adjacentFluid = (AdjacentFluidCondition)condition;
                fluids.addAll(adjacentFluid.getOrInitFluids((GTRecipe)recipe));
            }
            if (fluids.isEmpty()) {
                return;
            }
            int xOffset = 35;
            int yOffset = 0;
            int i = 0;
            for (HolderSet holderSet : fluids) {
                if (holderSet.size() == 0) continue;
                List<FluidEntryList> slots = Collections.singletonList(FluidHolderSetList.of((HolderSet<Fluid>)holderSet, 1000, null));
                TankWidget tank = new TankWidget(new CycleFluidEntryHandler(slots), widgetGroup.getSize().width - 30 - xOffset, widgetGroup.getSize().height - 30 + yOffset, false, false).setBackground((IGuiTexture)GuiTextures.FLUID_SLOT).setShowAmount(false);
                widgetGroup.addWidget((Widget)tank);
                xOffset = 20 * (2 - ++i % 3) - 5;
                yOffset = 20 * (i / 3);
            }
        }).setSound(GTSoundEntries.FIRE);
        SCANNER_RECIPES = GTRecipeTypes.register("scanner", ELECTRIC, new RecipeType[0]).setMaxIOSize(2, 1, 1, 0).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.DATA_ORB_OVERLAY).setSlotOverlay(false, false, true, (IGuiTexture)GuiTextures.SCANNER_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressTexture.FillDirection.LEFT_TO_RIGHT).addCustomRecipeLogic(new ResearchManager.DataStickCopyScannerLogic()).setScanner(true).setSound(GTSoundEntries.ELECTROLYZER);
        COMBUSTION_GENERATOR_FUELS = GTRecipeTypes.register("combustion_generator", GENERATOR, new RecipeType[0]).setMaxIOSize(0, 0, 1, 0).setEUIO(IO.OUT).setSlotOverlay(false, true, true, (IGuiTexture)GuiTextures.FURNACE_OVERLAY_2).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW_MULTIPLE, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.COMBUSTION);
        GAS_TURBINE_FUELS = GTRecipeTypes.register("gas_turbine", GENERATOR, new RecipeType[0]).setMaxIOSize(0, 0, 1, 0).setEUIO(IO.OUT).setSlotOverlay(false, true, true, (IGuiTexture)GuiTextures.DARK_CANISTER_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_GAS_COLLECTOR, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.TURBINE);
        STEAM_TURBINE_FUELS = GTRecipeTypes.register("steam_turbine", GENERATOR, new RecipeType[0]).setMaxIOSize(0, 0, 1, 1).setEUIO(IO.OUT).setSlotOverlay(false, true, true, (IGuiTexture)GuiTextures.CENTRIFUGE_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_GAS_COLLECTOR, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.TURBINE);
        PLASMA_GENERATOR_FUELS = GTRecipeTypes.register("plasma_generator", GENERATOR, new RecipeType[0]).setMaxIOSize(0, 0, 1, 1).setEUIO(IO.OUT).setSlotOverlay(false, true, true, (IGuiTexture)GuiTextures.CENTRIFUGE_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_GAS_COLLECTOR, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.TURBINE);
        LARGE_BOILER_RECIPES = GTRecipeTypes.register("large_boiler", MULTIBLOCK, new RecipeType[0]).setMaxIOSize(1, 0, 1, 1).setProgressBar(GuiTextures.PROGRESS_BAR_BOILER_FUEL.get(true), ProgressTexture.FillDirection.DOWN_TO_UP).setMaxTooltips(1).setSound(GTSoundEntries.FURNACE);
        COKE_OVEN_RECIPES = GTRecipeTypes.register("coke_oven", MULTIBLOCK, new RecipeType[0]).setMaxIOSize(1, 1, 0, 1).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setMaxTooltips(1).setSound(GTSoundEntries.FIRE);
        PRIMITIVE_BLAST_FURNACE_RECIPES = GTRecipeTypes.register("primitive_blast_furnace", MULTIBLOCK, new RecipeType[0]).setMaxIOSize(3, 3, 0, 0).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setMaxTooltips(1).setSound(GTSoundEntries.FIRE);
        BLAST_RECIPES = GTRecipeTypes.register("electric_blast_furnace", MULTIBLOCK, new RecipeType[0]).setMaxIOSize(3, 3, 1, 1).setEUIO(IO.IN).addDataInfo(data -> {
            int temp = data.getInt("ebf_temp");
            return LocalizationUtils.format((String)"gtceu.recipe.temperature", (Object[])new Object[]{temp});
        }).addDataInfo(data -> {
            int temp = data.getInt("ebf_temp");
            ICoilType requiredCoil = ICoilType.getMinRequiredType(temp);
            if (requiredCoil != null && !requiredCoil.getMaterial().isNull()) {
                return LocalizationUtils.format((String)"gtceu.recipe.coil.tier", (Object[])new Object[]{I18n.get((String)requiredCoil.getMaterial().getUnlocalizedName(), (Object[])new Object[0])});
            }
            return "";
        }).setUiBuilder((recipe, widgetGroup) -> {
            int temp = recipe.data.getInt("ebf_temp");
            ArrayList<List<ItemStack>> items = new ArrayList<List<ItemStack>>();
            items.add(GTCEuAPI.HEATING_COILS.entrySet().stream().filter(coil -> ((ICoilType)coil.getKey()).getCoilTemperature() >= temp).map(coil -> new ItemStack((ItemLike)((Supplier)coil.getValue()).get())).toList());
            widgetGroup.addWidget((Widget)new SlotWidget(new CycleItemStackHandler(items), 0, widgetGroup.getSize().width - 25, widgetGroup.getSize().height - 32, false, false));
        }).setSound(GTSoundEntries.FURNACE);
        DISTILLATION_RECIPES = GTRecipeTypes.register("distillation_tower", MULTIBLOCK, new RecipeType[0]).setMaxIOSize(0, 1, 1, 12).setEUIO(IO.IN).setSound(GTSoundEntries.CHEMICAL).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW_MULTIPLE, ProgressTexture.FillDirection.LEFT_TO_RIGHT).onRecipeBuild((recipeBuilder, provider) -> {
            if (recipeBuilder.data.getBoolean("disable_distillery")) {
                return;
            }
            if (recipeBuilder.output.containsKey(FluidRecipeCapability.CAP)) {
                ItemStack outputItem;
                Content inputContent = recipeBuilder.input.get(FluidRecipeCapability.CAP).get(0);
                FluidIngredient input = (FluidIngredient)FluidRecipeCapability.CAP.of(inputContent.getContent());
                ItemStack[] outputs = recipeBuilder.output.containsKey(ItemRecipeCapability.CAP) ? ((Ingredient)ItemRecipeCapability.CAP.of(recipeBuilder.output.get(ItemRecipeCapability.CAP).get(0).getContent())).getItems() : null;
                Object object = outputItem = outputs == null || outputs.length == 0 ? ItemStack.EMPTY : outputs[0];
                if (input.isEmpty()) {
                    return;
                }
                List<Content> contents = recipeBuilder.output.get(FluidRecipeCapability.CAP);
                for (int i = 0; i < contents.size(); ++i) {
                    Content outputContent = contents.get(i);
                    FluidIngredient output = (FluidIngredient)FluidRecipeCapability.CAP.of(outputContent.getContent());
                    if (output.isEmpty()) continue;
                    GTRecipeBuilder builder = DISTILLERY_RECIPES.recipeBuilder(recipeBuilder.id.getPath() + "_to_" + BuiltInRegistries.FLUID.getKey((Object)output.getStacks()[0].getFluid()).getPath()).EUt(Math.max(1L, recipeBuilder.EUt().voltage() / 4L), recipeBuilder.EUt().amperage()).circuitMeta(i + 1);
                    int ratio = RecipeHelper.getRatioForDistillery(input, output, outputItem);
                    int recipeDuration = (int)((double)recipeBuilder.duration * 2.0);
                    boolean shouldDivide = ratio != 1;
                    boolean fluidsDivisible = RecipeHelper.isFluidStackDivisibleForDistillery(input, ratio) && RecipeHelper.isFluidStackDivisibleForDistillery(output, ratio);
                    FluidIngredient dividedInputFluid = input.copy();
                    dividedInputFluid.setAmount(Math.max(1, dividedInputFluid.getAmount() / ratio));
                    FluidIngredient dividedOutputFluid = output.copy();
                    dividedOutputFluid.setAmount(Math.max(1, dividedOutputFluid.getAmount() / ratio));
                    if (shouldDivide && fluidsDivisible) {
                        builder.chance(inputContent.chance).tierChanceBoost(inputContent.tierChanceBoost).inputFluids(dividedInputFluid).chance(outputContent.chance).tierChanceBoost(outputContent.tierChanceBoost).outputFluids(dividedOutputFluid).duration(Math.max(1, recipeDuration / ratio));
                    } else if (!shouldDivide) {
                        if (!outputItem.isEmpty()) {
                            builder.outputItems(outputItem);
                        }
                        builder.conditions.addAll(recipeBuilder.conditions);
                        builder.chance(inputContent.chance).tierChanceBoost(inputContent.tierChanceBoost).inputFluids(input).chance(outputContent.chance).tierChanceBoost(outputContent.tierChanceBoost).outputFluids(output).duration(recipeDuration).save((Consumer<FinishedRecipe>)provider);
                        continue;
                    }
                    if (!outputItem.isEmpty()) {
                        boolean itemsDivisible;
                        boolean bl = itemsDivisible = outputItem.getCount() % ratio == 0 && fluidsDivisible;
                        if (fluidsDivisible && itemsDivisible) {
                            ItemStack stack = outputItem.copy();
                            stack.setCount(stack.getCount() / ratio);
                            builder.outputItems(stack);
                        }
                    }
                    builder.save((Consumer<FinishedRecipe>)provider);
                }
            }
        });
        PYROLYSE_RECIPES = GTRecipeTypes.register("pyrolyse_oven", MULTIBLOCK, new RecipeType[0]).setMaxIOSize(2, 1, 1, 1).setEUIO(IO.IN).setSound(GTSoundEntries.FIRE);
        CRACKING_RECIPES = GTRecipeTypes.register("cracker", MULTIBLOCK, new RecipeType[0]).setMaxIOSize(1, 0, 2, 2).setEUIO(IO.IN).setSlotOverlay(false, true, (IGuiTexture)GuiTextures.CRACKING_OVERLAY_1).setSlotOverlay(true, true, (IGuiTexture)GuiTextures.CRACKING_OVERLAY_2).setSlotOverlay(false, false, (IGuiTexture)GuiTextures.CIRCUIT_OVERLAY).setProgressBar(GuiTextures.PROGRESS_BAR_CRACKING, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.FIRE);
        IMPLOSION_RECIPES = GTRecipeTypes.register("implosion_compressor", MULTIBLOCK, new RecipeType[0]).setMaxIOSize(3, 2, 0, 0).setEUIO(IO.IN).prepareBuilder(recipeBuilder -> recipeBuilder.duration(20).EUt(GTValues.VA[1])).setSlotOverlay(false, false, true, (IGuiTexture)GuiTextures.IMPLOSION_OVERLAY_1).setSlotOverlay(false, false, false, (IGuiTexture)GuiTextures.IMPLOSION_OVERLAY_2).setSlotOverlay(true, false, true, (IGuiTexture)GuiTextures.DUST_OVERLAY).setSound(new ExistingSoundEntry(SoundEvents.GENERIC_EXPLODE, SoundSource.BLOCKS));
        VACUUM_RECIPES = GTRecipeTypes.register("vacuum_freezer", MULTIBLOCK, new RecipeType[0]).setMaxIOSize(1, 1, 2, 1).setEUIO(IO.IN).prepareBuilder(recipeBuilder -> recipeBuilder.EUt(GTValues.VA[2])).setSound(GTSoundEntries.COOLING);
        ASSEMBLY_LINE_RECIPES = GTRecipeTypes.register("assembly_line", MULTIBLOCK, new RecipeType[0]).setMaxIOSize(16, 1, 4, 0).setEUIO(IO.IN).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.ASSEMBLER).setHasResearchSlot(true).onRecipeBuild(ResearchManager::createDefaultResearchRecipe);
        LARGE_CHEMICAL_RECIPES = GTRecipeTypes.register("large_chemical_reactor", MULTIBLOCK, new RecipeType[0]).setMaxIOSize(3, 3, 5, 4).setEUIO(IO.IN).prepareBuilder(recipeBuilder -> recipeBuilder.EUt(GTValues.VA[1])).setSlotOverlay(false, false, false, (IGuiTexture)GuiTextures.MOLECULAR_OVERLAY_1).setSlotOverlay(false, false, true, (IGuiTexture)GuiTextures.MOLECULAR_OVERLAY_2).setSlotOverlay(false, true, false, (IGuiTexture)GuiTextures.MOLECULAR_OVERLAY_3).setSlotOverlay(false, true, true, (IGuiTexture)GuiTextures.MOLECULAR_OVERLAY_4).setSlotOverlay(true, false, (IGuiTexture)GuiTextures.VIAL_OVERLAY_1).setSlotOverlay(true, true, (IGuiTexture)GuiTextures.VIAL_OVERLAY_2).setSound(GTValues.FOOLS.getAsBoolean() ? GTSoundEntries.SCIENCE : GTSoundEntries.CHEMICAL).setProgressBar(GuiTextures.PROGRESS_BAR_ARROW_MULTIPLE, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSmallRecipeMap(CHEMICAL_RECIPES);
        FUSION_RECIPES = GTRecipeTypes.register("fusion_reactor", MULTIBLOCK, new RecipeType[0]).setMaxIOSize(0, 0, 2, 1).setEUIO(IO.IN).setProgressBar(GuiTextures.PROGRESS_BAR_FUSION, ProgressTexture.FillDirection.LEFT_TO_RIGHT).setSound(GTSoundEntries.ARC).setOffsetVoltageText(true).setMaxTooltips(4).setUiBuilder(FusionReactorMachine::addEUToStartLabel);
        DUMMY_RECIPES = GTRecipeTypes.register(DUMMY, DUMMY, new RecipeType[0]).setXEIVisible(false);
    }
}

