/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item;

import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.common.entity.DynamiteEntity;
import net.minecraft.Util;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;

public class DynamiteBehaviour
implements IInteractionItem {
    @Override
    public void onAttached(Item item) {
        DispenserBlock.registerBehavior((ItemLike)item, (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            protected Projectile getProjectile(Level level, Position position, ItemStack stack) {
                return (Projectile)Util.make((Object)((Object)new DynamiteEntity(position.x(), position.y(), position.z(), level)), entity -> entity.setItem(stack));
            }
        });
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Item item, Level level, Player player, InteractionHand usedHand) {
        ItemStack itemstack = player.getItemInHand(usedHand);
        if (!player.isCreative()) {
            itemstack.shrink(1);
        }
        if (level.isClientSide) {
            return InteractionResultHolder.success((Object)itemstack);
        }
        DynamiteEntity entity = new DynamiteEntity((LivingEntity)player, level);
        entity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 0.7f, 1.0f);
        level.addFreshEntity((Entity)entity);
        return InteractionResultHolder.success((Object)itemstack);
    }
}

