/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item;

import com.gregtechceu.gtceu.common.entity.GTBoat;
import com.gregtechceu.gtceu.common.entity.GTChestBoat;
import com.gregtechceu.gtceu.common.item.GTBoatItemDispenseBehaviour;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class GTBoatItem
extends Item {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.NO_SPECTATORS.and(Entity::isPickable);
    private final GTBoat.BoatType type;
    private final boolean hasChest;

    public GTBoatItem(boolean hasChest, GTBoat.BoatType type, Item.Properties properties) {
        super(properties);
        this.hasChest = hasChest;
        this.type = type;
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)new GTBoatItemDispenseBehaviour(type, hasChest));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        BlockHitResult hitresult = GTBoatItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitresult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        Vec3 vec3 = player.getViewVector(1.0f);
        double d0 = 5.0;
        List list = level.getEntities((Entity)player, player.getBoundingBox().expandTowards(vec3.scale(5.0)).inflate(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            Vec3 vec31 = player.getEyePosition();
            for (Entity e : list) {
                AABB aabb = e.getBoundingBox().inflate((double)e.getPickRadius());
                if (!aabb.contains(vec31)) continue;
                return InteractionResultHolder.pass((Object)itemstack);
            }
        }
        if (hitresult.getType() == HitResult.Type.BLOCK) {
            Object boat;
            if (this.hasChest) {
                boat = new GTChestBoat(level, hitresult.getLocation().x, hitresult.getLocation().y, hitresult.getLocation().z);
                ((GTChestBoat)((Object)boat)).setBoatType(this.type);
            } else {
                boat = new GTBoat(level, hitresult.getLocation().x, hitresult.getLocation().y, hitresult.getLocation().z);
                ((GTBoat)((Object)boat)).setBoatType(this.type);
            }
            boat.setYRot(player.getYRot());
            if (!level.noCollision((Entity)boat, boat.getBoundingBox())) {
                return InteractionResultHolder.fail((Object)itemstack);
            }
            if (!level.isClientSide) {
                level.addFreshEntity((Entity)boat);
                level.gameEvent((Entity)player, GameEvent.ENTITY_PLACE, hitresult.getLocation());
                if (!player.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }
}

