/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.armor;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.item.armor.ArmorLogicSuite;
import com.gregtechceu.gtceu.api.item.armor.ArmorUtils;
import com.gregtechceu.gtceu.common.item.armor.IJetpack;
import com.gregtechceu.gtceu.utils.input.KeyBind;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Jetpack
extends ArmorLogicSuite
implements IJetpack {
    @OnlyIn(value=Dist.CLIENT)
    protected ArmorUtils.ModularHUD HUD;

    public Jetpack(int energyPerUse, long capacity, int tier) {
        super(energyPerUse, capacity, tier, ArmorItem.Type.CHESTPLATE);
        if (GTCEu.isClientSide() && this.shouldDrawHUD()) {
            this.HUD = new ArmorUtils.ModularHUD();
        }
    }

    @Override
    public void onArmorTick(Level world, Player player, @NotNull ItemStack item) {
        IElectricItem cont = GTCapabilityHelper.getElectricItem(item);
        if (cont == null) {
            return;
        }
        CompoundTag data = item.getOrCreateTag();
        if (!data.contains("enabled")) {
            data.putBoolean("enabled", true);
            data.putBoolean("hover", false);
            data.putByte("toggleTimer", (byte)0);
        }
        boolean jetpackEnabled = data.getBoolean("enabled");
        boolean hoverMode = data.getBoolean("hover");
        int toggleTimer = data.getByte("toggleTimer");
        String messageKey = null;
        if (toggleTimer == 0) {
            if (KeyBind.JETPACK_ENABLE.isKeyDown(player)) {
                jetpackEnabled = !jetpackEnabled;
                messageKey = "metaarmor.jetpack.flight." + (jetpackEnabled ? "enable" : "disable");
                data.putBoolean("enabled", jetpackEnabled);
            } else if (KeyBind.ARMOR_HOVER.isKeyDown(player)) {
                hoverMode = !hoverMode;
                messageKey = "metaarmor.jetpack.hover." + (hoverMode ? "enable" : "disable");
                data.putBoolean("hover", hoverMode);
            }
            if (messageKey != null) {
                toggleTimer = 5;
                if (!world.isClientSide) {
                    player.displayClientMessage((Component)Component.translatable((String)messageKey), true);
                }
            }
        }
        if (toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
        }
        data.putByte("toggleTimer", (byte)toggleTimer);
        this.performFlying(player, jetpackEnabled, hoverMode, item);
    }

    @Override
    public boolean canUseEnergy(@NotNull ItemStack stack, int amount) {
        IElectricItem container = Jetpack.getIElectricItem(stack);
        if (container == null) {
            return false;
        }
        return container.canUse(amount);
    }

    @Override
    public void drainEnergy(@NotNull ItemStack stack, int amount) {
        IElectricItem container = Jetpack.getIElectricItem(stack);
        if (container == null) {
            return;
        }
        container.discharge(amount, this.tier, true, false, false);
    }

    @Override
    public boolean hasEnergy(@NotNull ItemStack stack) {
        IElectricItem container = Jetpack.getIElectricItem(stack);
        if (container == null) {
            return false;
        }
        return container.getCharge() > 0L;
    }

    @Nullable
    private static IElectricItem getIElectricItem(@NotNull ItemStack stack) {
        return GTCapabilityHelper.getElectricItem(stack);
    }

    @Override
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return GTCEu.id("textures/armor/jetpack.png");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawHUD(ItemStack item, GuiGraphics guiGraphics) {
        Jetpack.addCapacityHUD(item, this.HUD);
        CompoundTag data = item.getTag();
        if (data != null) {
            MutableComponent result;
            MutableComponent status;
            if (data.contains("enabled")) {
                status = data.getBoolean("enabled") ? Component.translatable((String)"metaarmor.hud.status.enabled") : Component.translatable((String)"metaarmor.hud.status.disabled");
                result = Component.translatable((String)"metaarmor.hud.engine_enabled", (Object[])new Object[]{status});
                this.HUD.newString((Component)result);
            }
            if (data.contains("hover")) {
                status = data.getBoolean("hover") ? Component.translatable((String)"metaarmor.hud.status.enabled") : Component.translatable((String)"metaarmor.hud.status.disabled");
                result = Component.translatable((String)"metaarmor.hud.hover_mode", (Object[])new Object[]{status});
                this.HUD.newString((Component)result);
            }
        }
        this.HUD.draw(guiGraphics);
        this.HUD.reset();
    }

    @Override
    public void addInfo(ItemStack itemStack, List<Component> lines) {
        super.addInfo(itemStack, lines);
        CompoundTag data = itemStack.getOrCreateTag();
        boolean enabled = !data.contains("enabled") || data.getBoolean("enabled");
        MutableComponent state = enabled ? Component.translatable((String)"metaarmor.hud.status.enabled") : Component.translatable((String)"metaarmor.hud.status.disabled");
        lines.add((Component)Component.translatable((String)"metaarmor.hud.engine_enabled", (Object[])new Object[]{state}));
        boolean hover = data.contains("hover") && data.getBoolean("hover");
        state = hover ? Component.translatable((String)"metaarmor.hud.status.enabled") : Component.translatable((String)"metaarmor.hud.status.disabled");
        lines.add((Component)Component.translatable((String)"metaarmor.hud.hover_mode", (Object[])new Object[]{state}));
    }

    @Override
    public double getVerticalHoverSlowSpeed() {
        return 0.1;
    }

    @Override
    public double getVerticalAcceleration() {
        return 0.12;
    }

    @Override
    public double getVerticalSpeed() {
        return 0.3;
    }

    @Override
    public double getSidewaysSpeed() {
        return 0.08;
    }

    @Override
    public ParticleOptions getParticle() {
        return ParticleTypes.SMOKE;
    }
}

