/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.modules;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.IMonitorModuleItem;
import com.gregtechceu.gtceu.api.placeholder.MultiLineComponent;
import com.gregtechceu.gtceu.api.placeholder.PlaceholderContext;
import com.gregtechceu.gtceu.api.placeholder.PlaceholderHandler;
import com.gregtechceu.gtceu.client.renderer.monitor.IMonitorRenderer;
import com.gregtechceu.gtceu.client.renderer.monitor.MonitorTextRenderer;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.CentralMonitorMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.monitor.MonitorGroup;
import com.gregtechceu.gtceu.common.network.GTNetwork;
import com.gregtechceu.gtceu.common.network.packets.SCPacketMonitorGroupNBTChange;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.codeeditor.CodeEditorWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class TextModuleBehaviour
implements IMonitorModuleItem,
IAddInformation {
    private void updateText(ItemStack stack, CentralMonitorMachine machine, MonitorGroup group) {
        if (!stack.getOrCreateTag().contains("placeholderUUID")) {
            stack.getOrCreateTag().putUUID("placeholderUUID", UUID.randomUUID());
        }
        MultiLineComponent text = PlaceholderHandler.processPlaceholders(this.getPlaceholderText(stack), new PlaceholderContext(group.getTargetLevel(machine.getLevel()), group.getTarget(machine.getLevel()), group.getTargetCoverSide(), group.getPlaceholderSlotsHandler(), group.getTargetCover(machine.getLevel()), null, stack.getOrCreateTag().getUUID("placeholderUUID")));
        stack.getOrCreateTag().put("text", text.toTag());
    }

    @Override
    public void tick(ItemStack stack, CentralMonitorMachine machine, MonitorGroup group) {
        this.updateText(stack, machine, group);
    }

    @Override
    public IMonitorRenderer getRenderer(ItemStack stack, CentralMonitorMachine machine, MonitorGroup group) {
        return new MonitorTextRenderer(this.getText(stack).toImmutable(), Math.max(this.getScale(stack), 1.0E-4));
    }

    @Override
    public Widget createUIWidget(ItemStack stack, CentralMonitorMachine machine, MonitorGroup group) {
        WidgetGroup builder = new WidgetGroup();
        CodeEditorWidget editor = new CodeEditorWidget(0, 0, 120, 80);
        TextFieldWidget scaleInput = new TextFieldWidget(-50, 47, 40, 10, null, null);
        ButtonWidget saveButton = new ButtonWidget(-40, 22, 20, 20, click -> {
            if (!click.isRemote) {
                return;
            }
            ListTag listTag = new ListTag();
            editor.getLines().forEach(line -> listTag.add((Object)StringTag.valueOf((String)line)));
            CompoundTag tag2 = stack.getOrCreateTag();
            tag2.put("formatStringLines", (Tag)listTag);
            try {
                tag2.putDouble("scale", Double.parseDouble(scaleInput.getCurrentString()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            stack.setTag(tag2);
            GTNetwork.sendToServer(new SCPacketMonitorGroupNBTChange(stack, group, machine));
        });
        saveButton.setButtonTexture(new IGuiTexture[]{GuiTextures.BUTTON_CHECK});
        ArrayList tmp = new ArrayList();
        Supplier<String> scaleInputSupplier = () -> {
            if (tmp.isEmpty()) {
                tmp.add(true);
            } else {
                scaleInput.setTextSupplier(null);
            }
            if (!stack.getOrCreateTag().contains("scale")) {
                stack.getOrCreateTag().putDouble("scale", 1.0);
                GTNetwork.sendToServer(new SCPacketMonitorGroupNBTChange(stack, group, machine));
                return "1";
            }
            return String.valueOf(Mth.clamp((double)stack.getOrCreateTag().getDouble("scale"), (double)1.0E-4, (double)1000.0));
        };
        scaleInput.setTextSupplier(scaleInputSupplier);
        scaleInput.setHoverTooltips(new Component[]{Component.translatable((String)"gtceu.gui.central_monitor.text_scale")});
        ListTag tag = stack.getOrCreateTag().getList("formatStringLines", 8);
        ArrayList<String> formatStringLines = new ArrayList<String>();
        for (Tag line : tag) {
            formatStringLines.add(line.getAsString());
        }
        editor.setLines(formatStringLines);
        builder.addWidget((Widget)editor);
        builder.addWidget((Widget)saveButton);
        Widget placeholderReference = PlaceholderHandler.getPlaceholderHandlerUI("");
        builder.addWidget((Widget)scaleInput);
        placeholderReference.setSelfPosition(-100, -50);
        builder.addWidget(placeholderReference);
        return builder;
    }

    @Override
    public String getType() {
        return "text";
    }

    public MultiLineComponent getText(ItemStack stack) {
        return MultiLineComponent.fromTag(stack.getOrCreateTag().getList("text", 8));
    }

    public double getScale(ItemStack stack) {
        return Math.max(stack.getOrCreateTag().getDouble("scale"), 1.0E-4);
    }

    public void setScale(ItemStack stack, double scale) {
        stack.getOrCreateTag().putDouble("scale", scale);
    }

    public void setPlaceholderText(ItemStack stack, String text) {
        ListTag listTag = new ListTag();
        for (String line : text.split("\n")) {
            listTag.add((Object)StringTag.valueOf((String)line));
        }
        stack.getOrCreateTag().put("formatStringLines", (Tag)listTag);
    }

    public String getPlaceholderText(ItemStack stack) {
        StringBuilder formatStringLines = new StringBuilder();
        ListTag tag = stack.getOrCreateTag().getList("formatStringLines", 8);
        for (Tag value : tag) {
            formatStringLines.append(value.getAsString()).append('\n');
        }
        return formatStringLines.toString();
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        if (isAdvanced.isAdvanced()) {
            tooltipComponents.add((Component)Component.literal((String)"Placeholder text:").withStyle(ChatFormatting.GOLD));
            tooltipComponents.addAll(MultiLineComponent.literal(this.getPlaceholderText(stack)));
            tooltipComponents.add((Component)Component.literal((String)"Processed text:").withStyle(ChatFormatting.GOLD));
            tooltipComponents.addAll(this.getText(stack));
        }
    }
}

