/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.tool.behavior;

import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.item.tool.aoe.AoESymmetrical;
import com.gregtechceu.gtceu.api.item.tool.behavior.IToolBehavior;
import com.gregtechceu.gtceu.common.data.item.GTToolActions;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ToolAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HarvestCropsBehavior
implements IToolBehavior {
    public static final HarvestCropsBehavior INSTANCE = new HarvestCropsBehavior();

    protected HarvestCropsBehavior() {
    }

    @Override
    public boolean canPerformAction(ItemStack stack, ToolAction action) {
        return action == GTToolActions.HOE_HARVEST;
    }

    @Override
    @NotNull
    public InteractionResult onItemUse(UseOnContext context) {
        List<BlockPos> blocks;
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        ItemStack stack = context.getItemInHand();
        AoESymmetrical aoeDefinition = ToolHelper.getAoEDefinition(stack);
        if (aoeDefinition.isZero()) {
            blocks = List.of(pos);
        } else {
            blocks = ToolHelper.iterateAoE(aoeDefinition, HarvestCropsBehavior::isBlockCrops, context);
            if (HarvestCropsBehavior.isBlockCrops(context)) {
                blocks.add(0, context.getClickedPos());
            }
        }
        boolean harvested = false;
        for (BlockPos blockPos : blocks) {
            harvested |= HarvestCropsBehavior.harvestBlockRoutine(blockPos, context);
            if (!stack.isEmpty()) continue;
            break;
        }
        if (harvested) {
            BlockState state = level.getBlockState(pos);
            level.levelEvent(2001, pos, Block.getId((BlockState)state));
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    private static boolean isBlockCrops(UseOnContext context) {
        BlockPos pos;
        Level level = context.getLevel();
        if (level.getBlockState((pos = context.getClickedPos()).above()).isAir()) {
            Block block = level.getBlockState(pos).getBlock();
            return block instanceof CropBlock;
        }
        return false;
    }

    private static boolean harvestBlockRoutine(BlockPos pos, UseOnContext context) {
        Level level = context.getLevel();
        ItemStack stack = context.getItemInHand();
        Player player = context.getPlayer();
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        if (!(block instanceof CropBlock)) {
            return false;
        }
        CropBlock cropBlock = (CropBlock)block;
        ItemStack seed = blockState.getCloneItemStack((HitResult)context.getHitResult().withPosition(pos), (BlockGetter)level, pos, player);
        if (cropBlock.isMaxAge(blockState)) {
            if (!level.isClientSide) {
                List drops = Block.getDrops((BlockState)blockState, (ServerLevel)((ServerLevel)level), (BlockPos)pos, null);
                boolean removedSeed = false;
                for (ItemStack drop : drops) {
                    if (!removedSeed && GTUtil.isSameItemSameTags(drop, seed)) {
                        drop.shrink(1);
                        removedSeed = true;
                        if (drop.isEmpty()) continue;
                    }
                    Block.popResource((Level)level, (BlockPos)pos, (ItemStack)drop);
                }
            }
            level.setBlock(pos, cropBlock.getStateForAge(0), 11);
            ToolHelper.damageItem(stack, (LivingEntity)player);
            return true;
        }
        return false;
    }

    @Override
    public void addInformation(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"item.gtceu.tool.behavior.crop_harvesting"));
    }
}

