/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.electric;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.UITemplate;
import com.gregtechceu.gtceu.api.gui.widget.TankWidget;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TieredEnergyMachine;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputFluid;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.feature.IUIMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.DropSaved;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.BucketPickupHandlerWrapper;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PumpMachine
extends TieredEnergyMachine
implements IAutoOutputFluid,
IUIMachine,
IMachineLife {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(PumpMachine.class, TieredEnergyMachine.MANAGED_FIELD_HOLDER);
    public static final int BASE_PUMP_RADIUS = 16;
    public static final int EXTRA_PUMP_RADIUS = 4;
    public static final int PUMP_SPEED_BASE = 80;
    private final Set<BlockPos> forbiddenBlocks = new ObjectOpenHashSet();
    private PumpQueue pumpQueue = null;
    @Persisted
    private int pumpHeadY;
    @Persisted
    @DescSynced
    @RequireRerender
    protected boolean autoOutputFluids;
    @Persisted
    @DropSaved
    protected final NotifiableFluidTank cache;

    public PumpMachine(IMachineBlockEntity holder, int tier, Object ... args) {
        super(holder, tier, new Object[0]);
        this.cache = this.createCacheFluidHandler(args);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    protected NotifiableFluidTank createCacheFluidHandler(Object ... args) {
        return new NotifiableFluidTank(this, 1, 16000 * Math.max(1, this.getTier()), IO.NONE, IO.OUT);
    }

    @Override
    public boolean isAllowInputFromOutputSideFluids() {
        return false;
    }

    @Override
    public void setAllowInputFromOutputSideFluids(boolean allow) {
    }

    @Override
    public Direction getOutputFacingFluids() {
        return this.getFrontFacing();
    }

    @Override
    public void setOutputFacingFluids(Direction outputFacing) {
        this.setFrontFacing(outputFacing);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.subscribeServerTick(this::update);
    }

    @Override
    public boolean shouldWeatherOrTerrainExplosion() {
        return false;
    }

    public static int getMaxPumpRadius(int tier) {
        return 16 + 4 * tier;
    }

    private List<Direction> biasedInVecDirections(RandomSource randomSource, Vec3i vec, boolean goUp) {
        int xValue;
        ArrayList<Direction> searchList = new ArrayList<Direction>();
        if (goUp) {
            searchList.add(Direction.UP);
        }
        ObjectArrayList axes = new ObjectArrayList();
        int zValue = Math.abs(vec.getZ());
        if (zValue > (xValue = Math.abs(vec.getX()))) {
            axes.add((Object)Direction.Axis.Z);
            axes.add((Object)Direction.Axis.X);
        } else if (zValue < xValue) {
            axes.add((Object)Direction.Axis.X);
            axes.add((Object)Direction.Axis.Z);
        } else {
            axes.add((Object)Direction.Axis.Z);
            axes.add((Object)Direction.Axis.X);
            Util.shuffle((ObjectArrayList)axes, (RandomSource)randomSource);
        }
        Direction lastDirection = null;
        for (int i = 0; i < 2; ++i) {
            Direction.Axis axis = (Direction.Axis)axes.get(i);
            int value = axis.equals((Object)Direction.Axis.Z) ? vec.getZ() : vec.getX();
            Direction direction = value < 0 ? Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE) : (value > 0 ? Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE) : Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)((Direction.AxisDirection)Util.getRandom((Object[])Direction.AxisDirection.values(), (RandomSource)randomSource))));
            searchList.add(direction);
            if (i == 0) {
                lastDirection = direction.getOpposite();
                continue;
            }
            searchList.add(direction.getOpposite());
        }
        searchList.add(lastDirection);
        return searchList;
    }

    @Nullable
    private SearchResult searchNext(Level level, BlockPos headPosBelow, BlockPos searchHead, FluidType fluidType, int maxPumpRange, boolean goUp, Set<BlockPos> checked) {
        BlockPos subVec = searchHead.subtract((Vec3i)headPosBelow);
        List<Direction> searchList = this.biasedInVecDirections(level.getRandom(), (Vec3i)subVec, goUp);
        for (Direction direction : searchList) {
            BucketPickupHandlerWrapper fluidHandler;
            FluidStack drainStack;
            Block block;
            BlockPos pumpY;
            BlockPos check = searchHead.relative(direction);
            if (check.distSqr((Vec3i)(pumpY = headPosBelow.atY(check.getY()))) > (double)(maxPumpRange * maxPumpRange) || checked.contains(check) || !level.isLoaded(check) || this.forbiddenBlocks.contains(check)) continue;
            checked.add(check);
            BlockState state = level.getBlockState(check);
            FluidState fluidState = state.getFluidState();
            if (fluidState.getFluidType() != fluidType || !((block = state.getBlock()) instanceof LiquidBlock)) continue;
            LiquidBlock liquidBlock = (LiquidBlock)block;
            boolean isSource = fluidState.isSource();
            if (isSource && !(drainStack = (fluidHandler = new BucketPickupHandlerWrapper((BucketPickup)liquidBlock, level, check)).drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE)).isEmpty()) {
                return new SearchResult(check, true);
            }
            return new SearchResult(check, false);
        }
        return null;
    }

    private void updatePumpQueue(@Nullable FluidType fluidType) {
        if (this.getLevel() == null) {
            return;
        }
        if (this.pumpQueue != null && !this.pumpQueue.queue().isEmpty()) {
            return;
        }
        BlockPos headPos = this.getPos().below(this.pumpHeadY);
        BlockPos downPos = headPos.below(1);
        BlockState downBlock = this.getLevel().getBlockState(downPos);
        if (!(downBlock.getBlock() instanceof LiquidBlock)) {
            this.pumpQueue = null;
            return;
        }
        if (fluidType != null && downBlock.getFluidState().getFluidType() != fluidType) {
            this.pumpQueue = null;
            return;
        }
        this.pumpQueue = this.buildPumpQueue(this.getLevel(), headPos, downBlock.getFluidState().getFluidType(), this.queueSize(), true);
    }

    private PumpQueue buildPumpQueue(Level level, BlockPos headPos, FluidType fluidType, int queueSourceAmount, boolean upSources) {
        ObjectOpenHashSet checked = new ObjectOpenHashSet();
        BlockPos headPosBelow = headPos.below();
        checked.add(headPos);
        checked.add(headPosBelow);
        int maxPumpRange = PumpMachine.getMaxPumpRadius(this.getTier());
        ArrayList<BlockPos> pathStack = new ArrayList<BlockPos>();
        ArrayDeque<BlockPos> nonSources = new ArrayDeque<BlockPos>();
        ArrayDeque<BlockPos> pathToLastSource = new ArrayDeque<BlockPos>();
        ArrayDeque sourceStack = new ArrayDeque();
        pathStack.add(headPosBelow);
        nonSources.add(headPosBelow);
        int iterations = 0;
        int previousSources = 0;
        ArrayDeque<Deque<BlockPos>> paths = new ArrayDeque<Deque<BlockPos>>();
        ArrayList<BlockPos> sources = new ArrayList<BlockPos>();
        while (!pathStack.isEmpty() && iterations < 1000) {
            BlockPos searchHead = (BlockPos)pathStack.get(pathStack.size() - 1);
            SearchResult next = this.searchNext(level, headPosBelow, searchHead, fluidType, maxPumpRange, upSources, (Set<BlockPos>)checked);
            ++iterations;
            if (next == null) {
                BlockPos lastSource;
                boolean continueSearch = sources.size() < queueSourceAmount;
                int addedSources = sources.size() - previousSources;
                previousSources = sources.size();
                if (addedSources > 0) {
                    ArrayDeque toAdd = new ArrayDeque(pathToLastSource);
                    toAdd.removeFirst();
                    paths.add(toAdd);
                }
                if (!continueSearch) {
                    return new PumpQueue(paths, fluidType);
                }
                BlockPos last = (BlockPos)pathStack.remove(pathStack.size() - 1);
                if (last.equals((Object)(lastSource = (BlockPos)sourceStack.peekLast()))) {
                    BlockPos p;
                    BlockPos prevSource = (BlockPos)sourceStack.removeLast();
                    for (int i = pathStack.size() - 1; i >= 0 && !(p = (BlockPos)pathStack.get(i)).equals((Object)prevSource); --i) {
                        nonSources.addFirst(p);
                    }
                    continue;
                }
                if (nonSources.isEmpty()) continue;
                nonSources.removeLast();
                continue;
            }
            pathStack.add(next.pos());
            if (next.isSource() && (!upSources || next.pos().getY() > headPosBelow.getY())) {
                sources.add(next.pos());
                pathToLastSource.addAll(nonSources);
                pathToLastSource.add(next.pos());
                nonSources.clear();
                sources.add(next.pos());
                continue;
            }
            nonSources.add(next.pos());
        }
        if (upSources) {
            if (paths.isEmpty()) {
                return this.buildPumpQueue(level, headPos, fluidType, queueSourceAmount, false);
            }
            return new PumpQueue(paths, fluidType);
        }
        if (paths.isEmpty() && level.getBlockState(headPosBelow).getFluidState().isSource()) {
            return new PumpQueue(new ArrayDeque<Deque<BlockPos>>(List.of(new ArrayDeque<BlockPos>(List.of(headPosBelow)))), fluidType);
        }
        return new PumpQueue(paths, fluidType);
    }

    private boolean canAdvancePumpHead() {
        BlockPos downPos;
        BlockState downBlock;
        Level level;
        BlockPos headPos = this.getPos().below(this.pumpHeadY);
        if ((this.pumpQueue == null || this.pumpQueue.queue.isEmpty()) && (level = this.getLevel()) != null && (downBlock = level.getBlockState(downPos = headPos.below(1))).isAir()) {
            ++this.pumpHeadY;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.setBlockAndUpdate(downPos, GTBlocks.MINER_PIPE.getDefaultState());
            }
            return true;
        }
        return false;
    }

    @Override
    public void onMachineRemoved() {
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = this.getPos().relative(Direction.DOWN);
            while (serverLevel.getBlockState(pos).is((Block)GTBlocks.MINER_PIPE.get())) {
                serverLevel.removeBlock(pos, false);
                pos = pos.relative(Direction.DOWN);
            }
        }
    }

    private void pumpCycle() {
        Level level = this.getLevel();
        if (level == null) {
            return;
        }
        this.updatePumpQueue(null);
        int pumps = this.pumpsPerCycle();
        boolean pumped = false;
        int iterations = 0;
        while (pumps > 0 && this.pumpQueue != null && !this.pumpQueue.queue().isEmpty() && iterations < 10) {
            LiquidBlock liquidBlock;
            Block block;
            ++iterations;
            Deque<BlockPos> pumpPath = this.pumpQueue.queue().peek();
            ArrayDeque<SourceState> states = new ArrayDeque<SourceState>();
            for (BlockPos pos : pumpPath) {
                BlockState state;
                if (!level.isLoaded(pos) || !((block = (state = level.getBlockState(pos)).getBlock()) instanceof LiquidBlock) || (liquidBlock = (LiquidBlock)block).getFluidState(state).getFluidType() != this.pumpQueue.fluidType()) break;
                states.add(new SourceState(state, pos));
            }
            while (pumps > 0 && !pumpPath.isEmpty()) {
                BlockPos pos = pumpPath.removeLast();
                SourceState sourceState = (SourceState)states.peekLast();
                if (sourceState == null || !pos.equals((Object)sourceState.pos())) continue;
                states.removeLast();
                FluidState fluidState = sourceState.state().getFluidState();
                block = sourceState.state().getBlock();
                if (!(block instanceof LiquidBlock)) continue;
                liquidBlock = (LiquidBlock)block;
                if (!fluidState.isSource()) continue;
                BucketPickupHandlerWrapper fluidHandler = new BucketPickupHandlerWrapper((BucketPickup)liquidBlock, this.getLevel(), pos);
                FluidStack drainStack = fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
                if (!drainStack.isEmpty() && this.cache.fillInternal(drainStack, IFluidHandler.FluidAction.SIMULATE) == drainStack.getAmount()) {
                    this.cache.fillInternal(drainStack, IFluidHandler.FluidAction.EXECUTE);
                    fluidHandler.drain(drainStack, IFluidHandler.FluidAction.EXECUTE);
                    this.getLevel().setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                    pumped = true;
                    --pumps;
                    continue;
                }
                if (!drainStack.isEmpty()) {
                    pumpPath.add(pos);
                    return;
                }
                this.forbiddenBlocks.add(pos);
                return;
            }
            if (pumpPath.isEmpty()) {
                this.pumpQueue.queue().remove();
            }
            if (pumps <= 0 || !this.pumpQueue.queue().isEmpty()) continue;
            this.updatePumpQueue(this.pumpQueue.fluidType());
        }
        if (pumped) {
            this.energyContainer.changeEnergy(-GTValues.V[this.getTier()] * 2L);
        }
    }

    public void update() {
        if (this.getOutputFacingFluids() != null) {
            this.cache.exportToNearby(this.getOutputFacingFluids());
        }
        if (this.energyContainer.getEnergyStored() < GTValues.V[this.getTier()] * 2L) {
            return;
        }
        boolean advanced = false;
        if (this.getOffsetTimer() % ((long)this.getPumpingCycleLength() * 2L) == 0L) {
            advanced = this.canAdvancePumpHead();
        }
        if (!advanced && this.getOffsetTimer() % (long)this.getPumpingCycleLength() == 0L) {
            this.pumpCycle();
        }
        if (this.getOffsetTimer() % 1200L == 0L) {
            this.forbiddenBlocks.clear();
        }
    }

    private int queueSize() {
        return 5 * this.pumpsPerCycle();
    }

    private float ticksPerPump() {
        float tierMultiplier = 1 << this.getTier() - 1;
        return 80.0f / tierMultiplier;
    }

    private int pumpsPerCycle() {
        return (int)((float)this.getPumpingCycleLength() / this.ticksPerPump());
    }

    private int getPumpingCycleLength() {
        return Math.max(20, (int)this.ticksPerPump());
    }

    public ModularUI createUI(Player entityPlayer) {
        return new ModularUI(176, 166, (IUIHolder)this, entityPlayer).background(new IGuiTexture[]{GuiTextures.BACKGROUND}).widget((Widget)new ImageWidget(7, 16, 81, 55, (IGuiTexture)GuiTextures.DISPLAY)).widget((Widget)new LabelWidget(11, 20, "gtceu.gui.fluid_amount")).widget((Widget)new LabelWidget(11, 30, () -> "" + this.cache.getFluidInTank(0).getAmount()).setTextColor(-1).setDropShadow(true)).widget((Widget)new LabelWidget(6, 6, this.getBlockState().getBlock().getDescriptionId())).widget((Widget)new TankWidget(this.cache.getStorages()[0], 90, 35, true, true).setBackground((IGuiTexture)GuiTextures.FLUID_SLOT)).widget((Widget)new ToggleButtonWidget(7, 53, 18, 18, (IGuiTexture)GuiTextures.BUTTON_FLUID_OUTPUT, this::isAutoOutputFluids, this::setAutoOutputFluids).setShouldUseBaseBackground().setTooltipText("gtceu.gui.fluid_auto_output.tooltip")).widget((Widget)UITemplate.bindPlayerInventory(entityPlayer.getInventory(), (IGuiTexture)GuiTextures.SLOT, 7, 84, true));
    }

    @Override
    @Nullable
    public ResourceTexture sideTips(Player player, BlockPos pos, BlockState state, Set<GTToolType> toolTypes, Direction side) {
        if (toolTypes.contains(GTToolType.WRENCH) && player.isShiftKeyDown() && this.hasFrontFacing() && side != this.getFrontFacing() && this.isFacingValid(side)) {
            return GuiTextures.TOOL_IO_FACING_ROTATION;
        }
        return super.sideTips(player, pos, state, toolTypes, side);
    }

    @Generated
    public int getPumpHeadY() {
        return this.pumpHeadY;
    }

    @Override
    @Generated
    public boolean isAutoOutputFluids() {
        return this.autoOutputFluids;
    }

    @Override
    @Generated
    public void setAutoOutputFluids(boolean autoOutputFluids) {
        this.autoOutputFluids = autoOutputFluids;
    }

    protected record PumpQueue(Queue<Deque<BlockPos>> queue, FluidType fluidType) {
    }

    protected record SearchResult(BlockPos pos, boolean isSource) {
    }

    protected record SourceState(BlockState state, BlockPos pos) {
    }
}

