/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.electric.monitor;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.capability.IMonitorComponent;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class MonitorGroup {
    private final Set<BlockPos> monitorPositions = new HashSet<BlockPos>();
    private final String name;
    private final CustomItemStackHandler itemStackHandler;
    private final CustomItemStackHandler placeholderSlotsHandler;
    @Nullable
    private BlockPos target;
    @Nullable
    private Direction targetCoverSide;
    private int dataSlot = 0;

    public MonitorGroup(String name) {
        this(name, new CustomItemStackHandler(1), new CustomItemStackHandler(8));
    }

    public MonitorGroup(String name, CustomItemStackHandler handler, CustomItemStackHandler placeholderSlotsHandler) {
        this.name = name;
        this.itemStackHandler = handler;
        this.placeholderSlotsHandler = placeholderSlotsHandler;
    }

    public void add(BlockPos pos) {
        this.monitorPositions.add(pos);
    }

    public void remove(BlockPos pos) {
        this.monitorPositions.remove(pos);
    }

    public List<BlockPos> getRow(int row, UnaryOperator<BlockPos> toRelative) throws IndexOutOfBoundsException {
        IntOpenHashSet yLevelsSet = new IntOpenHashSet();
        for (BlockPos pos : this.monitorPositions) {
            yLevelsSet.add(((BlockPos)toRelative.apply(pos)).getY());
        }
        if (row < 0) {
            row += yLevelsSet.size();
        }
        int y = yLevelsSet.intStream().sorted().toArray()[row];
        ArrayList<BlockPos> rowPositions = new ArrayList<BlockPos>();
        for (BlockPos pos : this.monitorPositions) {
            if (((BlockPos)toRelative.apply(pos)).getY() != y) continue;
            rowPositions.add((BlockPos)toRelative.apply(pos));
        }
        rowPositions.sort(Comparator.comparingInt(Vec3i::getX));
        return rowPositions;
    }

    public boolean contains(BlockPos pos) {
        return this.monitorPositions.contains(pos);
    }

    public boolean isEmpty() {
        return this.monitorPositions.isEmpty();
    }

    public Set<BlockPos> getRelativePositions() {
        return this.monitorPositions;
    }

    @Nullable
    public CoverBehavior getTargetCover(Level level) {
        ICoverable coverable;
        if (this.getTarget(level) != null && this.targetCoverSide != null && (coverable = GTCapabilityHelper.getCoverable(level, this.getTarget(level), this.targetCoverSide)) != null) {
            return coverable.getCoverAtSide(this.targetCoverSide);
        }
        return null;
    }

    @Nullable
    public BlockPos getTargetRaw() {
        return this.target;
    }

    @Nullable
    public BlockPos getTarget(Level level) {
        if (this.target == null) {
            return null;
        }
        IMonitorComponent component = GTCapabilityHelper.getMonitorComponent(level, this.target, null);
        if (component != null && component.getDataItems() != null) {
            ItemStack stack = component.getDataItems().getStackInSlot(this.dataSlot);
            CompoundTag tag = stack.getTag();
            if (tag == null) {
                return null;
            }
            int x = tag.getInt("targetX");
            int y = tag.getInt("targetY");
            int z = tag.getInt("targetZ");
            Direction face = Direction.byName((String)tag.getString("face"));
            if (face == null) {
                return null;
            }
            this.setTargetCoverSide(face);
            return new BlockPos(x, y, z);
        }
        return this.target;
    }

    public Level getTargetLevel(Level level) {
        if (this.target == null) {
            return level;
        }
        IMonitorComponent component = GTCapabilityHelper.getMonitorComponent(level, this.target, null);
        if (component != null && component.getDataItems() != null) {
            ItemStack stack = component.getDataItems().getStackInSlot(this.dataSlot);
            CompoundTag tag = stack.getTag();
            if (tag == null || !tag.contains("dim")) {
                return level;
            }
            if (level.getServer() == null) {
                return level;
            }
            return level.getServer().getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)new ResourceLocation(tag.getString("dim"))));
        }
        return level;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public CustomItemStackHandler getItemStackHandler() {
        return this.itemStackHandler;
    }

    @Generated
    public CustomItemStackHandler getPlaceholderSlotsHandler() {
        return this.placeholderSlotsHandler;
    }

    @Generated
    public void setTarget(@Nullable BlockPos target) {
        this.target = target;
    }

    @Generated
    public void setTargetCoverSide(@Nullable Direction targetCoverSide) {
        this.targetCoverSide = targetCoverSide;
    }

    @Nullable
    @Generated
    public Direction getTargetCoverSide() {
        return this.targetCoverSide;
    }

    @Generated
    public void setDataSlot(int dataSlot) {
        this.dataSlot = dataSlot;
    }

    @Generated
    public int getDataSlot() {
        return this.dataSlot;
    }
}

