/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.electric.research;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.IHPCAComponentHatch;
import com.gregtechceu.gtceu.api.capability.IHPCAComputationProvider;
import com.gregtechceu.gtceu.api.capability.IHPCACoolantProvider;
import com.gregtechceu.gtceu.api.capability.IOpticalComputationProvider;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.util.TimedProgressSupplier;
import com.gregtechceu.gtceu.api.gui.widget.ExtendedProgressWidget;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMaintenanceMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockDisplayText;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.misc.EnergyContainerList;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.api.transfer.fluid.FluidHandlerList;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.IManaged;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.FieldManagedStorage;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class HPCAMachine
extends WorkableElectricMultiblockMachine
implements IOpticalComputationProvider,
IControllable {
    private static final double IDLE_TEMPERATURE = 200.0;
    private static final double DAMAGE_TEMPERATURE = 1000.0;
    private IMaintenanceMachine maintenance;
    private IEnergyContainer energyContainer = new EnergyContainerList(new ArrayList());
    private IFluidHandler coolantHandler;
    @Persisted
    @DescSynced
    private final HPCAGridHandler hpcaHandler;
    private boolean hasNotEnoughEnergy;
    @Persisted
    private double temperature = 200.0;
    private final TimedProgressSupplier progressSupplier = new TimedProgressSupplier(200, 47, false);
    @Nullable
    protected TickableSubscription tickSubs;

    public HPCAMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, args);
        this.hpcaHandler = new HPCAGridHandler(this);
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        ArrayList energyContainers = new ArrayList();
        ArrayList<IFluidHandler> coolantContainers = new ArrayList<IFluidHandler>();
        ArrayList<IHPCAComponentHatch> componentHatches = new ArrayList<IHPCAComponentHatch>();
        Long2ObjectMap ioMap = this.getMultiblockState().getMatchContext().getOrCreate("ioMap", Long2ObjectMaps::emptyMap);
        for (IMultiPart part : this.getParts()) {
            IO io = (IO)ioMap.getOrDefault(part.self().getPos().asLong(), (Object)IO.BOTH);
            if (part instanceof IHPCAComponentHatch) {
                IHPCAComponentHatch componentHatch = (IHPCAComponentHatch)((Object)part);
                componentHatches.add(componentHatch);
            }
            if (part instanceof IMaintenanceMachine) {
                IMaintenanceMachine maintenanceMachine;
                this.maintenance = maintenanceMachine = (IMaintenanceMachine)part;
            }
            if (io == IO.NONE || io == IO.OUT) continue;
            List<RecipeHandlerList> handlerLists = part.getRecipeHandlers();
            for (RecipeHandlerList handlerList : handlerLists) {
                if (!handlerList.isValid(io)) continue;
                handlerList.getCapability(EURecipeCapability.CAP).stream().filter(IEnergyContainer.class::isInstance).map(IEnergyContainer.class::cast).forEach(energyContainers::add);
                handlerList.getCapability(FluidRecipeCapability.CAP).stream().filter(IFluidHandler.class::isInstance).map(IFluidHandler.class::cast).forEach(coolantContainers::add);
            }
        }
        this.energyContainer = new EnergyContainerList(energyContainers);
        this.coolantHandler = new FluidHandlerList(coolantContainers);
        this.hpcaHandler.onStructureForm(componentHatches);
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getServer().tell((Runnable)new TickTask(0, this::updateTickSubscription));
        }
    }

    @Override
    public void onLoad() {
        super.onLoad();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getServer().tell((Runnable)new TickTask(0, this::updateTickSubscription));
        }
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.tickSubs != null) {
            this.tickSubs.unsubscribe();
            this.tickSubs = null;
        }
    }

    protected void updateTickSubscription() {
        if (this.isFormed) {
            this.tickSubs = this.subscribeServerTick(this.tickSubs, this::tick);
        } else if (this.tickSubs != null) {
            this.tickSubs.unsubscribe();
            this.tickSubs = null;
        }
    }

    @Override
    public void onStructureInvalid() {
        this.updateActive(false);
        super.onStructureInvalid();
        this.energyContainer = new EnergyContainerList(new ArrayList());
        this.hpcaHandler.onStructureInvalidate();
    }

    @Override
    public int requestCWUt(int cwut, boolean simulate, @NotNull Collection<IOpticalComputationProvider> seen) {
        seen.add(this);
        return this.isActive() && this.isWorkingEnabled() && !this.hasNotEnoughEnergy ? this.hpcaHandler.allocateCWUt(cwut, simulate) : 0;
    }

    @Override
    public int getMaxCWUt(@NotNull Collection<IOpticalComputationProvider> seen) {
        seen.add(this);
        return this.isActive() && this.isWorkingEnabled() ? this.hpcaHandler.getMaxCWUt() : 0;
    }

    @Override
    public boolean canBridge(@NotNull Collection<IOpticalComputationProvider> seen) {
        seen.add(this);
        return !this.isFormed() || this.hpcaHandler.hasHPCABridge();
    }

    public void tick() {
        if (this.isWorkingEnabled()) {
            this.consumeEnergy();
        }
        if (this.isActive()) {
            double midpoint = 400.0;
            double temperatureChange = this.hpcaHandler.calculateTemperatureChange(this.coolantHandler, this.temperature >= midpoint) / 2.0;
            this.temperature = this.temperature + temperatureChange <= 200.0 ? 200.0 : (this.temperature += temperatureChange);
            if (this.temperature >= 1000.0) {
                this.hpcaHandler.attemptDamageHPCA();
            }
            this.hpcaHandler.tick();
        } else {
            this.hpcaHandler.clearComputationCache();
            this.temperature = Math.max(200.0, this.temperature - 0.25);
        }
        this.updateActive(this.getEnergyContainer().getEnergyStored() > 0L);
    }

    private void updateActive(boolean active) {
        for (IMultiPart part : this.getParts()) {
            if (!(part instanceof IHPCAComponentHatch)) continue;
            IHPCAComponentHatch hpcaPart = (IHPCAComponentHatch)((Object)part);
            hpcaPart.setActive(active);
        }
    }

    private void consumeEnergy() {
        boolean hasMaintenance;
        long energyToConsume = this.hpcaHandler.getCurrentEUt();
        boolean bl = hasMaintenance = ConfigHolder.INSTANCE.machines.enableMaintenance && this.maintenance != null;
        if (hasMaintenance) {
            energyToConsume += (long)this.maintenance.getNumMaintenanceProblems() * energyToConsume / 10L;
        }
        if (this.hasNotEnoughEnergy && this.energyContainer.getInputPerSec() > 19L * energyToConsume) {
            this.hasNotEnoughEnergy = false;
        }
        if (this.energyContainer.getEnergyStored() >= energyToConsume) {
            if (!this.hasNotEnoughEnergy) {
                long consumed = this.energyContainer.removeEnergy(energyToConsume);
                if (consumed == energyToConsume) {
                    this.getRecipeLogic().setStatus(RecipeLogic.Status.WORKING);
                } else {
                    this.hasNotEnoughEnergy = true;
                    this.getRecipeLogic().setStatus(RecipeLogic.Status.WAITING);
                }
            }
        } else {
            this.hasNotEnoughEnergy = true;
            this.getRecipeLogic().setStatus(RecipeLogic.Status.WAITING);
        }
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup builder = (WidgetGroup)super.createUIWidget();
        builder.addWidget((Widget)new ExtendedProgressWidget(() -> this.hpcaHandler.getAllocatedCWUt() > 0 ? this.progressSupplier.getAsDouble() : 0.0, 74, 57, 47, 47, GuiTextures.HPCA_COMPONENT_OUTLINE).setServerTooltipSupplier(this.hpcaHandler::addInfo).setFillDirection(ProgressTexture.FillDirection.LEFT_TO_RIGHT));
        int startX = 76;
        int startY = 59;
        if (this.getLevel().isClientSide) {
            if (this.isFormed) {
                this.hpcaHandler.tryGatherClientComponents(this.getLevel(), this.getPos(), this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped);
            } else {
                this.hpcaHandler.clearClientComponents();
            }
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int index = i * 3 + j;
                Supplier<IGuiTexture> textureSupplier = () -> this.hpcaHandler.getComponentTexture(index);
                builder.addWidget((Widget)new ImageWidget(startX + 15 * j, startY + 15 * i, 13, 13, textureSupplier));
            }
        }
        return builder;
    }

    @Override
    public void addDisplayText(List<Component> textList) {
        MultiblockDisplayText.builder(textList, this.isFormed()).setWorkingStatus(true, this.hpcaHandler.getAllocatedCWUt() > 0).setWorkingStatusKeys("gtceu.multiblock.idling", "gtceu.multiblock.idling", "gtceu.multiblock.data_bank.providing").addCustom(tl -> {
            if (this.isFormed()) {
                tl.add(Component.translatable((String)"gtceu.multiblock.hpca.energy", (Object[])new Object[]{FormattingUtil.formatNumbers(this.hpcaHandler.cachedEUt), FormattingUtil.formatNumbers(this.hpcaHandler.getMaxEUt()), GTValues.VNF[GTUtil.getTierByVoltage(this.hpcaHandler.getMaxEUt())]}).withStyle(ChatFormatting.GRAY));
                MutableComponent cwutInfo = Component.literal((String)(this.hpcaHandler.cachedCWUt + " / " + this.hpcaHandler.getMaxCWUt() + " CWU/t")).withStyle(ChatFormatting.AQUA);
                tl.add(Component.translatable((String)"gtceu.multiblock.hpca.computation", (Object[])new Object[]{cwutInfo}).withStyle(ChatFormatting.GRAY));
            }
        }).addWorkingStatusLine();
    }

    private ChatFormatting getDisplayTemperatureColor() {
        if (this.temperature < 500.0) {
            return ChatFormatting.GREEN;
        }
        if (this.temperature < 750.0) {
            return ChatFormatting.YELLOW;
        }
        return ChatFormatting.RED;
    }

    public static class HPCAGridHandler
    implements IManaged {
        public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(HPCAGridHandler.class);
        private final FieldManagedStorage syncStorage = new FieldManagedStorage((IManaged)this);
        @Nullable
        private final HPCAMachine controller;
        private final List<IHPCAComponentHatch> components = new ObjectArrayList();
        private final Set<IHPCACoolantProvider> coolantProviders = new ObjectOpenHashSet();
        private final Set<IHPCAComputationProvider> computationProviders = new ObjectOpenHashSet();
        private int numBridges;
        private int allocatedCWUt;
        @DescSynced
        private long cachedEUt;
        @DescSynced
        private int cachedCWUt;

        public HPCAGridHandler(@Nullable HPCAMachine controller) {
            this.controller = controller;
        }

        public void onStructureForm(Collection<IHPCAComponentHatch> components) {
            this.reset();
            for (IHPCAComponentHatch component : components) {
                this.components.add(component);
                if (component instanceof IHPCACoolantProvider) {
                    IHPCACoolantProvider coolantProvider = (IHPCACoolantProvider)component;
                    this.coolantProviders.add(coolantProvider);
                }
                if (component instanceof IHPCAComputationProvider) {
                    IHPCAComputationProvider computationProvider = (IHPCAComputationProvider)component;
                    this.computationProviders.add(computationProvider);
                }
                if (!component.isBridge()) continue;
                ++this.numBridges;
            }
        }

        private void onStructureInvalidate() {
            this.reset();
        }

        private void reset() {
            this.clearComputationCache();
            this.components.clear();
            this.coolantProviders.clear();
            this.computationProviders.clear();
            this.numBridges = 0;
        }

        private void clearComputationCache() {
            this.allocatedCWUt = 0;
        }

        public void tick() {
            if (this.cachedCWUt != this.allocatedCWUt) {
                this.cachedCWUt = this.allocatedCWUt;
            }
            this.cachedEUt = this.getCurrentEUt();
            if (this.allocatedCWUt != 0) {
                this.allocatedCWUt = 0;
            }
        }

        public double calculateTemperatureChange(IFluidHandler coolantTank, boolean forceCoolWithActive) {
            int maxCWUt = Math.max(1, this.getMaxCWUt());
            int maxCoolingDemand = this.getMaxCoolingDemand();
            int temperatureIncrease = (int)Math.round(1.0 * (double)maxCoolingDemand * (double)this.allocatedCWUt / (double)maxCWUt);
            long maxPassiveCooling = 0L;
            long maxActiveCooling = 0L;
            int maxCoolantDrain = 0;
            for (IHPCACoolantProvider coolantProvider : this.coolantProviders) {
                if (coolantProvider.isActiveCooler()) {
                    maxActiveCooling += (long)coolantProvider.getCoolingAmount();
                    maxCoolantDrain += coolantProvider.getMaxCoolantPerTick();
                    continue;
                }
                maxPassiveCooling += (long)coolantProvider.getCoolingAmount();
            }
            double temperatureChange = (long)temperatureIncrease - maxPassiveCooling;
            if (maxActiveCooling == 0L && maxCoolantDrain == 0) {
                return temperatureChange;
            }
            if (forceCoolWithActive || (double)maxActiveCooling <= temperatureChange) {
                Holder fluid;
                FluidStack drained;
                int remainingCoolant = maxCoolantDrain;
                Iterator iterator = BuiltInRegistries.FLUID.getTagOrEmpty(CustomTags.HPCA_COOLANTS).iterator();
                while (iterator.hasNext() && (remainingCoolant -= (drained = GTTransferUtils.drainFluidAccountNotifiableList(coolantTank, new FluidStack((Fluid)(fluid = (Holder)iterator.next()).get(), remainingCoolant), IFluidHandler.FluidAction.EXECUTE)).getAmount()) > 0) {
                }
                if (remainingCoolant <= 0) {
                    temperatureChange -= (double)maxActiveCooling;
                } else {
                    int coolantDrained = maxCoolantDrain - remainingCoolant;
                    temperatureChange -= (double)maxActiveCooling * (1.0 * (double)coolantDrained / (double)maxCoolantDrain);
                }
            } else if (temperatureChange > 0.0) {
                Holder fluid;
                FluidStack drained;
                int coolantToDrain;
                double temperatureToDecrease = Math.min(temperatureChange, (double)maxActiveCooling);
                int remainingCoolant = coolantToDrain = Math.max(1, (int)((double)maxCoolantDrain * (temperatureToDecrease / (double)maxActiveCooling)));
                Iterator iterator = BuiltInRegistries.FLUID.getTagOrEmpty(CustomTags.HPCA_COOLANTS).iterator();
                while (iterator.hasNext() && (remainingCoolant -= (drained = GTTransferUtils.drainFluidAccountNotifiableList(coolantTank, new FluidStack((Fluid)(fluid = (Holder)iterator.next()).get(), remainingCoolant), IFluidHandler.FluidAction.EXECUTE)).getAmount()) > 0) {
                }
                if (remainingCoolant <= 0) {
                    return 0.0;
                }
                int coolantDrained = coolantToDrain - remainingCoolant;
                temperatureChange -= temperatureToDecrease * (1.0 * (double)coolantDrained / (double)coolantToDrain);
            }
            return temperatureChange;
        }

        public void attemptDamageHPCA() {
            if (GTValues.RNG.nextInt(200) == 0) {
                ArrayList<IHPCAComponentHatch> candidates = new ArrayList<IHPCAComponentHatch>();
                for (IHPCAComponentHatch component : this.components) {
                    if (!component.canBeDamaged()) continue;
                    candidates.add(component);
                }
                if (!candidates.isEmpty()) {
                    ((IHPCAComponentHatch)candidates.get(GTValues.RNG.nextInt(candidates.size()))).setDamaged(true);
                }
            }
        }

        public int allocateCWUt(int cwut, boolean simulate) {
            if (cwut == 0) {
                return 0;
            }
            int maxCWUt = this.getMaxCWUt();
            int availableCWUt = maxCWUt - this.allocatedCWUt;
            int toAllocate = Math.min(cwut, availableCWUt);
            if (!simulate) {
                this.allocatedCWUt += toAllocate;
            }
            return toAllocate;
        }

        public int getMaxCWUt() {
            int maxCWUt = 0;
            for (IHPCAComputationProvider computationProvider : this.computationProviders) {
                maxCWUt += computationProvider.getCWUPerTick();
            }
            return maxCWUt;
        }

        public long getCurrentEUt() {
            long upkeepEUt;
            long maximumCWUt = Math.max(1, this.getMaxCWUt());
            long maximumEUt = this.getMaxEUt();
            if (maximumEUt == (upkeepEUt = this.getUpkeepEUt())) {
                return maximumEUt;
            }
            return upkeepEUt + (maximumEUt - upkeepEUt) * (long)this.allocatedCWUt / maximumCWUt;
        }

        public long getUpkeepEUt() {
            long upkeepEUt = 0L;
            for (IHPCAComponentHatch component : this.components) {
                upkeepEUt += (long)component.getUpkeepEUt();
            }
            return upkeepEUt;
        }

        public long getMaxEUt() {
            long maximumEUt = 0L;
            for (IHPCAComponentHatch component : this.components) {
                maximumEUt += (long)component.getMaxEUt();
            }
            return maximumEUt;
        }

        public boolean hasHPCABridge() {
            return this.numBridges > 0;
        }

        public boolean hasActiveCoolers() {
            for (IHPCACoolantProvider coolantProvider : this.coolantProviders) {
                if (!coolantProvider.isActiveCooler()) continue;
                return true;
            }
            return false;
        }

        public int getMaxCoolingAmount() {
            int maxCooling = 0;
            for (IHPCACoolantProvider coolantProvider : this.coolantProviders) {
                maxCooling += coolantProvider.getCoolingAmount();
            }
            return maxCooling;
        }

        public int getMaxCoolingDemand() {
            int maxCooling = 0;
            for (IHPCAComputationProvider computationProvider : this.computationProviders) {
                maxCooling += computationProvider.getCoolingPerTick();
            }
            return maxCooling;
        }

        public int getMaxCoolantDemand() {
            int maxCoolant = 0;
            for (IHPCACoolantProvider coolantProvider : this.coolantProviders) {
                maxCoolant += coolantProvider.getMaxCoolantPerTick();
            }
            return maxCoolant;
        }

        public void addInfo(List<Component> textList) {
            MutableComponent data = Component.literal((String)Integer.toString(this.getMaxCWUt())).withStyle(ChatFormatting.AQUA);
            textList.add((Component)Component.translatable((String)"gtceu.multiblock.hpca.info_max_computation", (Object[])new Object[]{data}).withStyle(ChatFormatting.GRAY));
            ChatFormatting coolingColor = this.getMaxCoolingAmount() < this.getMaxCoolingDemand() ? ChatFormatting.RED : ChatFormatting.GREEN;
            data = Component.literal((String)Integer.toString(this.getMaxCoolingDemand())).withStyle(coolingColor);
            textList.add((Component)Component.translatable((String)"gtceu.multiblock.hpca.info_max_cooling_demand", (Object[])new Object[]{data}).withStyle(ChatFormatting.GRAY));
            data = Component.literal((String)Integer.toString(this.getMaxCoolingAmount())).withStyle(coolingColor);
            textList.add((Component)Component.translatable((String)"gtceu.multiblock.hpca.info_max_cooling_available", (Object[])new Object[]{data}).withStyle(ChatFormatting.GRAY));
            if (this.getMaxCoolantDemand() > 0) {
                data = Component.translatable((String)"gtceu.universal.liters", (Object[])new Object[]{this.getMaxCoolantDemand()}).withStyle(ChatFormatting.YELLOW).append(" ");
                MutableComponent coolantName = Component.translatable((String)"gtceu.multiblock.hpca.info_coolant_name").withStyle(ChatFormatting.YELLOW);
                data.append((Component)coolantName);
            } else {
                data = Component.literal((String)"0").withStyle(ChatFormatting.GREEN);
            }
            textList.add((Component)Component.translatable((String)"gtceu.multiblock.hpca.info_max_coolant_required", (Object[])new Object[]{data}).withStyle(ChatFormatting.GRAY));
            if (this.numBridges > 0) {
                textList.add((Component)Component.translatable((String)"gtceu.multiblock.hpca.info_bridging_enabled").withStyle(ChatFormatting.GREEN));
            } else {
                textList.add((Component)Component.translatable((String)"gtceu.multiblock.hpca.info_bridging_disabled").withStyle(ChatFormatting.RED));
            }
        }

        public void addWarnings(List<Component> textList) {
            ArrayList<MutableComponent> warnings = new ArrayList<MutableComponent>();
            if (this.numBridges > 1) {
                warnings.add(Component.translatable((String)"gtceu.multiblock.hpca.warning_multiple_bridges").withStyle(ChatFormatting.GRAY));
            }
            if (this.computationProviders.isEmpty()) {
                warnings.add(Component.translatable((String)"gtceu.multiblock.hpca.warning_no_computation").withStyle(ChatFormatting.GRAY));
            }
            if (this.getMaxCoolingDemand() > this.getMaxCoolingAmount()) {
                warnings.add(Component.translatable((String)"gtceu.multiblock.hpca.warning_low_cooling").withStyle(ChatFormatting.GRAY));
            }
            if (!warnings.isEmpty()) {
                textList.add((Component)Component.translatable((String)"gtceu.multiblock.hpca.warning_structure_header").withStyle(ChatFormatting.YELLOW));
                textList.addAll(warnings);
            }
        }

        public void addErrors(List<Component> textList) {
            if (this.components.stream().anyMatch(IHPCAComponentHatch::isDamaged)) {
                textList.add((Component)Component.translatable((String)"gtceu.multiblock.hpca.error_damaged").withStyle(ChatFormatting.RED));
            }
        }

        public ResourceTexture getComponentTexture(int index) {
            if (this.components.size() <= index) {
                return GuiTextures.BLANK_TRANSPARENT;
            }
            return this.components.get(index).getComponentIcon();
        }

        public void tryGatherClientComponents(Level world, BlockPos pos, Direction frontFacing, Direction upwardsFacing, boolean flip) {
            Direction relativeUp = RelativeDirection.UP.getRelative(frontFacing, upwardsFacing, flip);
            if (this.components.isEmpty()) {
                BlockPos testPos = pos.relative(frontFacing.getOpposite(), 3).relative(relativeUp, 3);
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        IMachineBlockEntity machineBE;
                        MetaMachine machine;
                        BlockPos tempPos = testPos.relative(frontFacing, j).relative(relativeUp.getOpposite(), i);
                        BlockEntity be = world.getBlockEntity(tempPos);
                        if (be instanceof IHPCAComponentHatch) {
                            IHPCAComponentHatch hatch = (IHPCAComponentHatch)be;
                            this.components.add(hatch);
                            continue;
                        }
                        if (!(be instanceof IMachineBlockEntity) || !((machine = (machineBE = (IMachineBlockEntity)be).getMetaMachine()) instanceof IHPCAComponentHatch)) continue;
                        IHPCAComponentHatch hatch = (IHPCAComponentHatch)((Object)machine);
                        this.components.add(hatch);
                    }
                }
            }
        }

        public void clearClientComponents() {
            this.components.clear();
        }

        public ManagedFieldHolder getFieldHolder() {
            return MANAGED_FIELD_HOLDER;
        }

        public void onChanged() {
            this.controller.onChanged();
        }

        @Generated
        public FieldManagedStorage getSyncStorage() {
            return this.syncStorage;
        }

        @Generated
        public int getAllocatedCWUt() {
            return this.allocatedCWUt;
        }
    }
}

