/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.electric.research;

import com.gregtechceu.gtceu.api.capability.IObjectHolder;
import com.gregtechceu.gtceu.api.capability.IOpticalComputationProvider;
import com.gregtechceu.gtceu.api.capability.IOpticalComputationReceiver;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import com.gregtechceu.gtceu.api.capability.recipe.CWURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IDisplayUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockDisplayText;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.ActionResult;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ResearchStationMachine
extends WorkableElectricMultiblockMachine
implements IOpticalComputationReceiver,
IDisplayUIMachine {
    private IOpticalComputationProvider computationProvider;
    private IObjectHolder objectHolder;

    public ResearchStationMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, args);
    }

    @Override
    protected RecipeLogic createRecipeLogic(Object ... args) {
        return new ResearchStationRecipeLogic(this);
    }

    @Override
    public ResearchStationRecipeLogic getRecipeLogic() {
        return (ResearchStationRecipeLogic)super.getRecipeLogic();
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        for (IMultiPart part : this.getParts()) {
            if (part instanceof IObjectHolder) {
                IObjectHolder iObjectHolder = (IObjectHolder)((Object)part);
                if (iObjectHolder.getFrontFacing() != this.getFrontFacing().getOpposite()) {
                    this.onStructureInvalid();
                    return;
                }
                this.objectHolder = iObjectHolder;
            }
            part.self().holder.self().getCapability(GTCapability.CAPABILITY_COMPUTATION_PROVIDER).ifPresent(provider -> {
                this.computationProvider = provider;
            });
        }
        if (this.computationProvider == null || this.objectHolder == null) {
            this.onStructureInvalid();
        }
    }

    @Override
    public boolean checkPattern() {
        boolean isFormed = super.checkPattern();
        if (isFormed && this.objectHolder != null && this.objectHolder.getFrontFacing() != this.getFrontFacing().getOpposite()) {
            this.onStructureInvalid();
        }
        return isFormed;
    }

    @Override
    public void onStructureInvalid() {
        this.computationProvider = null;
        for (IMultiPart part : this.getParts()) {
            IObjectHolder holder;
            if (!(part instanceof IObjectHolder) || (holder = (IObjectHolder)((Object)part)) != this.objectHolder) continue;
            this.objectHolder.setLocked(false);
        }
        this.objectHolder = null;
        super.onStructureInvalid();
    }

    @Override
    public boolean regressWhenWaiting() {
        return false;
    }

    @Override
    public void addDisplayText(List<Component> textList) {
        MultiblockDisplayText.builder(textList, this.isFormed()).setWorkingStatus(this.recipeLogic.isWorkingEnabled(), this.recipeLogic.isActive()).setWorkingStatusKeys("gtceu.multiblock.idling", "gtceu.multiblock.work_paused", "gtceu.multiblock.research_station.researching").addEnergyUsageLine(this.energyContainer).addEnergyTierLine(this.tier).addWorkingStatusLine().addProgressLineOnlyPercent(this.recipeLogic.getProgressPercent());
    }

    @Override
    @Generated
    public IOpticalComputationProvider getComputationProvider() {
        return this.computationProvider;
    }

    @Generated
    public IObjectHolder getObjectHolder() {
        return this.objectHolder;
    }

    public static class ResearchStationRecipeLogic
    extends RecipeLogic {
        public ResearchStationRecipeLogic(ResearchStationMachine metaTileEntity) {
            super(metaTileEntity);
        }

        @Override
        @NotNull
        public ResearchStationMachine getMachine() {
            return (ResearchStationMachine)super.getMachine();
        }

        @Override
        protected ActionResult matchRecipe(GTRecipe recipe) {
            ActionResult match = this.matchRecipeNoOutput(recipe);
            if (!match.isSuccess()) {
                return match;
            }
            return this.matchTickRecipeNoOutput(recipe);
        }

        @Override
        public boolean checkMatchedRecipeAvailable(GTRecipe match) {
            GTRecipe modified = this.machine.fullModifyRecipe(match);
            if (modified != null) {
                if (!modified.inputs.containsKey(CWURecipeCapability.CAP) && !modified.tickInputs.containsKey(CWURecipeCapability.CAP)) {
                    return true;
                }
                ActionResult recipeMatch = this.checkRecipe(modified);
                if (recipeMatch.isSuccess()) {
                    this.setupRecipe(modified);
                } else {
                    this.setWaiting(recipeMatch.reason());
                }
                if (this.lastRecipe != null && this.getStatus() == RecipeLogic.Status.WORKING) {
                    this.lastOriginRecipe = match;
                    this.lastFailedMatches = null;
                    return true;
                }
            }
            return false;
        }

        protected ActionResult matchRecipeNoOutput(GTRecipe recipe) {
            if (!this.machine.hasCapabilityProxies()) {
                return ActionResult.FAIL_NO_CAPABILITIES;
            }
            return RecipeHelper.handleRecipe(this.machine, recipe, IO.IN, recipe.inputs, Collections.emptyMap(), false, true);
        }

        protected ActionResult matchTickRecipeNoOutput(GTRecipe recipe) {
            if (recipe.hasTick()) {
                if (!this.machine.hasCapabilityProxies()) {
                    return ActionResult.FAIL_NO_CAPABILITIES;
                }
                return RecipeHelper.handleRecipe(this.machine, recipe, IO.IN, recipe.tickInputs, Collections.emptyMap(), false, true);
            }
            return ActionResult.SUCCESS;
        }

        @Override
        protected ActionResult handleRecipeIO(GTRecipe recipe, IO io) {
            if (io == IO.IN) {
                IObjectHolder holder = this.getMachine().getObjectHolder();
                holder.setLocked(true);
                return ActionResult.SUCCESS;
            }
            IObjectHolder holder = this.getMachine().getObjectHolder();
            if (this.lastRecipe == null) {
                holder.setLocked(false);
                return ActionResult.SUCCESS;
            }
            holder.setHeldItem(ItemStack.EMPTY);
            ItemStack outputItem = ItemStack.EMPTY;
            List<Content> contents = this.lastRecipe.getOutputContents(ItemRecipeCapability.CAP);
            if (!contents.isEmpty()) {
                outputItem = ((Ingredient)ItemRecipeCapability.CAP.of(contents.get((int)0).content)).getItems()[0];
            }
            if (!outputItem.isEmpty()) {
                holder.setDataItem(outputItem.copy());
            }
            holder.setLocked(false);
            return ActionResult.SUCCESS;
        }

        @Override
        protected ActionResult handleTickRecipeIO(GTRecipe recipe, IO io) {
            if (io != IO.OUT) {
                return super.handleTickRecipeIO(recipe, io);
            }
            return ActionResult.SUCCESS;
        }
    }
}

