/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.part;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.IDataAccessHatch;
import com.gregtechceu.gtceu.api.capability.IMonitorComponent;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.IDataInfoProvider;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.part.MultiblockPartMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.part.TieredPartMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.item.PortableScannerBehavior;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.research.DataBankMachine;
import com.gregtechceu.gtceu.common.recipe.condition.ResearchCondition;
import com.gregtechceu.gtceu.utils.ItemStackHashStrategy;
import com.gregtechceu.gtceu.utils.ResearchManager;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class DataAccessHatchMachine
extends TieredPartMachine
implements IMachineLife,
IDataAccessHatch,
IDataInfoProvider,
IMonitorComponent {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(DataAccessHatchMachine.class, MultiblockPartMachine.MANAGED_FIELD_HOLDER);
    private final Set<GTRecipe> recipes;
    private final boolean isCreative;
    @Persisted
    public final NotifiableItemStackHandler importItems;

    public DataAccessHatchMachine(IMachineBlockEntity holder, int tier, boolean isCreative) {
        super(holder, tier);
        this.isCreative = isCreative;
        this.recipes = isCreative ? Collections.emptySet() : new ObjectOpenHashSet();
        this.importItems = this.createImportItemHandler();
    }

    protected NotifiableItemStackHandler createImportItemHandler() {
        if (this.isCreative) {
            return new NotifiableItemStackHandler(this, 0, IO.BOTH);
        }
        return new NotifiableItemStackHandler(this, this.getInventorySize(), IO.BOTH){

            @Override
            public void onContentsChanged() {
                super.onContentsChanged();
                DataAccessHatchMachine.this.rebuildData(DataAccessHatchMachine.this.isFormed() && DataAccessHatchMachine.this.getControllers().first() instanceof DataBankMachine);
            }

            @Override
            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                boolean isDataBank;
                boolean bl = isDataBank = DataAccessHatchMachine.this.isFormed() && DataAccessHatchMachine.this.getControllers().first() instanceof DataBankMachine;
                if (ResearchManager.isStackDataItem(stack, isDataBank)) {
                    return super.insertItem(slot, stack, simulate);
                }
                return stack;
            }
        };
    }

    @Override
    public Widget createUIWidget() {
        int rowSize = (int)Math.sqrt(this.getInventorySize());
        int xOffset = 18 * rowSize / 2;
        WidgetGroup group = new WidgetGroup(0, 0, 18 * rowSize, 18 * rowSize);
        for (int y = 0; y < rowSize; ++y) {
            for (int x = 0; x < rowSize; ++x) {
                int index = y * rowSize + x;
                group.addWidget((Widget)new SlotWidget(this.importItems, index, rowSize * 9 + x * 18 - xOffset, y * 18, true, true).setBackgroundTexture((IGuiTexture)GuiTextures.SLOT));
            }
        }
        return group;
    }

    @Override
    public boolean shouldOpenUI(Player player, InteractionHand hand, BlockHitResult hit) {
        return !this.isCreative;
    }

    protected int getInventorySize() {
        return switch (this.getTier()) {
            case 6 -> 16;
            case 4 -> 9;
            case 3 -> 4;
            default -> 1;
        };
    }

    @Override
    public void onMachineRemoved() {
        this.clearInventory((IItemHandlerModifiable)this.importItems.storage);
    }

    private void rebuildData(boolean isDataBank) {
        if (this.isCreative || this.getLevel() == null || this.getLevel().isClientSide) {
            return;
        }
        this.recipes.clear();
        for (int i = 0; i < this.importItems.getSlots(); ++i) {
            Collection<GTRecipe> collection;
            ItemStack stack = this.importItems.getStackInSlot(i);
            ResearchManager.ResearchItem researchData = ResearchManager.readResearchId(stack);
            boolean isValid = ResearchManager.isStackDataItem(stack, isDataBank);
            if (researchData == null || !isValid || (collection = researchData.recipeType().getDataStickEntry(researchData.researchId())) == null) continue;
            this.recipes.addAll(collection);
        }
    }

    @Override
    public boolean isRecipeAvailable(@NotNull GTRecipe recipe, @NotNull Collection<IDataAccessHatch> seen) {
        seen.add(this);
        return recipe.conditions.stream().noneMatch(ResearchCondition.class::isInstance) || this.recipes.contains(recipe);
    }

    @Override
    @NotNull
    public List<Component> getDataInfo(PortableScannerBehavior.DisplayMode mode) {
        if (mode == PortableScannerBehavior.DisplayMode.SHOW_ALL || mode == PortableScannerBehavior.DisplayMode.SHOW_RECIPE_INFO) {
            if (this.recipes.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Component> list = new ArrayList<Component>();
            list.add((Component)Component.translatable((String)"behavior.data_item.title", (Object[])new Object[]{Component.translatable((String)GTRecipeTypes.ASSEMBLY_LINE_RECIPES.registryName.toLanguageKey())}));
            list.add((Component)Component.empty());
            ObjectOpenCustomHashSet itemsAdded = new ObjectOpenCustomHashSet((Hash.Strategy)ItemStackHashStrategy.comparingAll());
            for (GTRecipe recipe : this.recipes) {
                ItemStack stack = ((Ingredient)ItemRecipeCapability.CAP.of(recipe.getOutputContents(ItemRecipeCapability.CAP).get((int)0).content)).getItems()[0];
                if (itemsAdded.contains(stack)) continue;
                itemsAdded.add(stack);
                list.add((Component)Component.translatable((String)"behavior.data_item.data", (Object[])new Object[]{stack.getDisplayName()}));
            }
            return list;
        }
        return new ArrayList<Component>();
    }

    @Override
    public boolean canShared() {
        return this.isCreative;
    }

    @Override
    public void addedToController(IMultiController controller) {
        this.rebuildData(controller instanceof DataBankMachine);
        super.addedToController(controller);
    }

    @Override
    public GTRecipe modifyRecipe(GTRecipe recipe) {
        return IDataAccessHatch.super.modifyRecipe(recipe);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public IGuiTexture getComponentIcon() {
        return new ResourceTexture(GTCEu.id("textures/item/data_module.png")).getSubTexture(0.0f, 0.0f, 1.0f, 0.07692308f);
    }

    @Override
    public IItemHandler getDataItems() {
        return this.importItems.storage;
    }

    @Override
    @Generated
    public boolean isCreative() {
        return this.isCreative;
    }
}

