/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.primitive;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.IWorkable;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.pattern.BlockPattern;
import com.gregtechceu.gtceu.api.pattern.FactoryBlockPattern;
import com.gregtechceu.gtceu.api.pattern.Predicates;
import com.gregtechceu.gtceu.api.pattern.TraceabilityPredicate;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.item.tool.behavior.LighterBehavior;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import it.unimi.dsi.fastutil.longs.Long2BooleanMap;
import it.unimi.dsi.fastutil.longs.Long2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class CharcoalPileIgniterMachine
extends WorkableMultiblockMachine
implements IWorkable {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(CharcoalPileIgniterMachine.class, WorkableMultiblockMachine.MANAGED_FIELD_HOLDER);
    private static final int MIN_RADIUS = 1;
    private static final int MIN_DEPTH = 2;
    private final Collection<BlockPos> logPos = new ObjectOpenHashSet();
    @DescSynced
    private int lDist = 0;
    @DescSynced
    private int rDist = 0;
    @DescSynced
    private int bDist = 0;
    @DescSynced
    private int fDist = 0;
    @DescSynced
    private int hDist = 0;
    private boolean hasAir = false;

    public CharcoalPileIgniterMachine(IMachineBlockEntity holder) {
        super(holder, new Object[0]);
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        this.hasAir = false;
        if (this.getMultiblockState().getMatchContext().containsKey("logPos")) {
            Long2BooleanMap logPositions = (Long2BooleanMap)this.getMultiblockState().getMatchContext().get("logPos");
            for (Long2BooleanMap.Entry entry : logPositions.long2BooleanEntrySet()) {
                if (entry.getBooleanValue()) {
                    this.logPos.add(BlockPos.of((long)entry.getLongKey()));
                    continue;
                }
                this.hasAir = true;
            }
        }
        this.getRecipeLogic().setDuration(Math.max(1, (int)Math.sqrt(this.logPos.size() * 240000)));
    }

    @Override
    @NotNull
    protected CharcoalRecipeLogic createRecipeLogic(Object ... args) {
        return new CharcoalRecipeLogic(this);
    }

    @Override
    @NotNull
    public CharcoalRecipeLogic getRecipeLogic() {
        return (CharcoalRecipeLogic)super.getRecipeLogic();
    }

    @Override
    @NotNull
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public boolean isActive() {
        return this.recipeLogic.isWorking();
    }

    @Override
    public boolean isWorkingEnabled() {
        return true;
    }

    @Override
    public void setWorkingEnabled(boolean isWorkingAllowed) {
    }

    @Override
    public BlockPattern getPattern() {
        int j;
        int i;
        this.updateDimensions();
        if (this.lDist < 1) {
            this.lDist = 1;
        }
        if (this.rDist < 1) {
            this.rDist = 1;
        }
        if (this.fDist < 1) {
            this.fDist = 1;
        }
        if (this.bDist < 1) {
            this.bDist = 1;
        }
        if (this.hDist < 2) {
            this.hDist = 2;
        }
        if (this.getFrontFacing().getAxis() == Direction.Axis.X) {
            int tmp = this.lDist;
            this.lDist = this.rDist;
            this.rDist = tmp;
        }
        StringBuilder[] floorLayer = new StringBuilder[this.fDist + this.bDist + 1];
        ArrayList<StringBuilder[]> wallLayers = new ArrayList<StringBuilder[]>();
        StringBuilder[] ceilingLayer = new StringBuilder[this.fDist + this.bDist + 1];
        for (i = 0; i < floorLayer.length; ++i) {
            floorLayer[i] = new StringBuilder(this.lDist + this.rDist + 1);
            ceilingLayer[i] = new StringBuilder(this.lDist + this.rDist + 1);
        }
        for (i = 0; i < this.hDist - 1; ++i) {
            wallLayers.add(new StringBuilder[this.fDist + this.bDist + 1]);
            for (j = 0; j < this.fDist + this.bDist + 1; ++j) {
                StringBuilder s;
                ((StringBuilder[])wallLayers.get((int)i))[j] = s = new StringBuilder(this.lDist + this.rDist + 3);
            }
        }
        for (i = 0; i < this.lDist + this.rDist + 1; ++i) {
            for (j = 0; j < this.fDist + this.bDist + 1; ++j) {
                int k;
                if (i == 0 || i == this.lDist + this.rDist || j == 0 || j == this.fDist + this.bDist) {
                    floorLayer[j].append('A');
                    for (k = 0; k < this.hDist - 1; ++k) {
                        if (!(i != 0 && i != this.lDist + this.rDist || j != 0 && j != this.fDist + this.bDist)) {
                            ((StringBuilder[])wallLayers.get(k))[j].append('A');
                            continue;
                        }
                        ((StringBuilder[])wallLayers.get(k))[j].append('W');
                    }
                    ceilingLayer[j].append('A');
                    continue;
                }
                floorLayer[j].append('B');
                for (k = 0; k < this.hDist - 1; ++k) {
                    ((StringBuilder[])wallLayers.get(k))[j].append('L');
                }
                if (i == this.lDist && j == this.fDist) {
                    ceilingLayer[j].append('S');
                    continue;
                }
                ceilingLayer[j].append('W');
            }
        }
        String[] f = new String[this.bDist + this.fDist + 1];
        for (int i2 = 0; i2 < floorLayer.length; ++i2) {
            f[i2] = floorLayer[i2].toString();
        }
        String[] m = new String[this.bDist + this.fDist + 1];
        for (int i3 = 0; i3 < ((StringBuilder[])wallLayers.get(0)).length; ++i3) {
            m[i3] = ((StringBuilder[])wallLayers.get(0))[i3].toString();
        }
        String[] c = new String[this.bDist + this.fDist + 1];
        for (int i4 = 0; i4 < ceilingLayer.length; ++i4) {
            c[i4] = ceilingLayer[i4].toString();
        }
        return FactoryBlockPattern.start(RelativeDirection.LEFT, RelativeDirection.FRONT, RelativeDirection.UP).aisle(f).aisle(m).setRepeatable(wallLayers.size()).aisle(c).where('S', Predicates.controller(Predicates.blocks(this.getDefinition().get()))).where('B', Predicates.blocks(Blocks.BRICKS)).where('W', Predicates.blockTag(CustomTags.CHARCOAL_PILE_IGNITER_WALLS)).where('L', CharcoalPileIgniterMachine.logPredicate()).where('A', Predicates.any()).build();
    }

    protected static TraceabilityPredicate logPredicate() {
        return new TraceabilityPredicate(multiblockState -> {
            BlockState state = multiblockState.getBlockState();
            long pos = multiblockState.getPos().asLong();
            boolean log = state.is(BlockTags.LOGS_THAT_BURN);
            if (log || state.isAir()) {
                multiblockState.getMatchContext().getOrCreate("logPos", Long2BooleanOpenHashMap::new).put(pos, log);
                return true;
            }
            return false;
        }, () -> (BlockInfo[])BuiltInRegistries.BLOCK.getTag(BlockTags.LOGS_THAT_BURN).stream().flatMap(HolderSet.ListBacked::stream).map(Holder::value).map(BlockInfo::fromBlock).toArray(BlockInfo[]::new));
    }

    public void updateDimensions() {
        Level level = this.getLevel();
        if (level == null) {
            return;
        }
        Direction front = this.getFrontFacing();
        Direction back = front.getOpposite();
        Direction left = RelativeDirection.LEFT.getRelativeFacing(front, this.getUpwardsFacing(), false);
        Direction right = RelativeDirection.RIGHT.getRelativeFacing(front, this.getUpwardsFacing(), false);
        BlockPos down = this.getPos().relative(Direction.DOWN);
        BlockPos.MutableBlockPos lPos = down.mutable();
        BlockPos.MutableBlockPos rPos = down.mutable();
        BlockPos.MutableBlockPos fPos = down.mutable();
        BlockPos.MutableBlockPos bPos = down.mutable();
        BlockPos.MutableBlockPos hPos = this.getPos().mutable();
        int lDist = 0;
        int rDist = 0;
        int bDist = 0;
        int fDist = 0;
        int hDist = 0;
        for (int i = 1; i < 6 && (lDist == 0 || rDist == 0 || hDist == 0); ++i) {
            if (lDist == 0 && CharcoalPileIgniterMachine.isBlockWall(level, lPos, left)) {
                lDist = i;
            }
            if (rDist == 0 && CharcoalPileIgniterMachine.isBlockWall(level, rPos, right)) {
                rDist = i;
            }
            if (bDist == 0 && CharcoalPileIgniterMachine.isBlockWall(level, bPos, back)) {
                bDist = i;
            }
            if (fDist == 0 && CharcoalPileIgniterMachine.isBlockWall(level, fPos, front)) {
                fDist = i;
            }
            if (hDist != 0 || !CharcoalPileIgniterMachine.isBlockFloor(level, hPos)) continue;
            hDist = i;
        }
        if (Math.abs(lDist - rDist) > 1 || Math.abs(bDist - fDist) > 1) {
            this.isFormed = false;
            return;
        }
        if (lDist < 1 || rDist < 1 || fDist < 1 || bDist < 1 || hDist < 2) {
            this.isFormed = false;
            return;
        }
        this.lDist = lDist;
        this.rDist = rDist;
        this.fDist = fDist;
        this.bDist = bDist;
        this.hDist = hDist;
    }

    private static boolean isBlockWall(Level level, BlockPos.MutableBlockPos pos, Direction direction) {
        return level.getBlockState((BlockPos)pos.move(direction)).is(CustomTags.CHARCOAL_PILE_IGNITER_WALLS);
    }

    private static boolean isBlockFloor(Level level, BlockPos.MutableBlockPos pos) {
        return level.getBlockState((BlockPos)pos.move(Direction.DOWN)).is(Blocks.BRICKS);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
        super.clientTick();
        if (this.isActive()) {
            BlockPos pos = this.getPos();
            Direction facing = Direction.UP;
            float xPos = (float)facing.getStepX() * 0.76f + (float)pos.getX() + 0.25f + GTValues.RNG.nextFloat() / 2.0f;
            float yPos = (float)facing.getStepY() * 0.76f + (float)pos.getY() + 0.25f;
            float zPos = (float)facing.getStepZ() * 0.76f + (float)pos.getZ() + 0.25f + GTValues.RNG.nextFloat() / 2.0f;
            float ySpd = (float)facing.getStepY() * 0.1f + 0.01f * GTValues.RNG.nextFloat();
            float horSpd = 0.03f * GTValues.RNG.nextFloat();
            float horSpd2 = 0.03f * GTValues.RNG.nextFloat();
            if (GTValues.RNG.nextFloat() < 0.1f) {
                this.getLevel().playLocalSound((double)xPos, (double)yPos, (double)zPos, SoundEvents.CAMPFIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            for (float xi = xPos - 1.0f; xi <= xPos + 1.0f; xi += 1.0f) {
                for (float zi = zPos - 1.0f; zi <= zPos + 1.0f; zi += 1.0f) {
                    if (GTValues.RNG.nextFloat() < 0.9f) continue;
                    this.getLevel().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)xi, (double)yPos, (double)zi, (double)horSpd, (double)ySpd, (double)horSpd2);
                }
            }
        }
    }

    private void convertLogBlocks() {
        Level level = this.getLevel();
        for (BlockPos pos : this.logPos) {
            level.setBlockAndUpdate(pos, GTBlocks.BRITTLE_CHARCOAL.getDefaultState());
        }
        this.logPos.clear();
    }

    @Override
    public InteractionResult onUse(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!this.isFormed() || this.hasAir) {
            return super.onUse(state, level, pos, player, hand, hit);
        }
        ItemStack stack = player.getItemInHand(hand);
        if (!stack.is(CustomTags.TOOLS_IGNITER)) {
            return InteractionResult.PASS;
        }
        if (level.isClientSide && !this.isActive()) {
            return InteractionResult.SUCCESS;
        }
        if (!this.isActive()) {
            boolean shouldActivate = false;
            Item item = stack.getItem();
            if (item instanceof ComponentItem) {
                ComponentItem compItem = (ComponentItem)item;
                for (IItemComponent component : compItem.getComponents()) {
                    LighterBehavior lighter;
                    if (!(component instanceof LighterBehavior) || !(lighter = (LighterBehavior)component).consumeFuel(player, stack)) continue;
                    shouldActivate = true;
                    break;
                }
            } else if (stack.isDamageableItem()) {
                stack.hurtAndBreak(1, (LivingEntity)player, p -> p.broadcastBreakEvent(hand));
                shouldActivate = true;
            } else {
                stack.shrink(1);
                shouldActivate = true;
            }
            if (shouldActivate) {
                this.getRecipeLogic().setStatus(RecipeLogic.Status.WORKING);
                level.playSound(null, pos, stack.is(Items.FIRE_CHARGE) ? SoundEvents.FIRECHARGE_USE : SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.CONSUME;
            }
        }
        return super.onUse(state, level, pos, player, hand, hit);
    }

    public static class CharcoalRecipeLogic
    extends RecipeLogic {
        private final CharcoalPileIgniterMachine machine;

        public CharcoalRecipeLogic(CharcoalPileIgniterMachine machine) {
            super(machine);
            this.machine = machine;
        }

        @Override
        public void serverTick() {
            super.serverTick();
            if (this.isWorking() && this.duration > 0 && ++this.progress >= this.duration) {
                this.progress = 0;
                this.duration = 0;
                this.machine.convertLogBlocks();
                this.setStatus(RecipeLogic.Status.IDLE);
            }
        }

        public void setDuration(int max) {
            this.duration = max;
        }
    }
}

