/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.primitive;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.UITemplate;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.gui.widget.TankWidget;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.IUIMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.primitive.PrimitiveWorkableMachine;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CokeOvenMachine
extends PrimitiveWorkableMachine
implements IUIMachine {
    public CokeOvenMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, args);
    }

    public ModularUI createUI(Player entityPlayer) {
        return new ModularUI(176, 166, (IUIHolder)this, entityPlayer).background(new IGuiTexture[]{GuiTextures.PRIMITIVE_BACKGROUND}).widget((Widget)new LabelWidget(5, 5, this.getBlockState().getBlock().getDescriptionId())).widget((Widget)new SlotWidget((IItemHandlerModifiable)this.importItems.storage, 0, 52, 30, true, true).setBackgroundTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.PRIMITIVE_SLOT, GuiTextures.PRIMITIVE_FURNACE_OVERLAY}))).widget((Widget)new ProgressWidget(this.recipeLogic::getProgressPercent, 76, 32, 20, 15, GuiTextures.PRIMITIVE_BLAST_FURNACE_PROGRESS_BAR)).widget((Widget)new SlotWidget((IItemHandlerModifiable)this.exportItems.storage, 0, 103, 30, true, false).setBackgroundTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.PRIMITIVE_SLOT, GuiTextures.PRIMITIVE_FURNACE_OVERLAY}))).widget(new TankWidget(this.exportFluids.getStorages()[0], 134, 13, 20, 58, true, false).setBackground((IGuiTexture)GuiTextures.PRIMITIVE_LARGE_FLUID_TANK).setFillDirection(ProgressTexture.FillDirection.DOWN_TO_UP).setShowAmountOverlay(false).setOverlay((IGuiTexture)GuiTextures.PRIMITIVE_LARGE_FLUID_TANK_OVERLAY)).widget((Widget)UITemplate.bindPlayerInventory(entityPlayer.getInventory(), (IGuiTexture)GuiTextures.PRIMITIVE_SLOT, 7, 84, true));
    }

    @Override
    public void animateTick(RandomSource random) {
        if (this.isActive()) {
            BlockPos pos = this.getPos();
            float x = (float)pos.getX() + 0.5f;
            float z = (float)pos.getZ() + 0.5f;
            Direction facing = this.getFrontFacing();
            float horizontalOffset = GTValues.RNG.nextFloat() * 0.6f - 0.3f;
            float y = (float)pos.getY() + GTValues.RNG.nextFloat() * 0.375f + 0.3f;
            if (facing.getAxis() == Direction.Axis.X) {
                x = facing.getAxisDirection() == Direction.AxisDirection.POSITIVE ? (x += 0.52f) : (x -= 0.52f);
                z += horizontalOffset;
            } else if (facing.getAxis() == Direction.Axis.Z) {
                z = facing.getAxisDirection() == Direction.AxisDirection.POSITIVE ? (z += 0.52f) : (z -= 0.52f);
                x += horizontalOffset;
            }
            if (ConfigHolder.INSTANCE.machines.machineSounds && GTValues.RNG.nextDouble() < 0.1) {
                this.getLevel().playLocalSound((double)x, (double)y, (double)z, SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            this.getLevel().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
            this.getLevel().addParticle((ParticleOptions)ParticleTypes.FLAME, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public InteractionResult onUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!this.isRemote()) {
            if (super.onUse(state, world, pos, player, hand, hit) == InteractionResult.SUCCESS) {
                return InteractionResult.SUCCESS;
            }
            if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.exportFluids)) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return super.onUse(state, world, pos, player, hand, hit);
    }
}

