/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.owner;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.common.machine.owner.MachineOwner;
import earth.terrarium.argonauts.api.client.guild.GuildClientApi;
import earth.terrarium.argonauts.api.guild.Guild;
import earth.terrarium.argonauts.api.guild.GuildApi;
import earth.terrarium.argonauts.common.handlers.guild.members.GuildMember;
import earth.terrarium.argonauts.common.handlers.guild.members.GuildMembers;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public class ArgonautsOwner
extends MachineOwner {
    private static final Component displayName = Component.translatable((String)"gtceu.ownership.name.argonauts");

    public ArgonautsOwner(UUID playerUUID) {
        super(playerUUID);
    }

    @Nullable
    public Guild getPlayerGuild(UUID playerUUID) {
        if (GTCEu.isClientThread()) {
            return GuildClientApi.API.getPlayerGuild(playerUUID);
        }
        return GuildApi.API.getPlayerGuild(ServerLifecycleHooks.getCurrentServer(), playerUUID);
    }

    @Nullable
    public Guild getGuild() {
        return this.getPlayerGuild(this.playerUUID);
    }

    @Override
    public @UnmodifiableView @NotNull Set<UUID> getMembers() {
        Guild guild = this.getGuild();
        if (guild == null) {
            return Collections.emptySet();
        }
        HashSet<UUID> members = new HashSet<UUID>(((GuildMembers)guild.members()).size());
        for (GuildMember member : ((GuildMembers)guild.members()).allMembers()) {
            members.add(member.profile().getId());
        }
        return members;
    }

    @Override
    public boolean isPlayerInTeam(UUID playerUUID) {
        if (this.playerUUID.equals(playerUUID)) {
            return true;
        }
        Guild otherGuild = this.getPlayerGuild(playerUUID);
        return otherGuild != null && otherGuild.equals(this.getGuild());
    }

    @Override
    public boolean isPlayerFriendly(UUID playerUUID) {
        Guild guild = this.getGuild();
        if (guild == null) {
            return this.playerUUID.equals(playerUUID);
        }
        return guild.isPublic() || ((GuildMembers)guild.members()).isMember(playerUUID) || ((GuildMembers)guild.members()).isAllied(playerUUID);
    }

    @Override
    public UUID getUUID() {
        Guild guild = this.getGuild();
        return guild != null ? guild.id() : EMPTY;
    }

    @Override
    public String getName() {
        Guild guild = this.getGuild();
        return guild != null ? guild.displayName().getString() : Component.translatable((String)"gtceu.tooltip.status.trinary.unknown").getString();
    }

    @Override
    public Component getTypeDisplayName() {
        return displayName;
    }

    @Override
    public void displayInfo(List<Component> compList) {
        super.displayInfo(compList);
        compList.add((Component)Component.translatable((String)"behavior.portable_scanner.guild_name", (Object[])new Object[]{this.getName()}));
        MachineOwner.displayPlayerInfo(compList, this.playerUUID);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ArgonautsOwner && super.equals(object);
    }
}

