/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.owner;

import com.gregtechceu.gtceu.common.machine.owner.MachineOwner;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.UsernameCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;

public class PlayerOwner
extends MachineOwner {
    private static final Component displayName = Component.translatable((String)"gtceu.ownership.name.player");

    public PlayerOwner(UUID playerUUID) {
        super(playerUUID);
    }

    @Override
    public @UnmodifiableView @NotNull Set<UUID> getMembers() {
        return Set.of(this.getUUID());
    }

    @Override
    public boolean isPlayerInTeam(UUID playerUUID) {
        return this.playerUUID.equals(playerUUID);
    }

    @Override
    public boolean isPlayerFriendly(UUID playerUUID) {
        return this.playerUUID.equals(playerUUID);
    }

    @Override
    public UUID getUUID() {
        return this.playerUUID;
    }

    @Override
    public String getName() {
        return UsernameCache.getLastKnownUsername((UUID)this.playerUUID);
    }

    @Override
    public Component getTypeDisplayName() {
        return displayName;
    }

    @Override
    public void displayInfo(List<Component> compList) {
        super.displayInfo(compList);
        MachineOwner.displayPlayerInfo(compList, this.playerUUID);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof PlayerOwner && super.equals(object);
    }
}

