/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.cable;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.pipenet.IRoutePath;
import com.gregtechceu.gtceu.common.blockentity.CableBlockEntity;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class EnergyRoutePath
implements IRoutePath<IEnergyContainer> {
    private final CableBlockEntity targetPipe;
    private final BlockPos targetPipePos;
    private final Direction targetFacing;
    private final int distance;
    private final CableBlockEntity[] path;
    private final long maxLoss;

    public EnergyRoutePath(BlockPos targetPipePos, Direction targetFacing, CableBlockEntity[] path, int distance, long maxLoss) {
        this.targetPipe = path[path.length - 1];
        this.targetPipePos = targetPipePos;
        this.targetFacing = targetFacing;
        this.path = path;
        this.distance = distance;
        this.maxLoss = maxLoss;
    }

    @Override
    @Nullable
    public IEnergyContainer getHandler(Level world) {
        return GTCapabilityHelper.getEnergyContainer(world, this.getTargetPipePos().relative(this.targetFacing), this.targetFacing.getOpposite());
    }

    @Override
    @Generated
    public BlockPos getTargetPipePos() {
        return this.targetPipePos;
    }

    @Override
    @Generated
    public Direction getTargetFacing() {
        return this.targetFacing;
    }

    @Override
    @Generated
    public int getDistance() {
        return this.distance;
    }

    @Generated
    public CableBlockEntity[] getPath() {
        return this.path;
    }

    @Generated
    public long getMaxLoss() {
        return this.maxLoss;
    }
}

