/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.duct;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.IHazardParticleContainer;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.HazardProperty;
import com.gregtechceu.gtceu.api.data.medicalcondition.MedicalCondition;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.IEnvironmentalHazardCleaner;
import com.gregtechceu.gtceu.common.blockentity.DuctPipeBlockEntity;
import com.gregtechceu.gtceu.common.capability.EnvironmentalHazardSavedData;
import com.gregtechceu.gtceu.common.pipelike.duct.DuctPipeNet;
import com.gregtechceu.gtceu.common.pipelike.duct.DuctRoutePath;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuctNetHandler
implements IHazardParticleContainer {
    private DuctPipeNet net;
    private final DuctPipeBlockEntity pipe;
    private final Direction facing;

    public DuctNetHandler(DuctPipeNet net, @NotNull DuctPipeBlockEntity pipe, @Nullable Direction facing) {
        this.net = net;
        this.pipe = pipe;
        this.facing = facing;
    }

    public void updateNetwork(DuctPipeNet net) {
        this.net = net;
    }

    @Nullable
    private IHazardParticleContainer getInnerContainer() {
        if (this.net == null || this.pipe.isInValid() || this.facing == null || this.pipe.isBlocked(this.facing)) {
            return null;
        }
        final List<DuctRoutePath> data = this.net.getNetData(this.pipe.getPipePos(), this.facing);
        if (data == null) {
            return null;
        }
        return new IHazardParticleContainer(){

            @Override
            public boolean inputsHazard(Direction side, MedicalCondition condition) {
                return data.stream().map(path -> path.getHandler((Level)DuctNetHandler.this.net.getLevel())).filter(Objects::nonNull).anyMatch(handler -> handler.inputsHazard(side, condition));
            }

            @Override
            public float changeHazard(MedicalCondition condition, float differenceAmount) {
                float total = 0.0f;
                for (DuctRoutePath path : data) {
                    IHazardParticleContainer handler = path.getHandler((Level)DuctNetHandler.this.net.getLevel());
                    if (handler == null && path.getTargetPipe().isConnected(path.getTargetFacing())) {
                        IMachineBlockEntity machineBE;
                        Object object = DuctNetHandler.this.net.getLevel().getBlockEntity(path.getTargetPipePos().relative(path.getTargetFacing()));
                        if (object instanceof IMachineBlockEntity && (object = (machineBE = (IMachineBlockEntity)object).getMetaMachine()) instanceof IEnvironmentalHazardCleaner) {
                            IEnvironmentalHazardCleaner cleaner = (IEnvironmentalHazardCleaner)object;
                            cleaner.cleanHazard(condition, differenceAmount);
                            break;
                        }
                        EnvironmentalHazardSavedData savedData = EnvironmentalHazardSavedData.getOrCreate(DuctNetHandler.this.net.getLevel());
                        savedData.addZone(path.getTargetPipePos().relative(path.getTargetFacing()), differenceAmount, true, HazardProperty.HazardTrigger.INHALATION, condition);
                        total += differenceAmount;
                        DuctNetHandler.emitPollutionParticles(DuctNetHandler.this.net.getLevel(), path.getTargetPipePos(), path.getTargetFacing());
                        break;
                    }
                    if (handler == null) continue;
                    float change = handler.changeHazard(condition, differenceAmount);
                    differenceAmount -= change;
                    total += change;
                    if (!(differenceAmount <= 0.0f)) continue;
                    break;
                }
                return total;
            }

            @Override
            public float getHazardStored(MedicalCondition condition) {
                float total = 0.0f;
                for (DuctRoutePath path : data) {
                    IHazardParticleContainer handler = path.getHandler((Level)DuctNetHandler.this.net.getLevel());
                    if (handler == null) continue;
                    total += handler.getHazardStored(condition);
                }
                return total;
            }

            @Override
            public float getHazardCapacity(MedicalCondition condition) {
                float total = 0.0f;
                for (DuctRoutePath path : data) {
                    IHazardParticleContainer handler = path.getHandler((Level)DuctNetHandler.this.net.getLevel());
                    if (handler != null) {
                        total += handler.getHazardCapacity(condition);
                        continue;
                    }
                    if (!path.getTargetPipe().isConnected(path.getTargetFacing())) continue;
                    total += 2.1474836E9f;
                    break;
                }
                return total;
            }
        };
    }

    @Override
    public boolean inputsHazard(Direction side, MedicalCondition condition) {
        IHazardParticleContainer handler = this.getInnerContainer();
        if (handler == null) {
            return false;
        }
        return handler.inputsHazard(side, condition);
    }

    @Override
    public boolean outputsHazard(Direction side, MedicalCondition condition) {
        return true;
    }

    @Override
    public float changeHazard(MedicalCondition condition, float differenceAmount) {
        IHazardParticleContainer handler = this.getInnerContainer();
        if (handler == null) {
            return 0.0f;
        }
        return handler.changeHazard(condition, differenceAmount);
    }

    @Override
    public float getHazardStored(MedicalCondition condition) {
        IHazardParticleContainer handler = this.getInnerContainer();
        if (handler == null) {
            return 0.0f;
        }
        return handler.getHazardStored(condition);
    }

    @Override
    public float getHazardCapacity(MedicalCondition condition) {
        IHazardParticleContainer handler = this.getInnerContainer();
        if (handler == null) {
            return 0.0f;
        }
        return handler.getHazardCapacity(condition);
    }

    public static void emitPollutionParticles(ServerLevel level, BlockPos pos, Direction frontFacing) {
        float zSpd;
        float xSpd;
        float xPos = (float)frontFacing.getStepX() * 0.76f + (float)pos.getX() + 0.25f;
        float yPos = (float)frontFacing.getStepY() * 0.76f + (float)pos.getY() + 0.25f;
        float zPos = (float)frontFacing.getStepZ() * 0.76f + (float)pos.getZ() + 0.25f;
        float ySpd = (float)frontFacing.getStepY() * 0.1f + 0.2f + 0.1f * GTValues.RNG.nextFloat();
        if (frontFacing.getStepY() == -1) {
            float temp = GTValues.RNG.nextFloat() * 2.0f * (float)Math.PI;
            xSpd = (float)Math.sin(temp) * 0.1f;
            zSpd = (float)Math.cos(temp) * 0.1f;
        } else {
            xSpd = (float)frontFacing.getStepX() * (0.1f + 0.2f * GTValues.RNG.nextFloat());
            zSpd = (float)frontFacing.getStepZ() * (0.1f + 0.2f * GTValues.RNG.nextFloat());
        }
        level.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)(xPos + GTValues.RNG.nextFloat() * 0.5f), (double)(yPos + GTValues.RNG.nextFloat() * 0.5f), (double)(zPos + GTValues.RNG.nextFloat() * 0.5f), 1, (double)xSpd, (double)ySpd, (double)zSpd, 0.1);
    }

    @Generated
    public DuctPipeNet getNet() {
        return this.net;
    }
}

