/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.recipe.condition;

import com.gregtechceu.gtceu.api.data.medicalcondition.MedicalCondition;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.condition.RecipeConditionType;
import com.gregtechceu.gtceu.common.capability.EnvironmentalHazardSavedData;
import com.gregtechceu.gtceu.common.data.GTMedicalConditions;
import com.gregtechceu.gtceu.common.data.GTRecipeConditions;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class EnvironmentalHazardCondition
extends RecipeCondition {
    public static final Codec<EnvironmentalHazardCondition> CODEC = RecordCodecBuilder.create(instance -> RecipeCondition.isReverse(instance).and((App)MedicalCondition.CODEC.fieldOf("condition").forGetter(val -> val.condition)).apply((Applicative)instance, EnvironmentalHazardCondition::new));
    private MedicalCondition condition = GTMedicalConditions.CARBON_MONOXIDE_POISONING;

    public EnvironmentalHazardCondition(boolean isReverse, MedicalCondition condition) {
        super(isReverse);
        this.condition = condition;
    }

    @Override
    public RecipeConditionType<?> getType() {
        return GTRecipeConditions.ENVIRONMENTAL_HAZARD;
    }

    @Override
    public Component getTooltips() {
        return this.isReverse ? Component.translatable((String)"gtceu.recipe.environmental_hazard.reverse", (Object[])new Object[]{Component.translatable((String)("gtceu.medical_condition." + this.condition.name))}) : Component.translatable((String)"gtceu.recipe.environmental_hazard", (Object[])new Object[]{Component.translatable((String)("gtceu.medical_condition." + this.condition.name))});
    }

    @Override
    public boolean testCondition(@NotNull GTRecipe recipe, @NotNull RecipeLogic recipeLogic) {
        if (!ConfigHolder.INSTANCE.gameplay.hazardsEnabled) {
            return true;
        }
        Level level = recipeLogic.getMachine().getLevel();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        EnvironmentalHazardSavedData savedData = EnvironmentalHazardSavedData.getOrCreate(serverLevel);
        EnvironmentalHazardSavedData.HazardZone zone = savedData.getZoneByContainedPos(recipeLogic.getMachine().getPos());
        return zone != null && zone.strength() > 0.0f;
    }

    @Override
    public RecipeCondition createTemplate() {
        return new EnvironmentalHazardCondition();
    }

    @Generated
    public EnvironmentalHazardCondition() {
    }

    @Generated
    public EnvironmentalHazardCondition(MedicalCondition condition) {
        this.condition = condition;
    }

    @Generated
    public MedicalCondition getCondition() {
        return this.condition;
    }
}

