/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.worldgen.feature;

import com.gregtechceu.gtceu.common.worldgen.feature.configurations.StoneBlobConfiguration;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;

public class StoneBlobFeature
extends Feature<StoneBlobConfiguration> {
    public StoneBlobFeature() {
        super(StoneBlobConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext<StoneBlobConfiguration> context) {
        RandomSource random = context.random();
        BlockPos blockpos = context.origin();
        WorldGenLevel level = context.level();
        StoneBlobConfiguration config = (StoneBlobConfiguration)context.config();
        int placedAmount = 0;
        int size = config.size().sample(random);
        int radius = Mth.ceil((float)((float)size / 2.0f));
        int x0 = blockpos.getX() - radius;
        int y0 = blockpos.getY() - radius;
        int z0 = blockpos.getZ() - radius;
        int width = size + 1;
        int length = size + 1;
        int height = size + 1;
        if (blockpos.getY() >= level.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, blockpos.getX(), blockpos.getZ())) {
            return false;
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        try (BulkSectionAccess bulkSectionAccess = new BulkSectionAccess((LevelAccessor)level);){
            for (int x = 0; x < width; ++x) {
                float dx = (float)x * 2.0f / (float)width - 1.0f;
                if (dx * dx > 1.0f) continue;
                for (int y = 0; y < height; ++y) {
                    float dy = (float)y * 2.0f / (float)height - 1.0f;
                    if (dx * dx + dy * dy > 1.0f || level.isOutsideBuildHeight(y0 + y)) continue;
                    for (int z = 0; z < length; ++z) {
                        LevelChunkSection levelchunksection;
                        float dz = (float)z * 2.0f / (float)length - 1.0f;
                        if (dx * dx + dy * dy + dz * dz > 1.0f) continue;
                        int currentX = x0 + x;
                        int currentY = y0 + y;
                        int currentZ = z0 + z;
                        mutablePos.set(currentX, currentY, currentZ);
                        if (!level.ensureCanWrite((BlockPos)mutablePos) || (levelchunksection = bulkSectionAccess.getSection((BlockPos)mutablePos)) == null) continue;
                        int sectionX = SectionPos.sectionRelative((int)currentX);
                        int sectionY = SectionPos.sectionRelative((int)currentY);
                        int sectionZ = SectionPos.sectionRelative((int)currentZ);
                        BlockState blockstate = levelchunksection.getBlockState(sectionX, sectionY, sectionZ);
                        if (!this.canPlaceOre(blockstate, arg_0 -> ((BulkSectionAccess)bulkSectionAccess).getBlockState(arg_0), random, config.state(), mutablePos) || config.state().state.isAir()) continue;
                        levelchunksection.setBlockState(sectionX, sectionY, sectionZ, config.state().state, false);
                        ++placedAmount;
                    }
                }
            }
        }
        return placedAmount > 0;
    }

    public boolean canPlaceOre(BlockState state, Function<BlockPos, BlockState> adjacentStateAccessor, RandomSource random, OreConfiguration.TargetBlockState targetState, BlockPos.MutableBlockPos mutablePos) {
        if (!targetState.target.test(state, random)) {
            return false;
        }
        return !StoneBlobFeature.isAdjacentToAir(adjacentStateAccessor, (BlockPos)mutablePos);
    }
}

