/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.core.mixins.client;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.MaterialBlock;
import com.gregtechceu.gtceu.api.block.MaterialPipeBlock;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.WireProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.item.tool.aoe.AoESymmetrical;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.ITieredMachine;
import com.gregtechceu.gtceu.api.machine.steam.SteamMachine;
import com.gregtechceu.gtceu.api.pipenet.IPipeNode;
import com.gregtechceu.gtceu.common.blockentity.CableBlockEntity;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.List;
import java.util.SortedSet;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.BlockDestructionProgress;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={LevelRenderer.class}, priority=500)
public abstract class LevelRendererMixin {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    @Final
    private Long2ObjectMap<SortedSet<BlockDestructionProgress>> destructionProgress;
    @Shadow
    @Final
    private RenderBuffers renderBuffers;
    @Shadow
    @Nullable
    private ClientLevel level;
    @Unique
    private final RandomSource gtceu$modelRandom = RandomSource.create();

    @Inject(method={"renderLevel"}, at={@At(value="HEAD")})
    private void renderLevel(PoseStack poseStack, float partialTick, long finishNanoTime, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f projectionMatrix, CallbackInfo ci) {
        HitResult hitResult;
        if (this.minecraft.player == null || this.level == null) {
            return;
        }
        ItemStack mainHandItem = this.minecraft.player.getMainHandItem();
        if (this.minecraft.player.isShiftKeyDown() || !ToolHelper.hasBehaviorsTag(mainHandItem) || !((hitResult = this.minecraft.hitResult) instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult hitResult2 = (BlockHitResult)hitResult;
        AoESymmetrical aoeDefinition = ToolHelper.getAoEDefinition(mainHandItem);
        if (aoeDefinition.isZero()) {
            return;
        }
        BlockPos hitPos = hitResult2.getBlockPos();
        BlockState hitState = this.level.getBlockState(hitPos);
        SortedSet progresses = (SortedSet)this.destructionProgress.get(hitPos.asLong());
        if (progresses == null || progresses.isEmpty() || !mainHandItem.isCorrectToolForDrops(hitState)) {
            return;
        }
        BlockDestructionProgress progress = (BlockDestructionProgress)progresses.last();
        UseOnContext context = new UseOnContext((Player)this.minecraft.player, InteractionHand.MAIN_HAND, hitResult2);
        List<BlockPos> positions = ToolHelper.getHarvestableBlocks(aoeDefinition, context);
        Vec3 camPos = camera.getPosition();
        poseStack.pushPose();
        poseStack.translate(-camPos.x(), -camPos.y(), -camPos.z());
        for (BlockPos pos : positions) {
            poseStack.pushPose();
            poseStack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            PoseStack.Pose last = poseStack.last();
            SheetedDecalTextureGenerator breakProgressDecal = new SheetedDecalTextureGenerator(this.renderBuffers.crumblingBufferSource().getBuffer((RenderType)ModelBakery.DESTROY_TYPES.get(progress.getProgress())), last.pose(), last.normal(), 1.0f);
            ModelData modelData = this.level.getModelDataManager().getAt(pos);
            this.minecraft.getBlockRenderer().renderBreakingTexture(this.level.getBlockState(pos), pos, (BlockAndTintGetter)this.level, poseStack, (VertexConsumer)breakProgressDecal, modelData != null ? modelData : ModelData.EMPTY);
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    @Shadow
    private static void renderShape(PoseStack poseStack, VertexConsumer consumer, VoxelShape shape, double x, double y, double z, float red, float green, float blue, float alpha) {
        throw new AssertionError();
    }

    @WrapOperation(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderHitOutline(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/world/entity/Entity;DDDLnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V")})
    private void gtceu$handleAOEOutline(LevelRenderer instance, PoseStack poseStack, VertexConsumer consumer, Entity entity, double camX, double camY, double camZ, BlockPos pos, BlockState state, Operation<Void> original) {
        HitResult hitResult;
        if (this.minecraft.player == null || this.level == null) {
            return;
        }
        ItemStack mainHandItem = this.minecraft.player.getMainHandItem();
        if (state.isAir() || this.minecraft.player.isShiftKeyDown() || !this.level.isInWorldBounds(pos) || !mainHandItem.isCorrectToolForDrops(state) || !ToolHelper.hasBehaviorsTag(mainHandItem) || !((hitResult = this.minecraft.hitResult) instanceof BlockHitResult)) {
            this.gtceu$renderContextAwareOutline(instance, poseStack, consumer, entity, camX, camY, camZ, pos, state, original);
            return;
        }
        BlockHitResult hitResult2 = (BlockHitResult)hitResult;
        UseOnContext context = new UseOnContext((Player)this.minecraft.player, InteractionHand.MAIN_HAND, hitResult2);
        List<BlockPos> blocks = ToolHelper.getHarvestableBlocks(ToolHelper.getAoEDefinition(mainHandItem), context);
        blocks.sort((o1, o2) -> {
            if (this.level.getBlockState(o1).getBlock() instanceof MaterialBlock) {
                if (this.level.getBlockState(o2).getBlock() instanceof MaterialBlock) {
                    return 0;
                }
                return 1;
            }
            if (this.level.getBlockState(o2).getBlock() instanceof MaterialBlock) {
                return -1;
            }
            return 0;
        });
        blocks.forEach(blockPos -> this.gtceu$renderContextAwareOutline(instance, poseStack, consumer, entity, camX, camY, camZ, (BlockPos)blockPos, this.level.getBlockState(blockPos), original));
    }

    @Unique
    private void gtceu$renderContextAwareOutline(LevelRenderer instance, PoseStack poseStack, VertexConsumer consumer, Entity entity, double camX, double camY, double camZ, BlockPos pos, BlockState state, Operation<Void> original) {
        assert (this.level != null);
        ConfigHolder.RendererConfigs rendererCfg = ConfigHolder.INSTANCE.client.renderer;
        int rgb = 0;
        boolean doRenderColoredOutline = false;
        MaterialEntry materialEntry = this.gtceu$getTranslucentBlockMaterial(state, pos);
        if (!materialEntry.isEmpty()) {
            doRenderColoredOutline = true;
            rgb = materialEntry.material().getMaterialRGB();
        } else {
            Object steam;
            BlockEntity blockEntity = this.level.getBlockEntity(pos);
            if (blockEntity instanceof IMachineBlockEntity) {
                IMachineBlockEntity mbe = (IMachineBlockEntity)blockEntity;
                if (rendererCfg.coloredTieredMachineOutline) {
                    var22_18 = mbe.getMetaMachine();
                    if (var22_18 instanceof SteamMachine) {
                        steam = (SteamMachine)var22_18;
                        doRenderColoredOutline = true;
                        rgb = ((SteamMachine)steam).isHighPressure() ? 7959919 : 12291667;
                    } else {
                        var22_18 = mbe.getMetaMachine();
                        if (var22_18 instanceof ITieredMachine) {
                            ITieredMachine tiered = (ITieredMachine)((Object)var22_18);
                            doRenderColoredOutline = true;
                            rgb = GTValues.VCM[tiered.getTier()];
                        }
                    }
                }
            } else if (rendererCfg.coloredWireOutline && (steam = this.level.getBlockEntity(pos)) instanceof IPipeNode) {
                IPipeNode pipe = (IPipeNode)steam;
                doRenderColoredOutline = true;
                if (!pipe.getFrameMaterial().isNull()) {
                    rgb = pipe.getFrameMaterial().getMaterialRGB();
                } else if (pipe instanceof CableBlockEntity) {
                    CableBlockEntity cable = (CableBlockEntity)pipe;
                    rgb = GTValues.VCM[GTUtil.getTierByVoltage(((WireProperties)cable.getNodeData()).getVoltage())];
                } else {
                    var22_18 = state.getBlock();
                    if (var22_18 instanceof MaterialPipeBlock) {
                        MaterialPipeBlock materialPipe = (MaterialPipeBlock)((Object)var22_18);
                        rgb = materialPipe.material.getMaterialRGB();
                    }
                }
            }
        }
        VoxelShape blockShape = state.getShape((BlockGetter)this.level, pos, CollisionContext.of((Entity)entity));
        if (doRenderColoredOutline) {
            float red = (float)FastColor.ARGB32.red((int)rgb) / 255.0f;
            float green = (float)FastColor.ARGB32.green((int)rgb) / 255.0f;
            float blue = (float)FastColor.ARGB32.blue((int)rgb) / 255.0f;
            LevelRendererMixin.renderShape(poseStack, consumer, blockShape, (double)pos.getX() - camX, (double)pos.getY() - camY, (double)pos.getZ() - camZ, red, green, blue, 1.0f);
            return;
        }
        BlockPos.MutableBlockPos mutable = pos.mutable();
        for (BlockPos o : GTUtil.NON_CORNER_NEIGHBOURS) {
            BlockPos.MutableBlockPos offset = mutable.setWithOffset((Vec3i)pos, (Vec3i)o);
            if (this.gtceu$getTranslucentBlockMaterial(this.level.getBlockState((BlockPos)offset), (BlockPos)offset).isEmpty()) continue;
            LevelRendererMixin.renderShape(poseStack, consumer, blockShape, (double)pos.getX() - camX, (double)pos.getY() - camY, (double)pos.getZ() - camZ, 0.0f, 0.0f, 0.0f, 1.0f);
            return;
        }
        original.call(new Object[]{instance, poseStack, consumer, entity, camX, camY, camZ, pos, state});
    }

    @Unique
    @NotNull
    private MaterialEntry gtceu$getTranslucentBlockMaterial(BlockState state, BlockPos pos) {
        assert (this.level != null);
        if (!state.isSolidRender((BlockGetter)this.level, pos) && !(state.getBlock() instanceof MaterialBlock)) {
            return MaterialEntry.NULL_ENTRY;
        }
        BakedModel blockModel = this.minecraft.getBlockRenderer().getBlockModel(state);
        ModelData modelData = this.level.getModelDataManager().getAt(pos);
        if (modelData == null) {
            modelData = ModelData.EMPTY;
        }
        modelData = blockModel.getModelData((BlockAndTintGetter)this.level, pos, state, modelData);
        this.gtceu$modelRandom.setSeed(state.getSeed(pos));
        if (blockModel.getRenderTypes(state, this.gtceu$modelRandom, modelData).contains(RenderType.translucent())) {
            return ChemicalHelper.getMaterialEntry((ItemLike)state.getBlock());
        }
        return MaterialEntry.NULL_ENTRY;
    }
}

