/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.core.mixins.client;

import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MultiPlayerGameMode.class})
public class MultiPlayerGameModeMixin {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    private ItemStack destroyingItem;
    @Shadow
    private BlockPos destroyBlockPos;

    @Inject(method={"destroyBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private void gtceu$destroyBlock(BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        ItemStack mainHandItem = this.minecraft.player.getMainHandItem();
        if (this.minecraft.player == null || this.minecraft.level == null || !ToolHelper.hasBehaviorsTag(mainHandItem) || ToolHelper.getAoEDefinition(mainHandItem).isZero() || this.minecraft.player.isShiftKeyDown() || !mainHandItem.isCorrectToolForDrops(this.minecraft.level.getBlockState(pos))) {
            return;
        }
        cir.setReturnValue((Object)false);
        ClientLevel level = this.minecraft.level;
        if (level == null) {
            return;
        }
        BlockState state = level.getBlockState(pos);
        state.getBlock().destroy((LevelAccessor)level, pos, state);
    }

    @Inject(method={"sameDestroyTarget"}, at={@At(value="RETURN")}, cancellable=true)
    private void gtceu$sameDestroyTarget(BlockPos pos, CallbackInfoReturnable<Boolean> cir, @Local ItemStack itemstack) {
        boolean gtmTarget = pos.equals((Object)this.destroyBlockPos) && ItemStack.isSameItem((ItemStack)itemstack, (ItemStack)this.destroyingItem) && !this.destroyingItem.shouldCauseBlockBreakReset(itemstack);
        cir.setReturnValue((Object)(gtmTarget || (Boolean)cir.getReturnValue() != false ? 1 : 0));
    }
}

