/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.recipe.StrictShapedRecipe;
import com.lowdragmc.lowdraglib.utils.Builder;
import com.lowdragmc.lowdraglib.utils.NBTToJsonConverter;
import java.util.Iterator;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.StrictNBTIngredient;
import org.jetbrains.annotations.Nullable;

public class ShapedRecipeBuilder
extends Builder<Ingredient, ShapedRecipeBuilder> {
    protected ItemStack output = ItemStack.EMPTY;
    protected ResourceLocation id;
    protected String group;
    protected boolean isStrict;

    public ShapedRecipeBuilder(@Nullable ResourceLocation id) {
        this.id = id;
    }

    public ShapedRecipeBuilder() {
        this(null);
    }

    public ShapedRecipeBuilder pattern(String slice) {
        return (ShapedRecipeBuilder)this.aisle(new String[]{slice});
    }

    public ShapedRecipeBuilder define(char cha, TagKey<Item> itemStack) {
        return (ShapedRecipeBuilder)this.where(cha, Ingredient.of(itemStack));
    }

    public ShapedRecipeBuilder define(char cha, ItemStack itemStack) {
        return (ShapedRecipeBuilder)this.where(cha, itemStack.hasTag() ? StrictNBTIngredient.of((ItemStack)itemStack) : Ingredient.of((ItemStack[])new ItemStack[]{itemStack}));
    }

    public ShapedRecipeBuilder define(char cha, ItemLike itemLike) {
        return (ShapedRecipeBuilder)this.where(cha, Ingredient.of((ItemLike[])new ItemLike[]{itemLike}));
    }

    public ShapedRecipeBuilder define(char cha, Ingredient ingredient) {
        return (ShapedRecipeBuilder)this.where(cha, ingredient);
    }

    public ShapedRecipeBuilder output(ItemStack itemStack) {
        this.output = itemStack.copy();
        return this;
    }

    public ShapedRecipeBuilder output(ItemStack itemStack, int count) {
        this.output = itemStack.copy();
        this.output.setCount(count);
        return this;
    }

    public ShapedRecipeBuilder output(ItemStack itemStack, int count, CompoundTag nbt) {
        this.output = itemStack.copy();
        this.output.setCount(count);
        this.output.setTag(nbt);
        return this;
    }

    public ShapedRecipeBuilder id(ResourceLocation id) {
        this.id = id;
        return this;
    }

    public ShapedRecipeBuilder id(String id) {
        this.id = new ResourceLocation(id);
        return this;
    }

    public ShapedRecipeBuilder group(String group) {
        this.group = group;
        return this;
    }

    public ShapedRecipeBuilder isStrict(boolean isStrict) {
        this.isStrict = isStrict;
        return this;
    }

    public ShapedRecipeBuilder shallowCopy() {
        ShapedRecipeBuilder builder = (ShapedRecipeBuilder)super.shallowCopy();
        builder.output = this.output.copy();
        return builder;
    }

    public void toJson(JsonObject json) {
        if (this.group != null) {
            json.addProperty("group", this.group);
        }
        if (!this.shape.isEmpty()) {
            JsonArray pattern = new JsonArray();
            Iterator iterator = this.shape.iterator();
            while (iterator.hasNext()) {
                String[] strings;
                for (String string : strings = (String[])iterator.next()) {
                    pattern.add(string);
                }
            }
            json.add("pattern", (JsonElement)pattern);
        }
        if (!this.symbolMap.isEmpty()) {
            JsonObject key = new JsonObject();
            this.symbolMap.forEach((k, v) -> key.add(k.toString(), v.toJson()));
            json.add("key", (JsonElement)key);
        }
        if (this.output.isEmpty()) {
            GTCEu.LOGGER.error("shaped recipe {} output is empty", (Object)this.id);
            throw new IllegalArgumentException(String.valueOf(this.id) + ": output items is empty");
        }
        JsonObject result = new JsonObject();
        result.addProperty("item", BuiltInRegistries.ITEM.getKey((Object)this.output.getItem()).toString());
        if (this.output.getCount() > 1) {
            result.addProperty("count", (Number)this.output.getCount());
        }
        if (this.output.hasTag() && this.output.getTag() != null) {
            result.add("nbt", NBTToJsonConverter.getObject((Tag)this.output.getTag()));
        }
        json.add("result", (JsonElement)result);
    }

    protected ResourceLocation defaultId() {
        return BuiltInRegistries.ITEM.getKey((Object)this.output.getItem());
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        consumer.accept(new FinishedRecipe(){

            public void serializeRecipeData(JsonObject pJson) {
                ShapedRecipeBuilder.this.toJson(pJson);
            }

            public ResourceLocation getId() {
                ResourceLocation ID = ShapedRecipeBuilder.this.id == null ? ShapedRecipeBuilder.this.defaultId() : ShapedRecipeBuilder.this.id;
                return new ResourceLocation(ID.getNamespace(), "shaped/" + ID.getPath());
            }

            public RecipeSerializer<?> getType() {
                return ShapedRecipeBuilder.this.isStrict ? StrictShapedRecipe.SERIALIZER : RecipeSerializer.SHAPED_RECIPE;
            }

            @Nullable
            public JsonObject serializeAdvancement() {
                return null;
            }

            @Nullable
            public ResourceLocation getAdvancementId() {
                return null;
            }
        });
    }
}

