/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.misc;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.cover.filter.ItemFilter;
import com.gregtechceu.gtceu.api.cover.filter.SimpleItemFilter;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.recipe.ToolHeadReplaceRecipe;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.item.ItemMagnetBehavior;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.gregtechceu.gtceu.data.recipe.generated.ToolRecipeHandler;
import com.gregtechceu.gtceu.utils.ToolItemHelper;
import com.tterrag.registrate.util.entry.ItemEntry;
import it.unimi.dsi.fastutil.ints.Int2ReferenceArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public final class CustomToolRecipes {
    private static final Int2ReferenceMap<ItemEntry<? extends Item>> motorItems = new Int2ReferenceArrayMap();
    private static final Int2ReferenceMap<Material> baseMaterials = new Int2ReferenceArrayMap();
    private static final Int2ReferenceMap<List<ItemEntry<? extends Item>>> batteryItems = new Int2ReferenceArrayMap();

    private CustomToolRecipes() {
    }

    public static void init(@NotNull Consumer<FinishedRecipe> provider) {
        CustomToolRecipes.initializeGTItems();
        CustomToolRecipes.registerPowerUnitRecipes(provider);
        CustomToolRecipes.registerCustomToolRecipes(provider);
    }

    private static void initializeGTItems() {
        motorItems.put(1, GTItems.ELECTRIC_MOTOR_LV);
        motorItems.put(2, GTItems.ELECTRIC_MOTOR_MV);
        motorItems.put(3, GTItems.ELECTRIC_MOTOR_HV);
        motorItems.put(4, GTItems.ELECTRIC_MOTOR_EV);
        motorItems.put(5, GTItems.ELECTRIC_MOTOR_IV);
        baseMaterials.put(1, (Object)GTMaterials.Steel);
        baseMaterials.put(2, (Object)GTMaterials.Aluminium);
        baseMaterials.put(3, (Object)GTMaterials.StainlessSteel);
        baseMaterials.put(4, (Object)GTMaterials.Titanium);
        baseMaterials.put(5, (Object)GTMaterials.TungstenSteel);
        batteryItems.put(0, List.of(GTItems.BATTERY_ULV_TANTALUM));
        batteryItems.put(1, List.of(GTItems.BATTERY_LV_LITHIUM, GTItems.BATTERY_LV_CADMIUM, GTItems.BATTERY_LV_SODIUM));
        batteryItems.put(2, List.of(GTItems.BATTERY_MV_LITHIUM, GTItems.BATTERY_MV_CADMIUM, GTItems.BATTERY_MV_SODIUM));
        batteryItems.put(3, List.of(GTItems.BATTERY_HV_LITHIUM, GTItems.BATTERY_HV_CADMIUM, GTItems.BATTERY_HV_SODIUM, GTItems.ENERGIUM_CRYSTAL));
        batteryItems.put(4, List.of(GTItems.BATTERY_EV_VANADIUM, GTItems.LAPOTRON_CRYSTAL));
        batteryItems.put(5, List.of(GTItems.BATTERY_IV_VANADIUM, GTItems.ENERGY_LAPOTRONIC_ORB));
        batteryItems.put(6, List.of(GTItems.BATTERY_LuV_VANADIUM, GTItems.ENERGY_LAPOTRONIC_ORB_CLUSTER));
        batteryItems.put(7, List.of(GTItems.BATTERY_ZPM_NAQUADRIA, GTItems.ENERGY_MODULE));
        batteryItems.put(8, List.of(GTItems.BATTERY_UV_NAQUADRIA, GTItems.ENERGY_CLUSTER));
        ToolHeadReplaceRecipe.setToolHeadForTool(TagPrefix.toolHeadDrill, GTToolType.DRILL_LV);
        ToolHeadReplaceRecipe.setToolHeadForTool(TagPrefix.toolHeadDrill, GTToolType.DRILL_MV);
        ToolHeadReplaceRecipe.setToolHeadForTool(TagPrefix.toolHeadDrill, GTToolType.DRILL_HV);
        ToolHeadReplaceRecipe.setToolHeadForTool(TagPrefix.toolHeadDrill, GTToolType.DRILL_EV);
        ToolHeadReplaceRecipe.setToolHeadForTool(TagPrefix.toolHeadDrill, GTToolType.DRILL_IV);
        ToolHeadReplaceRecipe.setToolHeadForTool(TagPrefix.toolHeadChainsaw, GTToolType.CHAINSAW_LV);
        ToolHeadReplaceRecipe.setToolHeadForTool(TagPrefix.toolHeadWrench, GTToolType.WRENCH_LV);
        ToolHeadReplaceRecipe.setToolHeadForTool(TagPrefix.toolHeadWrench, GTToolType.WRENCH_HV);
        ToolHeadReplaceRecipe.setToolHeadForTool(TagPrefix.toolHeadWrench, GTToolType.WRENCH_IV);
        ToolHeadReplaceRecipe.setToolHeadForTool(TagPrefix.toolHeadBuzzSaw, GTToolType.BUZZSAW);
        ToolHeadReplaceRecipe.setToolHeadForTool(TagPrefix.toolHeadScrewdriver, GTToolType.SCREWDRIVER_LV);
        ToolHeadReplaceRecipe.setToolHeadForTool(TagPrefix.toolHeadWireCutter, GTToolType.WIRE_CUTTER_LV);
        ToolHeadReplaceRecipe.setToolHeadForTool(TagPrefix.toolHeadWireCutter, GTToolType.WIRE_CUTTER_HV);
        ToolHeadReplaceRecipe.setToolHeadForTool(TagPrefix.toolHeadWireCutter, GTToolType.WIRE_CUTTER_IV);
    }

    private static void registerPowerUnitRecipes(@NotNull Consumer<FinishedRecipe> provider) {
        IntIterator intIterator = ToolRecipeHandler.powerUnitItems.keySet().iterator();
        while (intIterator.hasNext()) {
            int tier = (Integer)intIterator.next();
            List tieredBatteryItems = (List)batteryItems.get(tier);
            for (ItemEntry batteryItem : tieredBatteryItems) {
                if (ToolRecipeHandler.powerUnitItems.get(tier) == null) continue;
                ItemStack batteryStack = batteryItem.asStack();
                long maxCharge = GTCapabilityHelper.getElectricItem(batteryStack).getMaxCharge();
                ItemStack powerUnitStack = ToolItemHelper.getMaxChargeOverrideStack((Item)((ItemEntry)ToolRecipeHandler.powerUnitItems.get(tier)).get(), maxCharge);
                String recipeName = String.format("%s_%s", BuiltInRegistries.ITEM.getKey((Object)((Item)((ItemEntry)ToolRecipeHandler.powerUnitItems.get(tier)).get())).getPath(), BuiltInRegistries.ITEM.getKey((Object)((Item)batteryItem.get())).getPath());
                VanillaRecipeHelper.addShapedEnergyTransferRecipe(provider, true, false, true, recipeName, Ingredient.of((ItemStack[])new ItemStack[]{batteryStack}), powerUnitStack, "S d", "GMG", "PBP", Character.valueOf('M'), ((ItemEntry)motorItems.get(tier)).asStack(), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, (Material)baseMaterials.get(tier)), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, (Material)baseMaterials.get(tier)), Character.valueOf('G'), new MaterialEntry(TagPrefix.gearSmall, (Material)baseMaterials.get(tier)), Character.valueOf('B'), batteryStack);
            }
        }
    }

    private static void registerCustomToolRecipes(@NotNull Consumer<FinishedRecipe> provider) {
        CustomToolRecipes.registerFlintToolRecipes(provider);
        CustomToolRecipes.registerMortarRecipes(provider);
        CustomToolRecipes.registerSoftToolRecipes(provider);
        CustomToolRecipes.registerElectricRecipes(provider);
        SpecialRecipeBuilder.special(ToolHeadReplaceRecipe.SERIALIZER).save(provider, "gtceu:crafting/replace_tool_head");
    }

    private static void registerFlintToolRecipes(@NotNull Consumer<FinishedRecipe> provider) {
        MaterialEntry flint = new MaterialEntry(TagPrefix.gem, GTMaterials.Flint);
        ItemStack stick = new ItemStack((ItemLike)Items.STICK);
        ToolRecipeHandler.addToolRecipe(provider, GTMaterials.Flint, GTToolType.MORTAR, false, " I ", "SIS", "SSS", Character.valueOf('I'), flint, Character.valueOf('S'), new ItemStack((ItemLike)Blocks.STONE));
        ToolRecipeHandler.addToolRecipe(provider, GTMaterials.Flint, GTToolType.SWORD, false, "I", "I", "S", Character.valueOf('I'), flint, Character.valueOf('S'), stick);
        ToolRecipeHandler.addToolRecipe(provider, GTMaterials.Flint, GTToolType.PICKAXE, false, "III", " S ", " S ", Character.valueOf('I'), flint, Character.valueOf('S'), stick);
        ToolRecipeHandler.addToolRecipe(provider, GTMaterials.Flint, GTToolType.SHOVEL, false, "I", "S", "S", Character.valueOf('I'), flint, Character.valueOf('S'), stick);
        ToolRecipeHandler.addToolRecipe(provider, GTMaterials.Flint, GTToolType.AXE, true, "II", "IS", " S", Character.valueOf('I'), flint, Character.valueOf('S'), stick);
        ToolRecipeHandler.addToolRecipe(provider, GTMaterials.Flint, GTToolType.HOE, true, "II", " S", " S", Character.valueOf('I'), flint, Character.valueOf('S'), stick);
        ToolRecipeHandler.addToolRecipe(provider, GTMaterials.Flint, GTToolType.KNIFE, false, "I", "S", Character.valueOf('I'), flint, Character.valueOf('S'), stick);
    }

    private static void registerMortarRecipes(@NotNull Consumer<FinishedRecipe> provider) {
        for (Material material : new Material[]{GTMaterials.Bronze, GTMaterials.Iron, GTMaterials.Invar, GTMaterials.Steel, GTMaterials.DamascusSteel, GTMaterials.CobaltBrass, GTMaterials.WroughtIron}) {
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.MORTAR, false, " I ", "SIS", "SSS", Character.valueOf('I'), new MaterialEntry(material.hasProperty(PropertyKey.GEM) ? TagPrefix.gem : TagPrefix.ingot, material), Character.valueOf('S'), new ItemStack((ItemLike)Blocks.STONE));
        }
    }

    private static void registerSoftToolRecipes(@NotNull Consumer<FinishedRecipe> provider) {
        ItemStack stick = new ItemStack((ItemLike)Items.STICK);
        for (int i = 0; i < ToolRecipeHandler.softMaterials.length; ++i) {
            Material material = ToolRecipeHandler.softMaterials[i];
            if (material.hasProperty(PropertyKey.WOOD)) {
                VanillaRecipeHelper.addShapedRecipe(provider, String.format("soft_mallet_%s", material.getName()), ToolHelper.get(GTToolType.SOFT_MALLET, material), "II ", "IIS", "II ", Character.valueOf('I'), ItemTags.PLANKS, Character.valueOf('S'), stick);
                continue;
            }
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("soft_mallet_%s", material.getName()), ToolHelper.get(GTToolType.SOFT_MALLET, material), "II ", "IIS", "II ", Character.valueOf('I'), new MaterialEntry(TagPrefix.ingot, material), Character.valueOf('S'), stick);
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("plunger_%s", material.getName()), ToolHelper.getAndSetToolData(GTToolType.PLUNGER, material, 128 * (i << 1), 1, 4.0f, 0.0f), "xPP", " SP", "S f", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, material), Character.valueOf('S'), TagPrefix.rod);
        }
    }

    private static void registerElectricRecipes(@NotNull Consumer<FinishedRecipe> provider) {
        SimpleItemFilter filter;
        CompoundTag tag;
        ItemStack magnetStack;
        for (ItemEntry batteryItem : (List)batteryItems.get(1)) {
            VanillaRecipeHelper.addShapedEnergyTransferRecipe(provider, true, false, true, "prospector_lv_" + batteryItem.getId().getPath(), Ingredient.of((ItemLike[])new ItemLike[]{batteryItem}), GTItems.PROSPECTOR_LV.asStack(), "EPS", "CDC", "PBP", Character.valueOf('E'), GTItems.EMITTER_LV.asStack(), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Steel), Character.valueOf('S'), GTItems.SENSOR_LV.asStack(), Character.valueOf('D'), new MaterialEntry(TagPrefix.plate, GTMaterials.Glass), Character.valueOf('C'), CustomTags.LV_CIRCUITS, Character.valueOf('B'), batteryItem.asStack());
            magnetStack = GTItems.ITEM_MAGNET_LV.asStack();
            tag = magnetStack.getOrCreateTag();
            filter = (SimpleItemFilter)ItemFilter.loadFilter(ItemMagnetBehavior.Filter.SIMPLE.getFilter(magnetStack));
            filter.setBlackList(true);
            tag.put("MagnetFilter", (Tag)filter.saveFilter());
            VanillaRecipeHelper.addShapedEnergyTransferRecipe(provider, true, false, true, "lv_magnet_" + batteryItem.getId().getPath(), Ingredient.of((ItemLike[])new ItemLike[]{batteryItem}), magnetStack, "MwM", "MBM", "CPC", Character.valueOf('M'), new MaterialEntry(TagPrefix.rod, GTMaterials.SteelMagnetic), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Steel), Character.valueOf('C'), new MaterialEntry(TagPrefix.cableGtSingle, GTMaterials.Tin), Character.valueOf('B'), batteryItem.asStack());
        }
        for (ItemEntry batteryItem : (List)batteryItems.get(2)) {
            VanillaRecipeHelper.addShapedEnergyTransferRecipe(provider, true, false, true, "portable_scanner_" + batteryItem.getId().getPath(), Ingredient.of((ItemLike[])new ItemLike[]{batteryItem}), GTItems.PORTABLE_SCANNER.asStack(), "EPS", "CDC", "PBP", Character.valueOf('E'), GTItems.EMITTER_MV.asStack(), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.Aluminium), Character.valueOf('S'), GTItems.SENSOR_MV.asStack(), Character.valueOf('D'), GTItems.COVER_SCREEN.asStack(), Character.valueOf('C'), CustomTags.MV_CIRCUITS, Character.valueOf('B'), batteryItem.asStack());
        }
        for (ItemEntry batteryItem : (List)batteryItems.get(3)) {
            VanillaRecipeHelper.addShapedEnergyTransferRecipe(provider, true, false, true, "prospector_hv_" + batteryItem.getId().getPath(), Ingredient.of((ItemLike[])new ItemLike[]{batteryItem}), GTItems.PROSPECTOR_HV.asStack(), "EPS", "CDC", "PBP", Character.valueOf('E'), GTItems.EMITTER_HV.asStack(), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.StainlessSteel), Character.valueOf('S'), GTItems.SENSOR_HV.asStack(), Character.valueOf('D'), GTItems.COVER_SCREEN.asStack(), Character.valueOf('C'), CustomTags.HV_CIRCUITS, Character.valueOf('B'), batteryItem.asStack());
            magnetStack = GTItems.ITEM_MAGNET_HV.asStack();
            tag = magnetStack.getOrCreateTag();
            filter = (SimpleItemFilter)ItemFilter.loadFilter(ItemMagnetBehavior.Filter.SIMPLE.getFilter(magnetStack));
            filter.setBlackList(true);
            tag.put("MagnetFilter", (Tag)filter.saveFilter());
            VanillaRecipeHelper.addShapedEnergyTransferRecipe(provider, true, false, true, "hv_magnet_" + batteryItem.getId().getPath(), Ingredient.of((ItemLike[])new ItemLike[]{batteryItem}), magnetStack, "MwM", "MBM", "CPC", Character.valueOf('M'), new MaterialEntry(TagPrefix.rod, GTMaterials.NeodymiumMagnetic), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.StainlessSteel), Character.valueOf('C'), new MaterialEntry(TagPrefix.cableGtSingle, GTMaterials.Gold), Character.valueOf('B'), batteryItem.asStack());
        }
        for (ItemEntry batteryItem : (List)batteryItems.get(6)) {
            VanillaRecipeHelper.addShapedEnergyTransferRecipe(provider, true, false, true, "prospector_luv_" + batteryItem.getId().getPath(), Ingredient.of((ItemLike[])new ItemLike[]{batteryItem}), GTItems.PROSPECTOR_LuV.asStack(), "EPS", "CDC", "PBP", Character.valueOf('E'), GTItems.EMITTER_LuV.asStack(), Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, GTMaterials.RhodiumPlatedPalladium), Character.valueOf('S'), GTItems.SENSOR_LuV.asStack(), Character.valueOf('D'), GTItems.COVER_SCREEN.asStack(), Character.valueOf('C'), CustomTags.LuV_CIRCUITS, Character.valueOf('B'), batteryItem.asStack());
        }
    }
}

