/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.misc;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKeys;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class FuelRecipes {
    public static void addBoilerFuel(Consumer<FinishedRecipe> provider, Set<Item> added, Item item, int burnTime) {
        if (added.contains(item) || burnTime <= 0) {
            return;
        }
        added.add(item);
        Optional containedFluid = FluidUtil.getFluidContained((ItemStack)item.getDefaultInstance());
        if (containedFluid.isEmpty()) {
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
            GTRecipeTypes.STEAM_BOILER_RECIPES.recipeBuilder(GTCEu.id(id.getNamespace() + "_" + id.getPath())).inputItems(item).duration(burnTime).save(provider);
        } else {
            FluidStack fluid = new FluidStack((FluidStack)containedFluid.get(), 250);
            ResourceLocation id = BuiltInRegistries.FLUID.getKey((Object)fluid.getFluid());
            GTRecipeTypes.STEAM_BOILER_RECIPES.recipeBuilder(id.getNamespace() + "_" + id.getPath()).inputFluids(fluid).duration(burnTime / 3).save(provider);
        }
    }

    public static void init(Consumer<FinishedRecipe> provider) {
        HashSet<Item> addedItems = new HashSet<Item>();
        for (Item item : BuiltInRegistries.ITEM) {
            int burnTime = GTUtil.getItemBurnTime(item);
            FuelRecipes.addBoilerFuel(provider, addedItems, item, burnTime);
        }
        GTRecipeTypes.STEAM_BOILER_RECIPES.recipeBuilder("minecraft_lava").inputFluids(new FluidStack((Fluid)Fluids.LAVA, 100)).duration(900).save(provider);
        GTRecipeTypes.STEAM_BOILER_RECIPES.recipeBuilder("gtceu_creosote").inputFluids(GTMaterials.Creosote.getFluid(250)).duration(350).save(provider);
        GTRecipeTypes.LARGE_BOILER_RECIPES.recipeBuilder("gtceu_creosote").inputFluids(GTMaterials.Creosote.getFluid(250)).duration(35).save(provider);
        GTRecipeTypes.LARGE_BOILER_RECIPES.recipeBuilder("gtceu_biomass").inputFluids(GTMaterials.Biomass.getFluid(40)).duration(85).save(provider);
        GTRecipeTypes.LARGE_BOILER_RECIPES.recipeBuilder("gtceu_oil").inputFluids(GTMaterials.Oil.getFluid(200)).duration(50).save(provider);
        GTRecipeTypes.LARGE_BOILER_RECIPES.recipeBuilder("gtceu_oil_heavy").inputFluids(GTMaterials.OilHeavy.getFluid(32)).duration(50).save(provider);
        GTRecipeTypes.LARGE_BOILER_RECIPES.recipeBuilder("gtceu_sulfuric_heavy_fuel").inputFluids(GTMaterials.SulfuricHeavyFuel.getFluid(32)).duration(50).save(provider);
        GTRecipeTypes.LARGE_BOILER_RECIPES.recipeBuilder("gtceu_heavy_fuel").inputFluids(GTMaterials.HeavyFuel.getFluid(16)).duration(90).save(provider);
        GTRecipeTypes.LARGE_BOILER_RECIPES.recipeBuilder("gtceu_fish_oil").inputFluids(GTMaterials.FishOil.getFluid(160)).duration(50).save(provider);
        GTRecipeTypes.COMBUSTION_GENERATOR_FUELS.recipeBuilder("naphtha").inputFluids(GTMaterials.Naphtha.getFluid(1)).duration(10).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.COMBUSTION_GENERATOR_FUELS.recipeBuilder("sulfuric_light_fuel").inputFluids(GTMaterials.SulfuricLightFuel.getFluid(4)).duration(5).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.COMBUSTION_GENERATOR_FUELS.recipeBuilder("methanol").inputFluids(GTMaterials.Methanol.getFluid(4)).duration(8).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.COMBUSTION_GENERATOR_FUELS.recipeBuilder("ethanol").inputFluids(GTMaterials.Ethanol.getFluid(1)).duration(6).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.COMBUSTION_GENERATOR_FUELS.recipeBuilder("octane").inputFluids(GTMaterials.Octane.getFluid(2)).duration(5).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.COMBUSTION_GENERATOR_FUELS.recipeBuilder("biodiesel").inputFluids(GTMaterials.BioDiesel.getFluid(1)).duration(8).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.COMBUSTION_GENERATOR_FUELS.recipeBuilder("light_fuel").inputFluids(GTMaterials.LightFuel.getFluid(1)).duration(10).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.COMBUSTION_GENERATOR_FUELS.recipeBuilder("diesel").inputFluids(GTMaterials.Diesel.getFluid(1)).duration(15).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.COMBUSTION_GENERATOR_FUELS.recipeBuilder("cetane_diesel").inputFluids(GTMaterials.CetaneBoostedDiesel.getFluid(2)).duration(45).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.COMBUSTION_GENERATOR_FUELS.recipeBuilder("rocket_fuel").inputFluids(GTMaterials.RocketFuel.getFluid(16)).duration(125).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.COMBUSTION_GENERATOR_FUELS.recipeBuilder("gasoline").inputFluids(GTMaterials.Gasoline.getFluid(1)).duration(50).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.COMBUSTION_GENERATOR_FUELS.recipeBuilder("high_octane_gasoline").inputFluids(GTMaterials.HighOctaneGasoline.getFluid(1)).duration(100).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.COMBUSTION_GENERATOR_FUELS.recipeBuilder("toluene").inputFluids(GTMaterials.Toluene.getFluid(1)).duration(10).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.COMBUSTION_GENERATOR_FUELS.recipeBuilder("light_oil").inputFluids(GTMaterials.OilLight.getFluid(32)).duration(5).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.COMBUSTION_GENERATOR_FUELS.recipeBuilder("raw_oil").inputFluids(GTMaterials.RawOil.getFluid(64)).duration(15).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.STEAM_TURBINE_FUELS.recipeBuilder("steam").inputFluids(GTMaterials.Steam.getFluid(640)).outputFluids(GTMaterials.DistilledWater.getFluid(4)).duration(10).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("natural_gas").inputFluids(GTMaterials.NaturalGas.getFluid(8)).duration(5).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("wood_gas").inputFluids(GTMaterials.WoodGas.getFluid(8)).duration(6).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("sulfuric_gas").inputFluids(GTMaterials.SulfuricGas.getFluid(32)).duration(25).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("sulfuric_naphtha").inputFluids(GTMaterials.SulfuricNaphtha.getFluid(4)).duration(5).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("coal_gas").inputFluids(GTMaterials.CoalGas.getFluid(1)).duration(3).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("methane").inputFluids(GTMaterials.Methane.getFluid(2)).duration(7).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("ethylene").inputFluids(GTMaterials.Ethylene.getFluid(1)).duration(4).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("refinery_gas").inputFluids(GTMaterials.RefineryGas.getFluid(1)).duration(5).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("ethane").inputFluids(GTMaterials.Ethane.getFluid(4)).duration(21).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("propene").inputFluids(GTMaterials.Propene.getFluid(1)).duration(6).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("butadiene").inputFluids(GTMaterials.Butadiene.getFluid(16)).duration(102).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("propane").inputFluids(GTMaterials.Propane.getFluid(4)).duration(29).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("butene").inputFluids(GTMaterials.Butene.getFluid(1)).duration(8).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("phenol").inputFluids(GTMaterials.Phenol.getFluid(1)).duration(9).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("benzene").inputFluids(GTMaterials.Benzene.getFluid(1)).duration(11).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("butane").inputFluids(GTMaterials.Butane.getFluid(4)).duration(37).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("lpg").inputFluids(GTMaterials.LPG.getFluid(1)).duration(10).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.GAS_TURBINE_FUELS.recipeBuilder("nitrobenzene").inputFluids(GTMaterials.Nitrobenzene.getFluid(1)).duration(40).EUt(-GTValues.V[1]).save(provider);
        GTRecipeTypes.PLASMA_GENERATOR_FUELS.recipeBuilder("helium").inputFluids(GTMaterials.Helium.getFluid(FluidStorageKeys.PLASMA, 1)).outputFluids(GTMaterials.Helium.getFluid(1)).duration(40).EUt(-GTValues.V[4]).save(provider);
        GTRecipeTypes.PLASMA_GENERATOR_FUELS.recipeBuilder("oxygen").inputFluids(GTMaterials.Oxygen.getFluid(FluidStorageKeys.PLASMA, 1)).outputFluids(GTMaterials.Oxygen.getFluid(1)).duration(48).EUt(-GTValues.V[4]).save(provider);
        GTRecipeTypes.PLASMA_GENERATOR_FUELS.recipeBuilder("nitrogen").inputFluids(GTMaterials.Nitrogen.getFluid(FluidStorageKeys.PLASMA, 1)).outputFluids(GTMaterials.Nitrogen.getFluid(1)).duration(64).EUt(-GTValues.V[4]).save(provider);
        GTRecipeTypes.PLASMA_GENERATOR_FUELS.recipeBuilder("argon").inputFluids(GTMaterials.Argon.getFluid(FluidStorageKeys.PLASMA, 1)).outputFluids(GTMaterials.Argon.getFluid(1)).duration(96).EUt(-GTValues.V[4]).save(provider);
        GTRecipeTypes.PLASMA_GENERATOR_FUELS.recipeBuilder("iron").inputFluids(GTMaterials.Iron.getFluid(FluidStorageKeys.PLASMA, 1)).outputFluids(GTMaterials.Iron.getFluid(1)).duration(112).EUt(-GTValues.V[4]).save(provider);
        GTRecipeTypes.PLASMA_GENERATOR_FUELS.recipeBuilder("tin").inputFluids(GTMaterials.Tin.getFluid(FluidStorageKeys.PLASMA, 1)).outputFluids(GTMaterials.Tin.getFluid(1)).duration(128).EUt(-GTValues.V[4]).save(provider);
        GTRecipeTypes.PLASMA_GENERATOR_FUELS.recipeBuilder("nickel").inputFluids(GTMaterials.Nickel.getFluid(FluidStorageKeys.PLASMA, 1)).outputFluids(GTMaterials.Nickel.getFluid(1)).duration(192).EUt(-GTValues.V[4]).save(provider);
        GTRecipeTypes.PLASMA_GENERATOR_FUELS.recipeBuilder("americium").inputFluids(GTMaterials.Americium.getFluid(FluidStorageKeys.PLASMA, 1)).outputFluids(GTMaterials.Americium.getFluid(1)).duration(320).EUt(-GTValues.V[4]).save(provider);
    }
}

