/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.misc;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.BlastProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.ItemMaterialInfo;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeCategories;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecyclingRecipes {
    private static final List<TagPrefix> DUST_ORDER = List.of(TagPrefix.dust, TagPrefix.dustSmall, TagPrefix.dustTiny);
    private static final List<TagPrefix> INGOT_ORDER = List.of(TagPrefix.block, TagPrefix.ingot, TagPrefix.nugget);

    public static void init(Consumer<FinishedRecipe> provider) {
        for (Pair<ItemStack, ItemMaterialInfo> entry : ChemicalHelper.getAllItemInfos()) {
            ItemStack itemStack = (ItemStack)entry.getFirst();
            ItemMaterialInfo materialInfo = (ItemMaterialInfo)entry.getSecond();
            ArrayList<MaterialStack> materialStacks = new ArrayList<MaterialStack>(materialInfo.getMaterials());
            RecyclingRecipes.registerRecyclingRecipes(provider, itemStack, materialStacks, false, null);
        }
    }

    public static void registerRecyclingRecipes(Consumer<FinishedRecipe> provider, ItemStack input, List<MaterialStack> components, boolean ignoreArcSmelting, @Nullable TagPrefix prefix) {
        List<MaterialStack> materials = components.stream().filter(stack -> stack.material().hasProperty(PropertyKey.DUST)).filter(stack -> stack.amount() >= 403200L).sorted(Comparator.comparingLong(ms -> -ms.amount())).toList();
        if (materials.isEmpty()) {
            return;
        }
        int voltageMultiplier = RecyclingRecipes.calculateVoltageMultiplier(components);
        if (prefix != TagPrefix.dust && ConfigHolder.INSTANCE.recipes.enableMaceratorRecycling) {
            RecyclingRecipes.registerMaceratorRecycling(provider, input, components, voltageMultiplier);
        }
        if (prefix != null && ConfigHolder.INSTANCE.recipes.enableExtractorRecycling) {
            RecyclingRecipes.registerExtractorRecycling(provider, input, components, voltageMultiplier, prefix);
        }
        if (ignoreArcSmelting) {
            return;
        }
        if (components.size() == 1) {
            Material m = components.get(0).material();
            if (!m.hasProperty(PropertyKey.INGOT)) {
                return;
            }
            if (ChemicalHelper.getPrefix((ItemLike)input.getItem()) == TagPrefix.ingot && m.getProperty(PropertyKey.INGOT).getArcSmeltingInto() == m) {
                return;
            }
            if (prefix == TagPrefix.dust && m.hasFlag(MaterialFlags.IS_MAGNETIC)) {
                return;
            }
        }
        if (ConfigHolder.INSTANCE.recipes.enableArcRecycling) {
            RecyclingRecipes.registerArcRecycling(provider, input, components, prefix);
        }
    }

    private static void registerMaceratorRecycling(Consumer<FinishedRecipe> provider, ItemStack input, List<MaterialStack> materials, int multiplier) {
        float maceratorYield = ConfigHolder.INSTANCE.recipes.maceratorRecyclingYield;
        List<ItemStack> outputs = RecyclingRecipes.finalizeOutputs(materials, GTRecipeTypes.MACERATOR_RECIPES.getMaxOutputs(ItemRecipeCapability.CAP), ChemicalHelper::getDust, maceratorYield);
        MaterialEntry entry = ChemicalHelper.getMaterialEntry((ItemLike)input.getItem());
        TagKey<Item> inputTag = null;
        if (!entry.isEmpty() && entry.material().isNull() && entry.tagPrefix().unificationEnabled()) {
            inputTag = ChemicalHelper.getTag(entry.tagPrefix(), entry.material());
        }
        if (outputs.isEmpty()) {
            return;
        }
        ResourceLocation itemPath = BuiltInRegistries.ITEM.getKey((Object)input.getItem());
        GTRecipeBuilder builder = GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_" + itemPath.getPath()).outputItems((ItemStack[])outputs.toArray(ItemStack[]::new)).duration(RecyclingRecipes.calculateDuration(outputs)).EUt(2L * (long)multiplier);
        if (inputTag == null) {
            builder.inputItems(input.copy());
        } else {
            builder.inputItems(inputTag);
        }
        boolean recycle = true;
        if (!entry.isEmpty() && entry.tagPrefix() == TagPrefix.ingot) {
            recycle = false;
        }
        if (recycle) {
            builder.category(GTRecipeCategories.MACERATOR_RECYCLING);
        }
        builder.save(provider);
    }

    private static void registerExtractorRecycling(Consumer<FinishedRecipe> provider, ItemStack input, List<MaterialStack> materials, int multiplier, @Nullable TagPrefix prefix) {
        ItemStack outputStack;
        MaterialEntry entry = ChemicalHelper.getMaterialEntry((ItemLike)input.getItem());
        TagKey<Item> inputTag = null;
        if (!entry.isEmpty() && !entry.material().isNull()) {
            inputTag = ChemicalHelper.getTag(entry.tagPrefix(), entry.material());
        }
        if (prefix != null && prefix.secondaryMaterials().isEmpty()) {
            MaterialStack ms2 = ChemicalHelper.getMaterialStack(input);
            if (ms2.isEmpty() || ms2.material().isNull()) {
                return;
            }
            Material m = ms2.material();
            if (m.hasProperty(PropertyKey.INGOT) && m.getProperty(PropertyKey.INGOT).getMacerateInto() != m) {
                m = m.getProperty(PropertyKey.INGOT).getMacerateInto();
            }
            if (!m.hasProperty(PropertyKey.FLUID) || m.getFluid() == null) {
                return;
            }
            if (prefix == TagPrefix.dust && m.hasProperty(PropertyKey.BLAST)) {
                return;
            }
            float yield = ConfigHolder.INSTANCE.recipes.extractorRecyclingYield;
            ResourceLocation itemPath = BuiltInRegistries.ITEM.getKey((Object)input.getItem());
            GTRecipeBuilder builder = GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("extract_" + itemPath.getPath()).outputFluids(m.getFluid((int)((float)ms2.amount() * yield * 144.0f / 3628800.0f))).duration((int)Math.max(1L, ms2.amount() * ms2.material().getMass() / 3628800L)).EUt((long)GTValues.VA[1] * (long)multiplier).category(GTRecipeCategories.EXTRACTOR_RECYCLING);
            if (inputTag == null) {
                builder.inputItems(input.copy());
            } else {
                builder.inputItems(inputTag);
            }
            builder.save(provider);
            return;
        }
        MaterialStack fluidMs = materials.stream().filter(ms -> ms.material().hasProperty(PropertyKey.FLUID) && ms.material().getFluid() != null).findFirst().orElse(null);
        if (fluidMs == null) {
            return;
        }
        MaterialStack itemMs = materials.stream().filter(ms -> !ms.material().equals(fluidMs.material())).findFirst().orElse(null);
        long duration = fluidMs.amount() * fluidMs.material().getMass();
        if (itemMs != null) {
            duration += itemMs.amount() * itemMs.material().getMass();
        }
        duration = Math.max(1L, duration / 3628800L);
        ResourceLocation itemPath = BuiltInRegistries.ITEM.getKey((Object)input.getItem());
        GTRecipeBuilder extractorBuilder = GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("extract_" + itemPath.getPath()).outputFluids(fluidMs.material().getFluid((int)(fluidMs.amount() * 144L / 3628800L))).duration((int)duration).EUt((long)GTValues.VA[1] * (long)multiplier).category(GTRecipeCategories.EXTRACTOR_RECYCLING);
        if (inputTag == null) {
            extractorBuilder.inputItems(input.copy());
        } else {
            extractorBuilder.inputItems(inputTag);
        }
        if (itemMs != null && !(outputStack = ChemicalHelper.getIngotOrDust(itemMs)).isEmpty()) {
            extractorBuilder.outputItems(outputStack);
        }
        extractorBuilder.save(provider);
    }

    private static void registerArcRecycling(Consumer<FinishedRecipe> provider, ItemStack input, List<MaterialStack> materials, @Nullable TagPrefix prefix) {
        MaterialEntry entry = ChemicalHelper.getMaterialEntry((ItemLike)input.getItem());
        TagKey<Item> inputTag = null;
        if (!entry.isEmpty() && !entry.material().isNull()) {
            inputTag = ChemicalHelper.getTag(entry.tagPrefix(), entry.material());
        }
        MaterialStack ms = ChemicalHelper.getMaterialStack(input);
        if (prefix == TagPrefix.dust && !ms.isEmpty() && ms.material().hasProperty(PropertyKey.BLAST)) {
            return;
        }
        if (prefix == TagPrefix.block) {
            if (!ms.isEmpty() && !ms.material().hasProperty(PropertyKey.GEM)) {
                ItemStack output = ChemicalHelper.get(TagPrefix.ingot, ms.material().getProperty(PropertyKey.INGOT).getArcSmeltingInto(), (int)(TagPrefix.block.getMaterialAmount(ms.material()) / 3628800L));
                ResourceLocation itemPath = BuiltInRegistries.ITEM.getKey((Object)input.getItem());
                GTRecipeBuilder builder = GTRecipeTypes.ARC_FURNACE_RECIPES.recipeBuilder("arc_" + itemPath.getPath()).outputItems(output).duration(RecyclingRecipes.calculateDuration(Collections.singletonList(output))).EUt(GTValues.VA[1]);
                if (inputTag == null) {
                    builder.inputItems(input.copy());
                } else {
                    builder.inputItems(inputTag);
                }
                if (ms.material().hasFlag(MaterialFlags.IS_MAGNETIC) || ms.material() == ms.material().getProperty(PropertyKey.INGOT).getArcSmeltingInto()) {
                    builder.category(GTRecipeCategories.ARC_FURNACE_RECYCLING);
                }
                builder.save(provider);
            }
            return;
        }
        materials = RecyclingRecipes.combineStacks(materials.stream().map(RecyclingRecipes::getArcSmeltingResult).filter(Objects::nonNull).collect(Collectors.toList()));
        float arcYield = ConfigHolder.INSTANCE.recipes.arcRecyclingYield;
        List<ItemStack> outputs = RecyclingRecipes.finalizeOutputs(materials, GTRecipeTypes.ARC_FURNACE_RECIPES.getMaxOutputs(ItemRecipeCapability.CAP), RecyclingRecipes::getArcIngotOrDust, arcYield);
        if (outputs.isEmpty()) {
            return;
        }
        ResourceLocation itemPath = BuiltInRegistries.ITEM.getKey((Object)input.getItem());
        GTRecipeBuilder builder = GTRecipeTypes.ARC_FURNACE_RECIPES.recipeBuilder("arc_" + itemPath.getPath()).outputItems((ItemStack[])outputs.toArray(ItemStack[]::new)).duration(RecyclingRecipes.calculateDuration(outputs)).EUt(GTValues.VA[1]);
        if (inputTag == null) {
            builder.inputItems(input.copy());
        } else {
            builder.inputItems(inputTag);
        }
        if (RecyclingRecipes.needsRecyclingCategory(prefix, ms, outputs)) {
            builder.category(GTRecipeCategories.ARC_FURNACE_RECYCLING);
        }
        builder.save(provider);
    }

    private static boolean needsRecyclingCategory(@Nullable TagPrefix prefix, @NotNull MaterialStack inputStack, @NotNull List<ItemStack> outputs) {
        Material mat;
        MaterialEntry entry;
        if (!(prefix != TagPrefix.nugget && prefix != TagPrefix.ingot && prefix != TagPrefix.block || outputs.size() != 1 || (entry = ChemicalHelper.getMaterialEntry((ItemLike)outputs.get(0).getItem())).isEmpty() || (mat = inputStack.material()).hasFlag(MaterialFlags.IS_MAGNETIC) || !mat.hasProperty(PropertyKey.INGOT))) {
            return mat.getProperty(PropertyKey.INGOT).getArcSmeltingInto() != entry.material();
        }
        return true;
    }

    private static MaterialStack getArcSmeltingResult(MaterialStack materialStack) {
        Material arcSmelt;
        Material material = materialStack.material();
        long amount = materialStack.amount();
        if (material.hasFlag(MaterialFlags.EXPLOSIVE)) {
            return new MaterialStack(GTMaterials.Ash, amount / 16L);
        }
        if (material.hasFlag(MaterialFlags.FLAMMABLE)) {
            return new MaterialStack(GTMaterials.Ash, amount / 8L);
        }
        if (material.hasProperty(PropertyKey.GEM)) {
            return RecyclingRecipes.getGemArcSmeltResult(materialStack);
        }
        if (material.hasFlag(MaterialFlags.NO_SMELTING)) {
            return null;
        }
        if (material.hasProperty(PropertyKey.INGOT) && !(arcSmelt = material.getProperty(PropertyKey.INGOT).getArcSmeltingInto()).isNull()) {
            return new MaterialStack(arcSmelt, amount);
        }
        return materialStack;
    }

    private static ItemStack getArcIngotOrDust(@NotNull MaterialStack stack) {
        if (stack.material() == GTMaterials.Carbon) {
            return ChemicalHelper.getDust(stack);
        }
        return ChemicalHelper.getIngotOrDust(stack);
    }

    private static MaterialStack getGemArcSmeltResult(MaterialStack materialStack) {
        Material material = materialStack.material();
        long amount = materialStack.amount();
        if (material.getMaterialComponents().stream().anyMatch(stack -> stack.material() == GTMaterials.Oxygen)) {
            return new MaterialStack(GTMaterials.Ash, amount / 8L);
        }
        if (material.getMaterialComponents().stream().anyMatch(stack -> stack.material() == GTMaterials.Carbon)) {
            return new MaterialStack(GTMaterials.Carbon, amount / 8L);
        }
        return new MaterialStack(GTMaterials.DarkAsh, amount / 8L);
    }

    private static int calculateVoltageMultiplier(List<MaterialStack> materials) {
        int highestTemp = 0;
        for (MaterialStack ms : materials) {
            BlastProperty prop;
            Material m = ms.material();
            if (m.hasProperty(PropertyKey.BLAST)) {
                prop = m.getProperty(PropertyKey.BLAST);
                if (prop.getBlastTemperature() <= highestTemp) continue;
                highestTemp = prop.getBlastTemperature();
                continue;
            }
            if (!m.hasFlag(MaterialFlags.IS_MAGNETIC) || !m.hasProperty(PropertyKey.INGOT) || !m.getProperty(PropertyKey.INGOT).getSmeltingInto().hasProperty(PropertyKey.BLAST) || (prop = m.getProperty(PropertyKey.INGOT).getSmeltingInto().getProperty(PropertyKey.BLAST)).getBlastTemperature() <= highestTemp) continue;
            highestTemp = prop.getBlastTemperature();
        }
        if (highestTemp == 0) {
            return 1;
        }
        if (highestTemp < 2000) {
            return 4;
        }
        return 16;
    }

    private static int calculateDuration(List<ItemStack> materials) {
        long duration = 0L;
        for (ItemStack is : materials) {
            MaterialStack ms = ChemicalHelper.getMaterialStack(is);
            if (ms.isEmpty()) continue;
            duration += ms.amount() * ms.material().getMass() * (long)is.getCount();
        }
        return (int)Math.max(1L, duration / 3628800L);
    }

    private static List<MaterialStack> combineStacks(List<MaterialStack> rawList) {
        Object2LongOpenHashMap materialStacksExploded = new Object2LongOpenHashMap();
        for (MaterialStack ms : rawList) {
            materialStacksExploded.addTo((Object)ms.material(), ms.amount());
        }
        return materialStacksExploded.object2LongEntrySet().stream().map(e -> new MaterialStack((Material)e.getKey(), e.getLongValue())).toList();
    }

    private static List<ItemStack> finalizeOutputs(List<MaterialStack> materials, int maxOutputs, Function<MaterialStack, ItemStack> toItemStackMapper, float yield) {
        ArrayList<Pair<ItemStack, MaterialStack>> outputs = new ArrayList<Pair<ItemStack, MaterialStack>>();
        for (MaterialStack materialStack : materials) {
            MaterialStack materialStack2 = new MaterialStack(materialStack.material().hasFlag(MaterialFlags.IS_MAGNETIC) ? materialStack.material().getProperty(PropertyKey.INGOT).getMacerateInto() : materialStack.material(), materialStack.amount());
            ItemStack itemStack = toItemStackMapper.apply(materialStack2.multiply(yield));
            if (itemStack == ItemStack.EMPTY) continue;
            if (itemStack.getCount() > 64) {
                MaterialEntry entry = ChemicalHelper.getMaterialEntry((ItemLike)itemStack.getItem());
                if (entry.isEmpty()) continue;
                TagPrefix prefix = entry.tagPrefix();
                if (prefix == TagPrefix.block || prefix == TagPrefix.dust) {
                    RecyclingRecipes.splitStacks(outputs, itemStack, entry);
                    continue;
                }
                ArrayList<Pair<ItemStack, MaterialStack>> split = new ArrayList<Pair<ItemStack, MaterialStack>>();
                ArrayList<Pair<ItemStack, MaterialStack>> shrink = new ArrayList<Pair<ItemStack, MaterialStack>>();
                RecyclingRecipes.splitStacks(split, itemStack, entry);
                RecyclingRecipes.shrinkStacks(shrink, itemStack, entry);
                if (((MaterialStack)((Pair)split.get(0)).getSecond()).amount() > ((MaterialStack)((Pair)shrink.get(0)).getSecond()).amount()) {
                    outputs.addAll(split);
                    continue;
                }
                outputs.addAll(shrink);
                continue;
            }
            outputs.add(new Pair((Object)itemStack, (Object)materialStack2));
        }
        outputs.sort(Comparator.comparingLong(e -> -((MaterialStack)e.getSecond()).amount()));
        HashMap<MaterialStack, ItemStack> temp = new HashMap<MaterialStack, ItemStack>();
        for (Pair pair : outputs) {
            boolean isInMap = false;
            for (MaterialStack ms : temp.keySet()) {
                if (ms.material() != ((MaterialStack)pair.getSecond()).material()) continue;
                isInMap = true;
                break;
            }
            if (isInMap) continue;
            temp.put((MaterialStack)pair.getSecond(), (ItemStack)pair.getFirst());
        }
        temp.putAll(outputs.stream().filter(t -> !temp.containsKey(t.getSecond())).collect(Collectors.toMap(Pair::getSecond, Pair::getFirst)));
        List<ItemStack> list = temp.entrySet().stream().filter(e -> RecyclingRecipes.isAshMaterial((MaterialStack)e.getKey())).sorted(Comparator.comparingLong(e -> -((MaterialStack)e.getKey()).amount())).map(Map.Entry::getValue).toList();
        List<ItemStack> list2 = temp.entrySet().stream().sorted(Comparator.comparingLong(e -> -((MaterialStack)e.getKey()).amount())).filter(e -> !RecyclingRecipes.isAshMaterial((MaterialStack)e.getKey())).limit(maxOutputs).map(Map.Entry::getValue).collect(Collectors.toList());
        for (int i = 0; i < list.size() && list2.size() < maxOutputs; ++i) {
            list2.add(list.get(i));
        }
        return list2;
    }

    private static void splitStacks(List<Pair<ItemStack, MaterialStack>> list, ItemStack originalStack, MaterialEntry entry) {
        int amount;
        for (amount = originalStack.getCount(); amount > 64; amount -= 64) {
            list.add((Pair<ItemStack, MaterialStack>)new Pair((Object)originalStack.copyWithCount(64), (Object)new MaterialStack(entry.material(), entry.tagPrefix().getMaterialAmount(entry.material()) * 64L)));
        }
        list.add((Pair<ItemStack, MaterialStack>)new Pair((Object)originalStack.copyWithCount(amount), (Object)new MaterialStack(entry.material(), entry.tagPrefix().getMaterialAmount(entry.material()) * (long)amount)));
    }

    private static void shrinkStacks(List<Pair<ItemStack, MaterialStack>> list, ItemStack originalStack, MaterialEntry entry) {
        long singleStackAmount;
        Material material = entry.material();
        long materialAmount = (long)originalStack.getCount() * entry.tagPrefix().getMaterialAmount(material);
        List<TagPrefix> chosenList = material.hasProperty(PropertyKey.INGOT) ? INGOT_ORDER : DUST_ORDER;
        HashMap<TagPrefix, MaterialStack> tempList = new HashMap<TagPrefix, MaterialStack>();
        for (TagPrefix prefix : chosenList) {
            if (materialAmount / prefix.getMaterialAmount(material) == 0L) continue;
            long newAmount = materialAmount / prefix.getMaterialAmount(material);
            tempList.put(prefix, new MaterialStack(material, newAmount * prefix.getMaterialAmount(material)));
            materialAmount %= prefix.getMaterialAmount(material);
        }
        if (tempList.containsKey(chosenList.get(0))) {
            TagPrefix prefix = chosenList.get(0);
            MaterialStack ms = (MaterialStack)tempList.get(prefix);
            RecyclingRecipes.splitStacks(list, ChemicalHelper.get(chosenList.get(0), ms.material(), (int)(ms.amount() / prefix.getMaterialAmount(material))), new MaterialEntry(prefix, material));
        }
        TagPrefix mediumPrefix = chosenList.get(1);
        TagPrefix smallestPrefix = chosenList.get(2);
        MaterialStack mediumMS = (MaterialStack)tempList.get(mediumPrefix);
        MaterialStack smallestMS = (MaterialStack)tempList.get(smallestPrefix);
        if (mediumMS != null && smallestMS != null && (singleStackAmount = mediumMS.amount() + smallestMS.amount()) / smallestPrefix.getMaterialAmount(material) <= 64L) {
            list.add((Pair<ItemStack, MaterialStack>)new Pair((Object)ChemicalHelper.get(smallestPrefix, material, (int)(singleStackAmount / smallestPrefix.getMaterialAmount(material))), (Object)new MaterialStack(material, singleStackAmount)));
            return;
        }
        if (mediumMS != null) {
            list.add((Pair<ItemStack, MaterialStack>)new Pair((Object)ChemicalHelper.get(mediumPrefix, material, (int)(mediumMS.amount() / mediumPrefix.getMaterialAmount(material))), (Object)new MaterialStack(material, mediumMS.amount())));
        }
        if (smallestMS != null) {
            list.add((Pair<ItemStack, MaterialStack>)new Pair((Object)ChemicalHelper.get(smallestPrefix, material, (int)(smallestMS.amount() / smallestPrefix.getMaterialAmount(material))), (Object)new MaterialStack(material, smallestMS.amount())));
        }
    }

    private static boolean isAshMaterial(MaterialStack ms) {
        return ms.material() == GTMaterials.Ash || ms.material() == GTMaterials.DarkAsh || ms.material() == GTMaterials.Carbon;
    }
}

