/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.misc;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.ItemMaterialData;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.ItemMaterialInfo;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.gregtechceu.gtceu.data.recipe.WoodTypeEntry;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class WoodMachineRecipes {
    private static List<WoodTypeEntry> DEFAULT_ENTRIES;

    public static void init(Consumer<FinishedRecipe> provider) {
        WoodMachineRecipes.registerGTWoodRecipes(provider);
        WoodMachineRecipes.registerWoodRecipes(provider);
        WoodMachineRecipes.registerPyrolyseOvenRecipes(provider);
    }

    private static List<WoodTypeEntry> getDefaultEntries() {
        if (DEFAULT_ENTRIES == null) {
            String mcModId = "minecraft";
            DEFAULT_ENTRIES = Arrays.asList(new WoodTypeEntry.Builder("minecraft", "oak").planks(Items.OAK_PLANKS, "oak_planks").log(Items.OAK_LOG).removeCharcoalRecipe().strippedLog(Items.STRIPPED_OAK_LOG).wood(Items.OAK_WOOD).strippedWood(Items.STRIPPED_OAK_WOOD).door(Items.OAK_DOOR, "oak_door").trapdoor(Items.OAK_TRAPDOOR, "oak_trapdoor").slab(Items.OAK_SLAB, "oak_slab").fence(Items.OAK_FENCE, "oak_fence").fenceGate(Items.OAK_FENCE_GATE, "oak_fence_gate").stairs(Items.OAK_STAIRS, "oak_stairs").boat(Items.OAK_BOAT, "oak_boat").chestBoat(Items.OAK_CHEST_BOAT, "oak_chest_boat").sign(Items.OAK_SIGN, "oak_sign").hangingSign(Items.OAK_HANGING_SIGN, "oak_hanging_sign").button(Items.OAK_BUTTON, "oak_button").pressurePlate(Items.OAK_PRESSURE_PLATE, "oak_pressure_plate").registerAllMaterialInfo().build(), new WoodTypeEntry.Builder("minecraft", "spruce").planks(Items.SPRUCE_PLANKS, "spruce_planks").log(Items.SPRUCE_LOG).removeCharcoalRecipe().strippedLog(Items.STRIPPED_SPRUCE_LOG).wood(Items.SPRUCE_WOOD).strippedWood(Items.STRIPPED_SPRUCE_WOOD).door(Items.SPRUCE_DOOR, "spruce_door").trapdoor(Items.SPRUCE_TRAPDOOR, "spruce_trapdoor").slab(Items.SPRUCE_SLAB, "spruce_slab").fence(Items.SPRUCE_FENCE, "spruce_fence").fenceGate(Items.SPRUCE_FENCE_GATE, "spruce_fence_gate").stairs(Items.SPRUCE_STAIRS, "spruce_stairs").boat(Items.SPRUCE_BOAT, "spruce_boat").chestBoat(Items.SPRUCE_CHEST_BOAT, "spruce_chest_boat").sign(Items.SPRUCE_SIGN, "spruce_sign").hangingSign(Items.SPRUCE_HANGING_SIGN, "spruce_hanging_sign").button(Items.SPRUCE_BUTTON, "spruce_button").pressurePlate(Items.SPRUCE_PRESSURE_PLATE, "spruce_pressure_plate").registerAllMaterialInfo().build(), new WoodTypeEntry.Builder("minecraft", "birch").planks(Items.BIRCH_PLANKS, "birch_planks").log(Items.BIRCH_LOG).removeCharcoalRecipe().strippedLog(Items.STRIPPED_BIRCH_LOG).wood(Items.BIRCH_WOOD).strippedWood(Items.STRIPPED_BIRCH_WOOD).door(Items.BIRCH_DOOR, "birch_door").trapdoor(Items.BIRCH_TRAPDOOR, "birch_trapdoor").slab(Items.BIRCH_SLAB, "birch_slab").fence(Items.BIRCH_FENCE, "birch_fence").fenceGate(Items.BIRCH_FENCE_GATE, "birch_fence_gate").stairs(Items.BIRCH_STAIRS, "birch_stairs").boat(Items.BIRCH_BOAT, "birch_boat").chestBoat(Items.BIRCH_CHEST_BOAT, "birch_chest_boat").sign(Items.BIRCH_SIGN, "birch_sign").hangingSign(Items.BIRCH_HANGING_SIGN, "birch_hanging_sign").button(Items.BIRCH_BUTTON, "birch_button").pressurePlate(Items.BIRCH_PRESSURE_PLATE, "birch_pressure_plate").registerAllMaterialInfo().build(), new WoodTypeEntry.Builder("minecraft", "jungle").planks(Items.JUNGLE_PLANKS, "jungle_planks").log(Items.JUNGLE_LOG).removeCharcoalRecipe().strippedLog(Items.STRIPPED_JUNGLE_LOG).wood(Items.JUNGLE_WOOD).strippedWood(Items.STRIPPED_JUNGLE_WOOD).door(Items.JUNGLE_DOOR, "jungle_door").trapdoor(Items.JUNGLE_TRAPDOOR, "jungle_trapdoor").slab(Items.JUNGLE_SLAB, "jungle_slab").fence(Items.JUNGLE_FENCE, "jungle_fence").fenceGate(Items.JUNGLE_FENCE_GATE, "jungle_fence_gate").stairs(Items.JUNGLE_STAIRS, "jungle_stairs").boat(Items.JUNGLE_BOAT, "jungle_boat").chestBoat(Items.JUNGLE_CHEST_BOAT, "jungle_chest_boat").sign(Items.JUNGLE_SIGN, "jungle_sign").hangingSign(Items.JUNGLE_HANGING_SIGN, "jungle_hanging_sign").button(Items.JUNGLE_BUTTON, "jungle_button").pressurePlate(Items.JUNGLE_PRESSURE_PLATE, "jungle_pressure_plate").registerAllMaterialInfo().build(), new WoodTypeEntry.Builder("minecraft", "acacia").planks(Items.ACACIA_PLANKS, "acacia_planks").log(Items.ACACIA_LOG).removeCharcoalRecipe().strippedLog(Items.STRIPPED_ACACIA_LOG).wood(Items.ACACIA_WOOD).strippedWood(Items.STRIPPED_ACACIA_WOOD).door(Items.ACACIA_DOOR, "acacia_door").trapdoor(Items.ACACIA_TRAPDOOR, "acacia_trapdoor").slab(Items.ACACIA_SLAB, "acacia_slab").fence(Items.ACACIA_FENCE, "acacia_fence").fenceGate(Items.ACACIA_FENCE_GATE, "acacia_fence_gate").stairs(Items.ACACIA_STAIRS, "acacia_stairs").boat(Items.ACACIA_BOAT, "acacia_boat").chestBoat(Items.ACACIA_CHEST_BOAT, "acacia_chest_boat").sign(Items.ACACIA_SIGN, "acacia_sign").hangingSign(Items.ACACIA_HANGING_SIGN, "acacia_hanging_sign").button(Items.ACACIA_BUTTON, "acacia_button").pressurePlate(Items.ACACIA_PRESSURE_PLATE, "acacia_pressure_plate").registerAllMaterialInfo().build(), new WoodTypeEntry.Builder("minecraft", "dark_oak").planks(Items.DARK_OAK_PLANKS, "dark_oak_planks").log(Items.DARK_OAK_LOG).removeCharcoalRecipe().strippedLog(Items.STRIPPED_DARK_OAK_LOG).wood(Items.DARK_OAK_WOOD).strippedWood(Items.STRIPPED_DARK_OAK_WOOD).door(Items.DARK_OAK_DOOR, "dark_oak_door").trapdoor(Items.DARK_OAK_TRAPDOOR, "dark_oak_trapdoor").slab(Items.DARK_OAK_SLAB, "dark_oak_slab").fence(Items.DARK_OAK_FENCE, "dark_oak_fence").fenceGate(Items.DARK_OAK_FENCE_GATE, "dark_oak_fence_gate").stairs(Items.DARK_OAK_STAIRS, "dark_oak_stairs").boat(Items.DARK_OAK_BOAT, "dark_oak_boat").chestBoat(Items.DARK_OAK_CHEST_BOAT, "dark_oak_chest_boat").sign(Items.DARK_OAK_SIGN, "dark_oak_sign").hangingSign(Items.DARK_OAK_HANGING_SIGN, "dark_oak_hanging_sign").button(Items.DARK_OAK_BUTTON, "dark_oak_button").pressurePlate(Items.DARK_OAK_PRESSURE_PLATE, "dark_oak_pressure_plate").registerAllMaterialInfo().build(), new WoodTypeEntry.Builder("minecraft", "bamboo").planks(Items.BAMBOO_PLANKS, "bamboo_planks").logTag((TagKey<Item>)ItemTags.BAMBOO_BLOCKS).log(Items.BAMBOO_BLOCK).removeCharcoalRecipe().strippedLog(Items.STRIPPED_BAMBOO_BLOCK).door(Items.BAMBOO_DOOR, "bamboo_door").trapdoor(Items.BAMBOO_TRAPDOOR, "bamboo_trapdoor").slab(Items.BAMBOO_SLAB, "bamboo_slab").fence(Items.BAMBOO_FENCE, "bamboo_fence").fenceGate(Items.BAMBOO_FENCE_GATE, "bamboo_fence_gate").stairs(Items.BAMBOO_STAIRS, "bamboo_stairs").boat(Items.BAMBOO_RAFT, "bamboo_raft").chestBoat(Items.BAMBOO_CHEST_RAFT, "bamboo_chest_raft").sign(Items.BAMBOO_SIGN, "bamboo_sign").hangingSign(Items.BAMBOO_HANGING_SIGN, "bamboo_hanging_sign").button(Items.BAMBOO_BUTTON, "bamboo_button").pressurePlate(Items.BAMBOO_PRESSURE_PLATE, "bamboo_pressure_plate").registerAllMaterialInfo().build(), new WoodTypeEntry.Builder("minecraft", "cherry").planks(Items.CHERRY_PLANKS, "cherry_planks").log(Items.CHERRY_LOG).removeCharcoalRecipe().strippedLog(Items.STRIPPED_CHERRY_LOG).wood(Items.CHERRY_WOOD).strippedWood(Items.STRIPPED_CHERRY_WOOD).door(Items.CHERRY_DOOR, "cherry_door").trapdoor(Items.CHERRY_TRAPDOOR, "cherry_trapdoor").slab(Items.CHERRY_SLAB, "cherry_slab").fence(Items.CHERRY_FENCE, "cherry_fence").fenceGate(Items.CHERRY_FENCE_GATE, "cherry_fence_gate").stairs(Items.CHERRY_STAIRS, "cherry_stairs").boat(Items.CHERRY_BOAT, "cherry_boat").chestBoat(Items.CHERRY_CHEST_BOAT, "cherry_chest_boat").sign(Items.CHERRY_SIGN, "cherry_sign").hangingSign(Items.CHERRY_HANGING_SIGN, "cherry_hanging_sign").button(Items.CHERRY_BUTTON, "cherry_button").pressurePlate(Items.CHERRY_PRESSURE_PLATE, "cherry_pressure_plate").registerAllMaterialInfo().build(), new WoodTypeEntry.Builder("minecraft", "mangrove").planks(Items.MANGROVE_PLANKS, "mangrove_planks").log(Items.MANGROVE_LOG).removeCharcoalRecipe().strippedLog(Items.STRIPPED_MANGROVE_LOG).wood(Items.MANGROVE_WOOD).strippedWood(Items.STRIPPED_MANGROVE_WOOD).door(Items.MANGROVE_DOOR, "mangrove_door").trapdoor(Items.MANGROVE_TRAPDOOR, "mangrove_trapdoor").slab(Items.MANGROVE_SLAB, "mangrove_slab").fence(Items.MANGROVE_FENCE, "mangrove_fence").fenceGate(Items.MANGROVE_FENCE_GATE, "mangrove_fence_gate").stairs(Items.MANGROVE_STAIRS, "mangrove_stairs").boat(Items.MANGROVE_BOAT, "mangrove_boat").chestBoat(Items.MANGROVE_CHEST_BOAT, "mangrove_chest_boat").sign(Items.MANGROVE_SIGN, "mangrove_sign").hangingSign(Items.MANGROVE_HANGING_SIGN, "mangrove_hanging_sign").button(Items.MANGROVE_BUTTON, "mangrove_button").pressurePlate(Items.MANGROVE_PRESSURE_PLATE, "mangrove_pressure_plate").registerAllMaterialInfo().build(), new WoodTypeEntry.Builder("minecraft", "crimson").planks(Items.CRIMSON_PLANKS, "crimson_planks").logTag((TagKey<Item>)ItemTags.CRIMSON_STEMS).log(Items.CRIMSON_STEM).removeCharcoalRecipe().strippedLog(Items.STRIPPED_CRIMSON_STEM).wood(Items.CRIMSON_HYPHAE).strippedWood(Items.STRIPPED_CRIMSON_HYPHAE).door(Items.CRIMSON_DOOR, "crimson_door").trapdoor(Items.CRIMSON_TRAPDOOR, "crimson_trapdoor").slab(Items.CRIMSON_SLAB, "crimson_slab").fence(Items.CRIMSON_FENCE, "crimson_fence").fenceGate(Items.CRIMSON_FENCE_GATE, "crimson_fence_gate").stairs(Items.CRIMSON_STAIRS, "crimson_stairs").sign(Items.CRIMSON_SIGN, "crimson_sign").hangingSign(Items.CRIMSON_HANGING_SIGN, "crimson_hanging_sign").button(Items.CRIMSON_BUTTON, "crimson_button").pressurePlate(Items.CRIMSON_PRESSURE_PLATE, "crimson_pressure_plate").registerAllMaterialInfo().build(), new WoodTypeEntry.Builder("minecraft", "warped").planks(Items.WARPED_PLANKS, "warped_planks").logTag((TagKey<Item>)ItemTags.WARPED_STEMS).log(Items.WARPED_STEM).removeCharcoalRecipe().strippedLog(Items.STRIPPED_WARPED_STEM).wood(Items.WARPED_HYPHAE).strippedWood(Items.STRIPPED_WARPED_HYPHAE).door(Items.WARPED_DOOR, "warped_door").trapdoor(Items.WARPED_TRAPDOOR, "warped_trapdoor").slab(Items.WARPED_SLAB, "warped_slab").fence(Items.WARPED_FENCE, "warped_fence").fenceGate(Items.WARPED_FENCE_GATE, "warped_fence_gate").stairs(Items.WARPED_STAIRS, "warped_stairs").sign(Items.WARPED_SIGN, "warped_sign").hangingSign(Items.WARPED_HANGING_SIGN, "warped_hanging_sign").button(Items.WARPED_BUTTON, "warped_button").pressurePlate(Items.WARPED_PRESSURE_PLATE, "warped_pressure_plate").registerAllMaterialInfo().build(), new WoodTypeEntry.Builder("gtceu", "rubber").planks(GTBlocks.RUBBER_PLANK.asItem(), null).log(GTBlocks.RUBBER_LOG.asItem()).addCharcoalRecipe().strippedLog(GTBlocks.STRIPPED_RUBBER_LOG.asItem()).wood(GTBlocks.RUBBER_WOOD.asItem()).strippedWood(GTBlocks.STRIPPED_RUBBER_WOOD.asItem()).door(GTBlocks.RUBBER_DOOR.asItem(), null).trapdoor(GTBlocks.RUBBER_TRAPDOOR.asItem(), null).slab(GTBlocks.RUBBER_SLAB.asItem(), null).addSlabRecipe().fence(GTBlocks.RUBBER_FENCE.asItem(), null).fenceGate(GTBlocks.RUBBER_FENCE_GATE.asItem(), null).stairs(GTBlocks.RUBBER_STAIRS.asItem(), null).addStairsRecipe().boat(GTItems.RUBBER_BOAT.asItem(), null).chestBoat(GTItems.RUBBER_CHEST_BOAT.asItem(), null).sign(GTBlocks.RUBBER_SIGN.asItem(), null).hangingSign(GTBlocks.RUBBER_HANGING_SIGN.asItem(), null).button(GTBlocks.RUBBER_BUTTON.asItem(), null).pressurePlate(GTBlocks.RUBBER_PRESSURE_PLATE.asItem(), null).registerAllTags().registerAllMaterialInfo().build(), new WoodTypeEntry.Builder("gtceu", "treated").planks(GTBlocks.TREATED_WOOD_PLANK.asItem(), null).door(GTBlocks.TREATED_WOOD_DOOR.asItem(), null).trapdoor(GTBlocks.TREATED_WOOD_TRAPDOOR.asItem(), null).slab(GTBlocks.TREATED_WOOD_SLAB.asItem(), null).addSlabRecipe().fence(GTBlocks.TREATED_WOOD_FENCE.asItem(), null).fenceGate(GTBlocks.TREATED_WOOD_FENCE_GATE.asItem(), null).stairs(GTBlocks.TREATED_WOOD_STAIRS.asItem(), null).addStairsRecipe().boat(GTItems.TREATED_WOOD_BOAT.asItem(), null).chestBoat(GTItems.TREATED_WOOD_CHEST_BOAT.asItem(), null).sign(GTBlocks.TREATED_WOOD_SIGN.asItem(), null).hangingSign(GTBlocks.TREATED_WOOD_HANGING_SIGN.asItem(), null).button(GTBlocks.TREATED_WOOD_BUTTON.asItem(), null).pressurePlate(GTBlocks.TREATED_WOOD_PRESSURE_PLATE.asItem(), null).material(GTMaterials.TreatedWood).generateLogToPlankRecipe(false).registerMaterialInfo(false, true, true, true, true, true, true, true, true, true).build());
            return DEFAULT_ENTRIES;
        }
        return DEFAULT_ENTRIES;
    }

    public static void registerMaterialInfo() {
        for (WoodTypeEntry entry : WoodMachineRecipes.getDefaultEntries()) {
            WoodMachineRecipes.registerWoodMaterialInfo(entry);
        }
    }

    private static void registerWoodRecipes(Consumer<FinishedRecipe> provider) {
        if (ConfigHolder.INSTANCE.recipes.nerfWoodCrafting) {
            VanillaRecipeHelper.addShapedRecipe(provider, "stick_saw", new ItemStack((ItemLike)Items.STICK, 4), "s", "P", "P", Character.valueOf('P'), ItemTags.PLANKS);
            VanillaRecipeHelper.addShapedRecipe(provider, "stick_normal", new ItemStack((ItemLike)Items.STICK, 2), "P", "P", Character.valueOf('P'), ItemTags.PLANKS);
        }
        for (WoodTypeEntry entry : WoodMachineRecipes.getDefaultEntries()) {
            WoodMachineRecipes.registerWoodTypeRecipe(provider, entry);
        }
    }

    public static void registerWoodMaterialInfo(@NotNull WoodTypeEntry entry) {
        for (Item log_ : entry.getLogs()) {
            if (log_ == null || !entry.addLogOreDict) continue;
            ItemMaterialData.registerMaterialEntry((ItemLike)log_, TagPrefix.log, entry.material);
        }
        if (entry.addPlanksOreDict) {
            ItemMaterialData.registerMaterialEntry((ItemLike)entry.planks, TagPrefix.planks, entry.material);
        }
        if (entry.addPlanksMaterialInfo) {
            ItemMaterialData.registerMaterialInfo((ItemLike)entry.planks, new ItemMaterialInfo(new MaterialStack(entry.material, 3628800L)));
        }
        if (entry.door != null) {
            if (entry.addDoorsOreDict) {
                ItemMaterialData.registerMaterialEntry((ItemLike)entry.door, TagPrefix.door, entry.material);
            }
            if (entry.addDoorsMaterialInfo) {
                ItemMaterialData.registerMaterialInfo((ItemLike)entry.door, ConfigHolder.INSTANCE.recipes.hardWoodRecipes ? new ItemMaterialInfo(new MaterialStack(entry.material, 7257600L), new MaterialStack(GTMaterials.Iron, 403200L)) : new ItemMaterialInfo(new MaterialStack(entry.material, 7257600L)));
            }
        }
        if (entry.slab != null) {
            if (entry.addSlabsOreDict) {
                ItemMaterialData.registerMaterialEntry((ItemLike)entry.slab, TagPrefix.slab, entry.material);
            }
            if (entry.addSlabsMaterialInfo) {
                ItemMaterialData.registerMaterialInfo((ItemLike)entry.slab, new ItemMaterialInfo(new MaterialStack(entry.material, 1814400L)));
            }
        }
        if (entry.fence != null) {
            if (entry.addFencesOreDict) {
                ItemMaterialData.registerMaterialEntry((ItemLike)entry.fence, TagPrefix.fence, entry.material);
            }
            if (entry.addFencesMaterialInfo) {
                ItemMaterialData.registerMaterialInfo((ItemLike)entry.fence, new ItemMaterialInfo(new MaterialStack(entry.material, 3628800L)));
            }
        }
        if (entry.fenceGate != null) {
            if (entry.addFenceGatesOreDict) {
                ItemMaterialData.registerMaterialEntry((ItemLike)entry.fenceGate, TagPrefix.fenceGate, entry.material);
            }
            if (entry.addFenceGatesMaterialInfo) {
                ItemMaterialData.registerMaterialInfo((ItemLike)entry.fenceGate, new ItemMaterialInfo(new MaterialStack(entry.material, 10886400L)));
            }
        }
        if (entry.stairs != null) {
            if (entry.addStairsOreDict) {
                ItemMaterialData.registerMaterialEntry((ItemLike)entry.stairs, TagPrefix.stairs, entry.material);
            }
            if (entry.addStairsMaterialInfo) {
                ItemMaterialData.registerMaterialInfo((ItemLike)entry.stairs, new ItemMaterialInfo(new MaterialStack(entry.material, 5443200L)));
            }
        }
        if (entry.boat != null && entry.addBoatsMaterialInfo) {
            ItemMaterialData.registerMaterialInfo((ItemLike)entry.boat, new ItemMaterialInfo(new MaterialStack(entry.material, 18144000L)));
        }
        if (entry.chestBoat != null && entry.addChestBoatsMaterialInfo) {
            ItemMaterialData.registerMaterialInfo((ItemLike)entry.chestBoat, new ItemMaterialInfo(new MaterialStack(entry.material, 47174400L)));
        }
        if (entry.button != null && entry.addButtonsMaterialInfo) {
            ItemMaterialData.registerMaterialInfo((ItemLike)entry.button, new ItemMaterialInfo(new MaterialStack(entry.material, 604800L)));
        }
        if (entry.pressurePlate != null && entry.addPressurePlatesMaterialInfo) {
            ItemMaterialData.registerMaterialInfo((ItemLike)entry.pressurePlate, new ItemMaterialInfo(new MaterialStack(entry.material, 3628800L)));
        }
    }

    public static void registerWoodTypeRecipe(Consumer<FinishedRecipe> provider, @NotNull WoodTypeEntry entry) {
        Object recipeName;
        boolean hasPlanksRecipe;
        String name = entry.woodName;
        TagKey<Item> logTag = entry.logTag;
        boolean bl = hasPlanksRecipe = entry.planksRecipeName != null;
        if (entry.planks == null) {
            throw new IllegalStateException("Could not find planks form of WoodTypeEntry '" + name + "'.");
        }
        if (entry.strippedLog != null) {
            GTRecipeTypes.LATHE_RECIPES.recipeBuilder("strip_" + name + "_log").inputItems(entry.log).outputItems(entry.strippedLog).outputItems(TagPrefix.dust, GTMaterials.Wood, 1).duration(160).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.LATHE_RECIPES.recipeBuilder("lathe_stripped_" + name + "_log").inputItems(entry.strippedLog).outputItems(TagPrefix.rodLong, GTMaterials.Wood, 4).outputItems(TagPrefix.dust, GTMaterials.Wood, 1).duration(160).EUt(GTValues.VA[0]).save(provider);
        }
        if (entry.strippedWood != null) {
            GTRecipeTypes.LATHE_RECIPES.recipeBuilder("strip_" + name + "_wood").inputItems(entry.wood).outputItems(entry.strippedWood).outputItems(TagPrefix.dust, GTMaterials.Wood, 1).duration(160).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.LATHE_RECIPES.recipeBuilder("lathe_stripped_" + name + "_wood").inputItems(entry.strippedWood).outputItems(TagPrefix.rodLong, GTMaterials.Wood, 4).outputItems(TagPrefix.dust, GTMaterials.Wood, 1).duration(160).EUt(GTValues.VA[0]).save(provider);
        }
        if (entry.generateLogToPlankRecipe) {
            if (ConfigHolder.INSTANCE.recipes.nerfWoodCrafting) {
                VanillaRecipeHelper.addShapelessRecipe(provider, (String)(hasPlanksRecipe ? entry.planksRecipeName : name + "_planks"), new ItemStack((ItemLike)entry.planks, 2), logTag);
            } else if (!hasPlanksRecipe) {
                VanillaRecipeHelper.addShapelessRecipe(provider, name + "_planks", new ItemStack((ItemLike)entry.planks, 4), logTag);
            }
            VanillaRecipeHelper.addShapedRecipe(provider, name + "_planks_saw", new ItemStack((ItemLike)entry.planks, ConfigHolder.INSTANCE.recipes.nerfWoodCrafting ? 4 : 6), "s", "L", Character.valueOf('L'), logTag);
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder(name + "_planks").inputItems(logTag).outputItems(new ItemStack((ItemLike)entry.planks, 6)).outputItems(TagPrefix.dust, GTMaterials.Wood, 2).duration(200).EUt(GTValues.VA[0]).save(provider);
        }
        ItemMaterialData.registerMaterialInfo((ItemLike)entry.planks, new ItemMaterialInfo(new MaterialStack(GTMaterials.Wood, 3628800L)));
        if (entry.door != null) {
            boolean hasDoorRecipe;
            boolean bl2 = hasDoorRecipe = entry.doorRecipeName != null;
            if (ConfigHolder.INSTANCE.recipes.hardWoodRecipes) {
                Object object = recipeName = hasDoorRecipe ? entry.doorRecipeName : name + "_door";
                if (entry.trapdoor != null) {
                    VanillaRecipeHelper.addShapedRecipe(provider, (String)recipeName, new ItemStack((ItemLike)entry.door), "PTd", "PRS", "PPs", Character.valueOf('P'), entry.planks, Character.valueOf('T'), entry.trapdoor, Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron));
                    GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(name + "_door").inputItems(entry.trapdoor).inputItems(new ItemStack((ItemLike)entry.planks, 4)).inputFluids(GTMaterials.Iron.getFluid(16)).outputItems(entry.door).duration(400).EUt(4L).addMaterialInfo(true, true).save(provider);
                } else {
                    VanillaRecipeHelper.addShapedRecipe(provider, (String)recipeName, new ItemStack((ItemLike)entry.door), "PTd", "PRS", "PPs", Character.valueOf('P'), entry.planks, Character.valueOf('T'), ItemTags.WOODEN_TRAPDOORS, Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron));
                    GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(name + "_door").inputItems((TagKey<Item>)ItemTags.WOODEN_TRAPDOORS).inputItems(new ItemStack((ItemLike)entry.planks, 4)).inputFluids(GTMaterials.Iron.getFluid(16)).outputItems(entry.door).duration(400).EUt(4L).save(provider);
                }
            } else {
                if (!hasDoorRecipe) {
                    VanillaRecipeHelper.addShapedRecipe(provider, name + "_door", new ItemStack((ItemLike)entry.door, 3), "PP", "PP", "PP", Character.valueOf('P'), entry.planks);
                }
                GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(name + "_door").inputItems(new ItemStack((ItemLike)entry.planks, 6)).outputItems(new ItemStack((ItemLike)entry.door, 3)).circuitMeta(6).duration(600).EUt(4L).addMaterialInfo(true).save(provider);
            }
        }
        if (entry.sign != null && entry.slab != null) {
            boolean hasSignRecipe = entry.signRecipeName != null;
            Object object = recipeName = hasSignRecipe ? entry.signRecipeName : name + "_sign";
            if (ConfigHolder.INSTANCE.recipes.hardWoodRecipes) {
                VanillaRecipeHelper.addShapedRecipe(provider, (String)recipeName + "_iron", new ItemStack((ItemLike)entry.sign), "LLL", "RPR", "sSd", Character.valueOf('P'), entry.planks, Character.valueOf('R'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('L'), entry.slab, Character.valueOf('S'), entry.getStick());
                GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder((String)recipeName + "_iron").circuitMeta(4).inputItems(new ItemStack((ItemLike)entry.slab, 1)).inputItems(entry.getStick(), 1).inputFluids(GTMaterials.Iron.getFluid(16)).outputItems(entry.sign, 3).duration(200).EUt(4L).save(provider);
                VanillaRecipeHelper.addShapedRecipe(provider, (String)recipeName + "_steel", new ItemStack((ItemLike)entry.sign, 2), "LLL", "RPR", "sSd", Character.valueOf('P'), entry.planks, Character.valueOf('R'), new MaterialEntry(TagPrefix.screw, GTMaterials.Steel), Character.valueOf('L'), entry.slab, Character.valueOf('S'), entry.getStick());
                GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder((String)recipeName + "_steel").circuitMeta(4).inputItems(new ItemStack((ItemLike)entry.slab, 1)).inputItems(entry.getStick(), 1).inputFluids(GTMaterials.Steel.getFluid(16)).outputItems(entry.sign, 5).duration(200).EUt(4L).save(provider);
            } else {
                if (!hasSignRecipe) {
                    VanillaRecipeHelper.addShapedRecipe(provider, (String)recipeName + "_stick", new ItemStack((ItemLike)entry.sign, 3), "PPP", "PPP", " S ", Character.valueOf('P'), entry.planks, Character.valueOf('S'), entry.getStick());
                }
                GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(name + "_sign").inputItems((Object)new ItemStack((ItemLike)entry.planks), 6).inputItems(entry.getStick()).outputItems((Object)new ItemStack((ItemLike)entry.sign), 3).circuitMeta(4).duration(100).EUt(4L).save(provider);
            }
            if (entry.hangingSign != null && entry.strippedLog != null) {
                Object recipeNameHanging;
                boolean hasHangingSignRecipe = entry.hangingSignRecipeName != null;
                Object object2 = recipeNameHanging = hasHangingSignRecipe ? entry.hangingSignRecipeName : name + "_hanging_sign";
                if (ConfigHolder.INSTANCE.recipes.hardWoodRecipes) {
                    VanillaRecipeHelper.addShapedRecipe(provider, (String)recipeNameHanging, new ItemStack((ItemLike)entry.hangingSign), "LLL", "C C", "RSR", Character.valueOf('C'), Items.CHAIN, Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('S'), new ItemStack((ItemLike)entry.sign), Character.valueOf('L'), new ItemStack((ItemLike)entry.slab));
                    VanillaRecipeHelper.addShapedRecipe(provider, (String)recipeNameHanging + "_steel", new ItemStack((ItemLike)entry.hangingSign, 2), "LLL", "C C", "RSR", Character.valueOf('C'), Items.CHAIN, Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Steel), Character.valueOf('S'), new ItemStack((ItemLike)entry.sign), Character.valueOf('L'), new ItemStack((ItemLike)entry.slab));
                    GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(name + "_hanging_sign").inputItems(entry.slab, 3).inputItems(entry.sign).inputItems(Items.CHAIN, 2).outputItems(entry.hangingSign).circuitMeta(5).duration(150).EUt(4L).save(provider);
                } else {
                    if (!hasHangingSignRecipe) {
                        VanillaRecipeHelper.addShapedRecipe(provider, (String)recipeNameHanging, new ItemStack((ItemLike)entry.hangingSign, 6), "C C", "LLL", "LLL", Character.valueOf('C'), Items.CHAIN, Character.valueOf('L'), entry.strippedLog);
                    }
                    GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(name + "_hanging_sign").inputItems(entry.strippedLog, 6).inputItems(new ItemStack((ItemLike)Items.CHAIN, 2)).outputItems(entry.hangingSign, 6).circuitMeta(5).duration(100).EUt(4L).save(provider);
                }
            }
        }
        if (entry.trapdoor != null) {
            boolean hasTrapdoorRecipe = entry.trapdoorRecipeName != null;
            Object object = recipeName = hasTrapdoorRecipe ? entry.trapdoorRecipeName : name + "_trapdoor";
            if (ConfigHolder.INSTANCE.recipes.hardWoodRecipes) {
                VanillaRecipeHelper.addShapedRecipe(provider, (String)recipeName + "_iron", new ItemStack((ItemLike)entry.trapdoor), "BPS", "PdP", "SPB", Character.valueOf('P'), entry.planks, Character.valueOf('B'), new MaterialEntry(TagPrefix.bolt, GTMaterials.Iron), Character.valueOf('S'), entry.getStick());
                GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder((String)recipeName + "_iron").circuitMeta(3).inputItems(new ItemStack((ItemLike)entry.planks, 2)).inputFluids(GTMaterials.Iron.getFluid(16)).outputItems(entry.trapdoor).duration(200).EUt(4L).save(provider);
                VanillaRecipeHelper.addShapedRecipe(provider, (String)recipeName + "_steel", new ItemStack((ItemLike)entry.trapdoor, 2), "BPS", "PdP", "SPB", Character.valueOf('P'), entry.planks, Character.valueOf('B'), new MaterialEntry(TagPrefix.bolt, GTMaterials.Steel), Character.valueOf('S'), entry.getStick());
                GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder((String)recipeName + "_steel").circuitMeta(3).inputItems(new ItemStack((ItemLike)entry.planks, 2)).inputFluids(GTMaterials.Steel.getFluid(16)).outputItems(entry.trapdoor, 2).duration(200).EUt(4L).save(provider);
            } else {
                if (!hasTrapdoorRecipe) {
                    VanillaRecipeHelper.addShapedRecipe(provider, (String)recipeName, new ItemStack((ItemLike)entry.trapdoor, 2), "PPP", "PPP", Character.valueOf('P'), entry.planks);
                }
                GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(name + "_trapdoor").circuitMeta(3).inputItems((Object)new ItemStack((ItemLike)entry.planks), 6).outputItems((Object)new ItemStack((ItemLike)entry.trapdoor), 4).duration(100).EUt(4L).save(provider);
            }
        }
        if (entry.stairs != null) {
            boolean hasStairRecipe;
            boolean bl3 = hasStairRecipe = entry.stairsRecipeName != null;
            if (entry.addStairsCraftingRecipe) {
                VanillaRecipeHelper.addShapedRecipe(provider, (String)(hasStairRecipe ? entry.stairsRecipeName : name + "_stairs"), new ItemStack((ItemLike)entry.stairs, 4), "P  ", "PP ", "PPP", Character.valueOf('P'), entry.planks);
            }
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(name + "_stairs").inputItems(new ItemStack((ItemLike)entry.planks, 3)).outputItems(new ItemStack((ItemLike)entry.stairs, 4)).circuitMeta(7).EUt(4L).duration(100).addMaterialInfo(true).save(provider);
        }
        if (entry.slab != null) {
            if (entry.addSlabCraftingRecipe && !ConfigHolder.INSTANCE.recipes.hardWoodRecipes) {
                VanillaRecipeHelper.addShapedRecipe(provider, name + "_slab", new ItemStack((ItemLike)entry.slab, 6), "PPP", Character.valueOf('P'), entry.planks);
            }
            VanillaRecipeHelper.addShapedRecipe(provider, name + "_slab_saw", new ItemStack((ItemLike)entry.slab, 2), "sS", Character.valueOf('S'), entry.planks);
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder(name + "_slab").inputItems(entry.planks).outputItems(new ItemStack((ItemLike)entry.slab, 2)).duration(200).EUt(GTValues.VA[0]).addMaterialInfo(true).save(provider);
        }
        if (entry.fence != null) {
            boolean hasFenceRecipe;
            boolean bl4 = hasFenceRecipe = entry.fenceRecipeName != null;
            if (ConfigHolder.INSTANCE.recipes.hardWoodRecipes) {
                VanillaRecipeHelper.addShapedRecipe(provider, (String)(hasFenceRecipe ? entry.fenceRecipeName : name + "_fence"), new ItemStack((ItemLike)entry.fence), "PSP", "PSP", "PSP", Character.valueOf('P'), entry.planks, Character.valueOf('S'), entry.getStick());
            } else if (!hasFenceRecipe) {
                VanillaRecipeHelper.addShapedRecipe(provider, name + "_fence", new ItemStack((ItemLike)entry.fence, 3), "PSP", "PSP", Character.valueOf('P'), entry.planks, Character.valueOf('S'), entry.getStick());
            }
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(name + "_fence").inputItems(entry.planks).outputItems(entry.fence).circuitMeta(13).duration(100).EUt(4L).addMaterialInfo(true).save(provider);
        }
        if (entry.fenceGate != null) {
            boolean hasFenceGateRecipe;
            boolean bl5 = hasFenceGateRecipe = entry.fenceGateRecipeName != null;
            if (ConfigHolder.INSTANCE.recipes.hardWoodRecipes) {
                VanillaRecipeHelper.addShapedRecipe(provider, (String)(hasFenceGateRecipe ? entry.fenceGateRecipeName : name + "_fence_gate"), new ItemStack((ItemLike)entry.fenceGate), "F F", "SPS", "SPS", Character.valueOf('P'), entry.planks, Character.valueOf('S'), entry.getStick(), Character.valueOf('F'), Items.FLINT);
                VanillaRecipeHelper.addShapedRecipe(provider, name + "_fence_gate_screws", new ItemStack((ItemLike)entry.fenceGate, 2), "IdI", "SPS", "SPS", Character.valueOf('P'), entry.planks, Character.valueOf('S'), entry.getStick(), Character.valueOf('I'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron));
            } else if (!hasFenceGateRecipe) {
                VanillaRecipeHelper.addShapedRecipe(provider, name + "_fence_gate", new ItemStack((ItemLike)entry.fenceGate), "SPS", "SPS", Character.valueOf('P'), entry.planks, Character.valueOf('S'), entry.getStick());
            }
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(name + "_fence_gate").inputItems(new ItemStack((ItemLike)entry.planks, 2)).inputItems((TagKey<Item>)Tags.Items.RODS_WOODEN, 2).outputItems(entry.fenceGate).circuitMeta(2).duration(100).EUt(4L).addMaterialInfo(true).save(provider);
        }
        if (entry.boat != null) {
            boolean hasBoatRecipe;
            boolean bl6 = hasBoatRecipe = entry.boatRecipeName != null;
            if (ConfigHolder.INSTANCE.recipes.hardWoodRecipes) {
                if (entry.slab != null) {
                    VanillaRecipeHelper.addShapedRecipe(provider, (String)(hasBoatRecipe ? entry.boatRecipeName : name + "_boat"), new ItemStack((ItemLike)entry.boat), "PHP", "PkP", "SSS", Character.valueOf('P'), entry.planks, Character.valueOf('S'), entry.slab, Character.valueOf('H'), ItemTags.SHOVELS);
                }
            } else if (!hasBoatRecipe) {
                VanillaRecipeHelper.addShapedRecipe(provider, name + "_boat", new ItemStack((ItemLike)entry.boat), "P P", "PPP", Character.valueOf('P'), entry.planks);
            }
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(name + "_boat").inputItems(new ItemStack((ItemLike)entry.planks, 5)).outputItems(entry.boat).circuitMeta(15).duration(100).EUt(4L).addMaterialInfo(true).save(provider);
            if (entry.chestBoat != null) {
                Object recipeName2;
                boolean hasChestBoatRecipe = entry.chestBoatRecipeName != null;
                Object object = recipeName2 = hasChestBoatRecipe ? entry.chestBoatRecipeName : name + "_chest_boat";
                if (ConfigHolder.INSTANCE.recipes.hardWoodRecipes) {
                    VanillaRecipeHelper.addShapedRecipe(provider, (String)recipeName2, new ItemStack((ItemLike)entry.chestBoat), " B ", "SCS", " w ", Character.valueOf('B'), entry.boat, Character.valueOf('S'), new MaterialEntry(TagPrefix.bolt, GTMaterials.Wood), Character.valueOf('C'), Tags.Items.CHESTS_WOODEN);
                } else {
                    VanillaRecipeHelper.addShapelessRecipe(provider, (String)recipeName2, new ItemStack((ItemLike)entry.chestBoat), entry.boat, Tags.Items.CHESTS_WOODEN);
                }
                GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(name + "_chest_boat").inputItems(new ItemStack((ItemLike)entry.boat)).inputItems((TagKey<Item>)Tags.Items.CHESTS_WOODEN).outputItems(entry.chestBoat).circuitMeta(16).duration(100).EUt(4L).addMaterialInfo(true).save(provider);
            }
        }
        if (entry.button != null) {
            boolean hasButtonRecipe;
            boolean bl7 = hasButtonRecipe = entry.buttonRecipeName != null;
            if (ConfigHolder.INSTANCE.recipes.hardWoodRecipes) {
                VanillaRecipeHelper.addShapedRecipe(provider, name + "_button", new ItemStack((ItemLike)entry.button, 6), "sP", Character.valueOf('P'), new ItemStack((ItemLike)entry.pressurePlate));
            } else if (!hasButtonRecipe) {
                VanillaRecipeHelper.addShapedRecipe(provider, name + "_button", new ItemStack((ItemLike)entry.button), "P", Character.valueOf('P'), new ItemStack((ItemLike)entry.planks));
            }
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder(name + "_button").inputItems(new ItemStack((ItemLike)entry.pressurePlate)).outputItems(entry.button, 12).duration(250).EUt(GTValues.VA[0]).save(provider);
            ItemMaterialData.registerMaterialInfo((ItemLike)entry.button, new ItemMaterialInfo(new MaterialStack(entry.material, 403200L)));
        }
        if (entry.pressurePlate != null) {
            boolean hasPressurePlateRecipe;
            boolean bl8 = hasPressurePlateRecipe = entry.pressurePlateRecipeName != null;
            if (ConfigHolder.INSTANCE.recipes.hardWoodRecipes) {
                VanillaRecipeHelper.addShapedRecipe(provider, name + "_pressure_plate", new ItemStack((ItemLike)entry.pressurePlate, 2), "SrS", "LCL", "SdS", Character.valueOf('S'), new MaterialEntry(TagPrefix.bolt, GTMaterials.Wood), Character.valueOf('L'), entry.slab.asItem(), Character.valueOf('C'), new MaterialEntry(TagPrefix.spring, GTMaterials.Iron));
                GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(name + "_pressure_plate").inputItems(new ItemStack((ItemLike)entry.slab, 2)).inputItems(TagPrefix.spring, GTMaterials.Iron).outputItems(entry.pressurePlate).circuitMeta(7).duration(100).EUt(GTValues.VA[0]).save(provider);
            } else {
                if (!hasPressurePlateRecipe) {
                    VanillaRecipeHelper.addShapedRecipe(provider, name + "_pressure_plate", new ItemStack((ItemLike)entry.pressurePlate), "PP", Character.valueOf('P'), new ItemStack((ItemLike)entry.planks));
                }
                GTRecipeTypes.CUTTER_RECIPES.recipeBuilder(name + "_pressure_plate").inputItems(new ItemStack((ItemLike)entry.slab)).outputItems(entry.pressurePlate, 8).duration(250).EUt(GTValues.VA[0]).save(provider);
            }
        }
    }

    private static void registerGTWoodRecipes(Consumer<FinishedRecipe> provider) {
        VanillaRecipeHelper.addShapedRecipe(provider, "treated_wood_stick", ChemicalHelper.get(TagPrefix.rod, GTMaterials.TreatedWood, ConfigHolder.INSTANCE.recipes.nerfWoodCrafting ? 2 : 4), "L", "L", Character.valueOf('L'), GTBlocks.TREATED_WOOD_PLANK.asItem());
        if (ConfigHolder.INSTANCE.recipes.nerfWoodCrafting) {
            VanillaRecipeHelper.addShapedRecipe(provider, "treated_wood_stick_saw", ChemicalHelper.get(TagPrefix.rod, GTMaterials.TreatedWood, 4), "s", "L", "L", Character.valueOf('L'), GTBlocks.TREATED_WOOD_PLANK.asItem());
        }
        VanillaRecipeHelper.addShapedRecipe(provider, "rubber_wood", GTBlocks.RUBBER_WOOD.asStack(3), "LL", "LL", Character.valueOf('L'), GTBlocks.RUBBER_LOG.asStack());
        VanillaRecipeHelper.addShapedRecipe(provider, "stripped_rubber_wood", GTBlocks.STRIPPED_RUBBER_WOOD.asStack(3), "LL", "LL", Character.valueOf('L'), GTBlocks.STRIPPED_RUBBER_LOG.asStack());
    }

    public static void hardWoodRecipes(Consumer<ResourceLocation> registry) {
        if (ConfigHolder.INSTANCE.recipes.nerfWoodCrafting) {
            registry.accept(new ResourceLocation("minecraft:stick"));
        }
        for (WoodTypeEntry entry : WoodMachineRecipes.getDefaultEntries()) {
            WoodMachineRecipes.hardWoodTypeRecipes(registry, entry);
        }
    }

    private static void hardWoodTypeRecipes(Consumer<ResourceLocation> registry, @NotNull WoodTypeEntry entry) {
        if (ConfigHolder.INSTANCE.recipes.nerfWoodCrafting && entry.planksRecipeName != null) {
            registry.accept(new ResourceLocation(entry.modid, entry.planksRecipeName));
        }
        if (ConfigHolder.INSTANCE.recipes.harderCharcoalRecipe && entry.removeCharcoalRecipe) {
            registry.accept(new ResourceLocation("charcoal"));
        }
        if (ConfigHolder.INSTANCE.recipes.hardWoodRecipes) {
            if (entry.door != null && entry.doorRecipeName != null) {
                registry.accept(new ResourceLocation(entry.modid, entry.doorRecipeName));
            }
            if (entry.slab != null) {
                if (ConfigHolder.INSTANCE.recipes.hardWoodRecipes && entry.slabRecipeName != null) {
                    registry.accept(new ResourceLocation(entry.modid, entry.slabRecipeName));
                }
                if (entry.boat != null) {
                    if (entry.boatRecipeName != null) {
                        registry.accept(new ResourceLocation(entry.modid, entry.boatRecipeName));
                    }
                    if (entry.chestBoatRecipeName != null) {
                        registry.accept(new ResourceLocation(entry.modid, entry.chestBoatRecipeName));
                    }
                }
            }
            if (entry.fence != null && entry.fenceRecipeName != null) {
                registry.accept(new ResourceLocation(entry.modid, entry.fenceRecipeName));
            }
            if (entry.fenceGate != null && entry.fenceGateRecipeName != null) {
                registry.accept(new ResourceLocation(entry.modid, entry.fenceGateRecipeName));
            }
            if (entry.trapdoor != null && entry.trapdoorRecipeName != null) {
                registry.accept(new ResourceLocation(entry.modid, entry.trapdoorRecipeName));
            }
            if (entry.chestBoat != null && entry.chestBoatRecipeName != null) {
                registry.accept(new ResourceLocation(entry.modid, entry.chestBoatRecipeName));
            }
            if (entry.sign != null && entry.signRecipeName != null) {
                registry.accept(new ResourceLocation(entry.modid, entry.signRecipeName));
            }
            if (entry.hangingSign != null && entry.hangingSignRecipeName != null) {
                registry.accept(new ResourceLocation(entry.modid, entry.hangingSignRecipeName));
            }
            if (entry.button != null && entry.buttonRecipeName != null) {
                registry.accept(new ResourceLocation(entry.modid, entry.buttonRecipeName));
            }
            if (entry.pressurePlate != null && entry.pressurePlateRecipeName != null) {
                registry.accept(new ResourceLocation(entry.modid, entry.pressurePlateRecipeName));
            }
        }
    }

    private static void registerPyrolyseOvenRecipes(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("log_to_charcoal_byproducts").circuitMeta(4).inputItems((TagKey<Item>)ItemTags.LOGS_THAT_BURN, 16).inputFluids(GTMaterials.Nitrogen.getFluid(1000)).outputItems(Items.CHARCOAL, 20).outputFluids(GTMaterials.CharcoalByproducts.getFluid(4000)).duration(320).EUt(96L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("log_to_wood_tar").circuitMeta(9).inputItems((TagKey<Item>)ItemTags.LOGS_THAT_BURN, 16).outputItems(Items.CHARCOAL, 20).outputFluids(GTMaterials.WoodTar.getFluid(1500)).duration(640).EUt(64L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("log_to_wood_tar_nitrogen").circuitMeta(10).inputItems((TagKey<Item>)ItemTags.LOGS_THAT_BURN, 16).inputFluids(GTMaterials.Nitrogen.getFluid(1000)).outputItems(Items.CHARCOAL, 20).outputFluids(GTMaterials.WoodTar.getFluid(1500)).duration(320).EUt(96L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("log_to_wood_gas").circuitMeta(5).inputItems((TagKey<Item>)ItemTags.LOGS_THAT_BURN, 16).outputItems(Items.CHARCOAL, 20).outputFluids(GTMaterials.WoodGas.getFluid(1500)).duration(640).EUt(64L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("log_to_wood_gas_nitrogen").circuitMeta(6).inputItems((TagKey<Item>)ItemTags.LOGS_THAT_BURN, 16).inputFluids(GTMaterials.Nitrogen.getFluid(1000)).outputItems(Items.CHARCOAL, 20).outputFluids(GTMaterials.WoodGas.getFluid(1500)).duration(320).EUt(96L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("log_to_wood_vinegar").circuitMeta(7).inputItems((TagKey<Item>)ItemTags.LOGS_THAT_BURN, 16).outputItems(Items.CHARCOAL, 20).outputFluids(GTMaterials.WoodVinegar.getFluid(3000)).duration(640).EUt(64L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("log_to_wood_vinegar_nitrogen").circuitMeta(8).inputItems((TagKey<Item>)ItemTags.LOGS_THAT_BURN, 16).inputFluids(GTMaterials.Nitrogen.getFluid(1000)).outputItems(Items.CHARCOAL, 20).outputFluids(GTMaterials.WoodVinegar.getFluid(3000)).duration(320).EUt(96L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("log_to_creosote").circuitMeta(1).inputItems((TagKey<Item>)ItemTags.LOGS_THAT_BURN, 16).outputItems(Items.CHARCOAL, 20).outputFluids(GTMaterials.Creosote.getFluid(4000)).duration(640).EUt(64L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("log_to_creosote_nitrogen").circuitMeta(2).inputItems((TagKey<Item>)ItemTags.LOGS_THAT_BURN, 16).inputFluids(GTMaterials.Nitrogen.getFluid(1000)).outputItems(Items.CHARCOAL, 20).outputFluids(GTMaterials.Creosote.getFluid(4000)).duration(320).EUt(96L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("log_to_heavy_oil").circuitMeta(3).inputItems((TagKey<Item>)ItemTags.LOGS_THAT_BURN, 16).outputItems(TagPrefix.dust, GTMaterials.Ash, 4).outputFluids(GTMaterials.OilHeavy.getFluid(200)).duration(320).EUt(192L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("coal_to_coke_creosote").circuitMeta(1).inputItems(TagPrefix.gem, GTMaterials.Coal, 16).outputItems(TagPrefix.gem, GTMaterials.Coke, 16).outputFluids(GTMaterials.Creosote.getFluid(8000)).duration(640).EUt(64L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("coal_to_coke_creosote_nitrogen").circuitMeta(2).inputItems(TagPrefix.gem, GTMaterials.Coal, 16).inputFluids(GTMaterials.Nitrogen.getFluid(1000)).outputItems(TagPrefix.gem, GTMaterials.Coke, 16).outputFluids(GTMaterials.Creosote.getFluid(8000)).duration(320).EUt(96L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("coal_block_to_coke_creosote").circuitMeta(1).inputItems(TagPrefix.block, GTMaterials.Coal, 8).outputItems(TagPrefix.block, GTMaterials.Coke, 8).outputFluids(GTMaterials.Creosote.getFluid(32000)).duration(2560).EUt(64L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("coal_block_to_coke_creosote_nitrogen").circuitMeta(2).inputItems(TagPrefix.block, GTMaterials.Coal, 8).inputFluids(GTMaterials.Nitrogen.getFluid(1000)).outputItems(TagPrefix.block, GTMaterials.Coke, 8).outputFluids(GTMaterials.Creosote.getFluid(32000)).duration(1280).EUt(96L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("bio_chaff_to_fermented_biomass").EUt(10L).duration(200).inputItems((Supplier<? extends Item>)GTItems.BIO_CHAFF).circuitMeta(2).inputFluids(GTMaterials.Water.getFluid(1500)).outputFluids(GTMaterials.FermentedBiomass.getFluid(1500)).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("bio_chaff_to_biomass").EUt(10L).duration(900).inputItems((Supplier<? extends Item>)GTItems.BIO_CHAFF, 4).circuitMeta(1).inputFluids(GTMaterials.Water.getFluid(4000)).outputFluids(GTMaterials.Biomass.getFluid(5000)).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("sugar_to_charcoal").circuitMeta(1).inputItems(TagPrefix.dust, GTMaterials.Sugar, 23).outputItems(TagPrefix.dust, GTMaterials.Charcoal, 12).outputFluids(GTMaterials.Water.getFluid(1500)).duration(320).EUt(64L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("sugar_to_charcoal_nitrogen").circuitMeta(2).inputItems(TagPrefix.dust, GTMaterials.Sugar, 23).inputFluids(GTMaterials.Nitrogen.getFluid(500)).outputItems(TagPrefix.dust, GTMaterials.Charcoal, 12).outputFluids(GTMaterials.Water.getFluid(1500)).duration(160).EUt(96L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("log_to_coal_gas").circuitMeta(20).inputItems((TagKey<Item>)ItemTags.LOGS_THAT_BURN, 16).inputFluids(GTMaterials.Steam.getFluid(1000)).outputItems(Items.CHARCOAL, 20).outputFluids(GTMaterials.CoalGas.getFluid(2000)).duration(640).EUt(64L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("coal_to_coal_gas").circuitMeta(22).inputItems(TagPrefix.gem, GTMaterials.Coal, 16).inputFluids(GTMaterials.Steam.getFluid(1000)).outputItems(TagPrefix.gem, GTMaterials.Coke, 16).outputFluids(GTMaterials.CoalGas.getFluid(4000)).duration(320).EUt(96L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("coal_block_to_coal_gas").circuitMeta(22).inputItems(TagPrefix.block, GTMaterials.Coal, 8).inputFluids(GTMaterials.Steam.getFluid(4000)).outputItems(TagPrefix.block, GTMaterials.Coke, 8).outputFluids(GTMaterials.CoalGas.getFluid(16000)).duration(1280).EUt(96L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("charcoal_to_coal_tar").circuitMeta(8).inputItems(Items.CHARCOAL, 32).chancedOutput(TagPrefix.dust, GTMaterials.Ash, 5000, 0).outputFluids(GTMaterials.CoalTar.getFluid(1000)).duration(640).EUt(64L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("coal_to_coal_tar").circuitMeta(8).inputItems(Items.COAL, 12).chancedOutput(TagPrefix.dust, GTMaterials.DarkAsh, 5000, 0).outputFluids(GTMaterials.CoalTar.getFluid(3000)).duration(320).EUt(96L).save(provider);
        GTRecipeTypes.PYROLYSE_RECIPES.recipeBuilder("coke_to_coal_tar").circuitMeta(8).inputItems(TagPrefix.gem, GTMaterials.Coke, 8).chancedOutput(TagPrefix.dust, GTMaterials.Ash, 7500, 0).outputFluids(GTMaterials.CoalTar.getFluid(4000)).duration(320).EUt(96L).save(provider);
    }
}

