/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.machine.trait;

import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerGroupDistinctness;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.integration.ae2.machine.MEPatternBufferPartMachine;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public final class InternalSlotRecipeHandler {
    private final List<RecipeHandlerList> slotHandlers;

    public InternalSlotRecipeHandler(MEPatternBufferPartMachine buffer, MEPatternBufferPartMachine.InternalSlot[] slots) {
        this.slotHandlers = new ArrayList<RecipeHandlerList>(slots.length);
        for (int i = 0; i < slots.length; ++i) {
            SlotRHL rhl = new SlotRHL(buffer, slots[i], i);
            this.slotHandlers.add(rhl);
        }
    }

    @Generated
    public List<RecipeHandlerList> getSlotHandlers() {
        return this.slotHandlers;
    }

    protected static class SlotRHL
    extends RecipeHandlerList {
        private final SlotItemRecipeHandler itemRecipeHandler;
        private final SlotFluidRecipeHandler fluidRecipeHandler;

        public SlotRHL(MEPatternBufferPartMachine buffer, MEPatternBufferPartMachine.InternalSlot slot, int idx) {
            super(IO.IN);
            this.itemRecipeHandler = new SlotItemRecipeHandler(buffer, slot, idx);
            this.fluidRecipeHandler = new SlotFluidRecipeHandler(buffer, slot, idx);
            this.addHandlers(buffer.getCircuitInventory(), buffer.getShareInventory(), buffer.getShareTank(), this.itemRecipeHandler, this.fluidRecipeHandler);
            this.setGroup(RecipeHandlerGroupDistinctness.BUS_DISTINCT);
        }

        @Override
        public boolean isDistinct() {
            return true;
        }

        @Override
        public void setDistinct(boolean ignored, boolean notify) {
        }

        @Generated
        public SlotItemRecipeHandler getItemRecipeHandler() {
            return this.itemRecipeHandler;
        }

        @Generated
        public SlotFluidRecipeHandler getFluidRecipeHandler() {
            return this.fluidRecipeHandler;
        }
    }

    private static class SlotFluidRecipeHandler
    extends NotifiableRecipeHandlerTrait<FluidIngredient> {
        private final MEPatternBufferPartMachine.InternalSlot slot;
        private final int priority;
        private final int size = 81;
        private final RecipeCapability<FluidIngredient> capability = FluidRecipeCapability.CAP;
        private final IO handlerIO = IO.IN;
        private final boolean isDistinct = true;

        private SlotFluidRecipeHandler(MEPatternBufferPartMachine buffer, MEPatternBufferPartMachine.InternalSlot slot, int index) {
            super(buffer);
            this.slot = slot;
            this.priority = 0x3FFFFFFF + index + 1;
            slot.setOnContentsChanged(this::notifyListeners);
        }

        @Override
        public List<FluidIngredient> handleRecipeInner(IO io, GTRecipe recipe, List<FluidIngredient> left, boolean simulate) {
            if (io != IO.IN || this.slot.isFluidEmpty()) {
                return left;
            }
            return this.slot.handleFluidInternal(left, simulate);
        }

        @Override
        @NotNull
        public List<Object> getContents() {
            return new ArrayList<FluidStack>(this.slot.getFluids());
        }

        @Override
        public double getTotalContentAmount() {
            return this.slot.getFluids().stream().mapToLong(FluidStack::getAmount).sum();
        }

        @Generated
        public MEPatternBufferPartMachine.InternalSlot getSlot() {
            return this.slot;
        }

        @Override
        @Generated
        public int getPriority() {
            return this.priority;
        }

        @Override
        @Generated
        public int getSize() {
            return this.size;
        }

        @Override
        @Generated
        public RecipeCapability<FluidIngredient> getCapability() {
            return this.capability;
        }

        @Override
        @Generated
        public IO getHandlerIO() {
            return this.handlerIO;
        }

        @Override
        @Generated
        public boolean isDistinct() {
            return this.isDistinct;
        }
    }

    private static class SlotItemRecipeHandler
    extends NotifiableRecipeHandlerTrait<Ingredient> {
        private final MEPatternBufferPartMachine.InternalSlot slot;
        private final int priority;
        private final int size = 81;
        private final RecipeCapability<Ingredient> capability = ItemRecipeCapability.CAP;
        private final IO handlerIO = IO.IN;
        private final boolean isDistinct = true;

        private SlotItemRecipeHandler(MEPatternBufferPartMachine buffer, MEPatternBufferPartMachine.InternalSlot slot, int index) {
            super(buffer);
            this.slot = slot;
            this.priority = 0x3FFFFFFF + index + 1;
            slot.setOnContentsChanged(this::notifyListeners);
        }

        @Override
        public List<Ingredient> handleRecipeInner(IO io, GTRecipe recipe, List<Ingredient> left, boolean simulate) {
            if (io != IO.IN || this.slot.isItemEmpty()) {
                return left;
            }
            return this.slot.handleItemInternal(left, simulate);
        }

        @Override
        @NotNull
        public List<Object> getContents() {
            return new ArrayList<ItemStack>(this.slot.getItems());
        }

        @Override
        public double getTotalContentAmount() {
            return this.slot.getItems().stream().mapToLong(ItemStack::getCount).sum();
        }

        @Generated
        public MEPatternBufferPartMachine.InternalSlot getSlot() {
            return this.slot;
        }

        @Override
        @Generated
        public int getPriority() {
            return this.priority;
        }

        @Override
        @Generated
        public int getSize() {
            return this.size;
        }

        @Override
        @Generated
        public RecipeCapability<Ingredient> getCapability() {
            return this.capability;
        }

        @Override
        @Generated
        public IO getHandlerIO() {
            return this.handlerIO;
        }

        @Override
        @Generated
        public boolean isDistinct() {
            return this.isDistinct;
        }
    }
}

