/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.cctweaked;

import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.placeholder.IPlaceholderInfoProviderCover;
import com.gregtechceu.gtceu.api.placeholder.MultiLineComponent;
import com.gregtechceu.gtceu.api.placeholder.Placeholder;
import com.gregtechceu.gtceu.api.placeholder.PlaceholderContext;
import com.gregtechceu.gtceu.api.placeholder.PlaceholderHandler;
import com.gregtechceu.gtceu.api.placeholder.PlaceholderUtils;
import com.gregtechceu.gtceu.api.placeholder.exceptions.NotSupportedException;
import com.gregtechceu.gtceu.api.placeholder.exceptions.PlaceholderException;
import com.gregtechceu.gtceu.integration.cctweaked.peripherals.CentralMonitorPeripheral;
import com.gregtechceu.gtceu.integration.cctweaked.peripherals.ControllablePeripheral;
import com.gregtechceu.gtceu.integration.cctweaked.peripherals.CoverHolderPeripheral;
import com.gregtechceu.gtceu.integration.cctweaked.peripherals.EnergyInfoPeripheral;
import com.gregtechceu.gtceu.integration.cctweaked.peripherals.TurbineMachinePeripheral;
import com.gregtechceu.gtceu.integration.cctweaked.peripherals.WorkablePeripheral;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.ForgeComputerCraftAPI;
import dan200.computercraft.api.lua.GenericSource;
import java.util.List;

public class CCTweakedPlugin {
    public static void init() {
        ComputerCraftAPI.registerGenericSource((GenericSource)new ControllablePeripheral());
        ComputerCraftAPI.registerGenericSource((GenericSource)new EnergyInfoPeripheral());
        ComputerCraftAPI.registerGenericSource((GenericSource)new TurbineMachinePeripheral());
        ComputerCraftAPI.registerGenericSource((GenericSource)new WorkablePeripheral());
        ComputerCraftAPI.registerGenericSource((GenericSource)new CoverHolderPeripheral());
        ComputerCraftAPI.registerGenericSource((GenericSource)new CentralMonitorPeripheral());
        ForgeComputerCraftAPI.registerGenericCapability(GTCapability.CAPABILITY_CONTROLLABLE);
        ForgeComputerCraftAPI.registerGenericCapability(GTCapability.CAPABILITY_ENERGY_INFO_PROVIDER);
        ForgeComputerCraftAPI.registerGenericCapability(GTCapability.CAPABILITY_TURBINE_MACHINE);
        ForgeComputerCraftAPI.registerGenericCapability(GTCapability.CAPABILITY_WORKABLE);
        ForgeComputerCraftAPI.registerGenericCapability(GTCapability.CAPABILITY_COVERABLE);
        ForgeComputerCraftAPI.registerGenericCapability(GTCapability.CAPABILITY_CENTRAL_MONITOR);
        PlaceholderHandler.addPlaceholder(new Placeholder("bufferText"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                PlaceholderUtils.checkArgs(args, 1);
                CoverBehavior coverBehavior = ctx.cover();
                if (!(coverBehavior instanceof IPlaceholderInfoProviderCover)) {
                    throw new NotSupportedException();
                }
                IPlaceholderInfoProviderCover cover = (IPlaceholderInfoProviderCover)((Object)coverBehavior);
                int i = PlaceholderUtils.toInt(args.get(0));
                PlaceholderUtils.checkRange("line number", 1, 100, i);
                return MultiLineComponent.of(cover.getComputerCraftTextBuffer().get(i - 1));
            }
        });
    }
}

