/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jade.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputFluid;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.StringUtils;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class AutoOutputBlockProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        BlockEntity be = blockAccessor.getBlockEntity();
        if (be != null) {
            CompoundTag tag;
            CompoundTag data = blockAccessor.getServerData().getCompound(this.getUid().toString());
            if (data.contains("autoOutputItem", 10)) {
                tag = data.getCompound("autoOutputItem");
                this.addAutoOutputInfo(iTooltip, blockAccessor, tag, "gtceu.top.item_auto_output");
            }
            if (data.contains("autoOutputFluid", 10)) {
                tag = data.getCompound("autoOutputFluid");
                this.addAutoOutputInfo(iTooltip, blockAccessor, tag, "gtceu.top.fluid_auto_output");
            }
        }
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor blockAccessor) {
        IAutoOutputFluid outputFluid;
        IAutoOutputItem outputItem;
        MetaMachine direction;
        BlockPos pos;
        CompoundTag data = compoundTag.getCompound(this.getUid().toString());
        Level level = blockAccessor.getLevel();
        MetaMachine metaMachine = MetaMachine.getMachine((BlockGetter)level, pos = blockAccessor.getPosition());
        if (metaMachine instanceof IAutoOutputItem && (direction = (outputItem = (IAutoOutputItem)((Object)metaMachine)).getOutputFacingItems()) != null) {
            data.put("autoOutputItem", (Tag)this.writeData(new CompoundTag(), (Direction)direction, blockAccessor, outputItem.isAllowInputFromOutputSideItems(), outputItem.isAutoOutputItems()));
        }
        if ((direction = MetaMachine.getMachine((BlockGetter)level, pos)) instanceof IAutoOutputFluid && (direction = (outputFluid = (IAutoOutputFluid)((Object)direction)).getOutputFacingFluids()) != null) {
            data.put("autoOutputFluid", (Tag)this.writeData(new CompoundTag(), (Direction)direction, blockAccessor, outputFluid.isAllowInputFromOutputSideFluids(), outputFluid.isAutoOutputFluids()));
        }
        compoundTag.put(this.getUid().toString(), (Tag)data);
    }

    public ResourceLocation getUid() {
        return GTCEu.id("auto_output_info");
    }

    private CompoundTag writeData(CompoundTag compoundTag, Direction direction, BlockAccessor blockAccessor, boolean allowInput, boolean auto) {
        compoundTag.putString("direction", direction.getName());
        Level level = blockAccessor.getLevel();
        BlockPos pos = blockAccessor.getPosition().relative(direction);
        if (level != null) {
            ResourceLocation key = BuiltInRegistries.BLOCK.getKey((Object)level.getBlockState(pos).getBlock());
            compoundTag.putString("block", key.toString());
        }
        compoundTag.putBoolean("allowInput", allowInput);
        compoundTag.putBoolean("auto", auto);
        return compoundTag;
    }

    private void addAutoOutputInfo(ITooltip iTooltip, BlockAccessor blockAccessor, CompoundTag compoundTag, String text) {
        Direction direction = Direction.byName((String)compoundTag.getString("direction"));
        boolean allowInput = compoundTag.getBoolean("allowInput");
        boolean auto = compoundTag.getBoolean("auto");
        if (direction != null) {
            ItemStack block;
            iTooltip.add((Component)Component.translatable((String)text, (Object[])new Object[]{StringUtils.capitalize((String)direction.getName())}));
            if (blockAccessor.showDetails() && !(block = ((Block)BuiltInRegistries.BLOCK.get(new ResourceLocation(compoundTag.getString("block")))).asItem().getDefaultInstance()).isEmpty()) {
                iTooltip.append(iTooltip.getElementHelper().smallItem(block));
            }
            if (allowInput || auto) {
                MutableComponent component = Component.literal((String)" (");
                if (auto) {
                    component.append((Component)Component.translatable((String)"gtceu.top.auto_output"));
                }
                if (allowInput && auto) {
                    component.append("/");
                }
                if (allowInput) {
                    component.append((Component)Component.translatable((String)"gtceu.top.allow_output_input"));
                }
                component.append(")");
                iTooltip.append((Component)component);
            }
        }
    }
}

