/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jade.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IEnergyInfoProvider;
import com.gregtechceu.gtceu.integration.jade.provider.CapabilityBlockProvider;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IBoxStyle;
import snownee.jade.api.ui.IElementHelper;

public class ElectricContainerBlockProvider
extends CapabilityBlockProvider<IEnergyInfoProvider> {
    public ElectricContainerBlockProvider() {
        super(GTCEu.id("electric_container_provider"));
    }

    @Override
    @Nullable
    protected IEnergyInfoProvider getCapability(Level level, BlockPos pos, @Nullable Direction side) {
        return GTCapabilityHelper.getEnergyInfoProvider(level, pos, side);
    }

    @Override
    protected void write(CompoundTag data, IEnergyInfoProvider capability) {
        data.putByteArray("Energy", capability.getEnergyInfo().stored().toByteArray());
        data.putByteArray("MaxEnergy", capability.getEnergyInfo().capacity().toByteArray());
    }

    @Override
    protected void addTooltip(CompoundTag capData, ITooltip tooltip, Player player, BlockAccessor block, BlockEntity blockEntity, IPluginConfig config) {
        if (!capData.contains("Energy") && !capData.contains("MaxEnergy")) {
            return;
        }
        BigInteger energy = new BigInteger(capData.getByteArray("Energy"));
        BigInteger maxEnergy = new BigInteger(capData.getByteArray("MaxEnergy"));
        if (maxEnergy.compareTo(BigInteger.ZERO) <= 0) {
            return;
        }
        BigInteger threshold = BigInteger.valueOf(1000000000000L);
        String energyStr = FormattingUtil.formatNumberOrSic(energy, threshold);
        String maxEnergyStr = FormattingUtil.formatNumberOrSic(maxEnergy, threshold);
        float progress = this.getProgress(energy, maxEnergy);
        IElementHelper helper = tooltip.getElementHelper();
        tooltip.add(helper.progress(progress, (Component)Component.translatable((String)"gtceu.jade.energy_stored", (Object[])new Object[]{energyStr, maxEnergyStr}), helper.progressStyle().color(-1120768, -1120768).textColor(-1), (IBoxStyle)Util.make((Object)BoxStyle.DEFAULT, style -> {
            style.borderColor = -11184811;
        }), true));
    }

    @Override
    protected boolean allowDisplaying(IEnergyInfoProvider capability) {
        return !capability.isOneProbeHidden();
    }

    @Override
    protected float getProgress(long progress, long maxProgress) {
        return maxProgress == 0L ? 0.0f : (float)((double)progress / (double)maxProgress);
    }

    protected float getProgress(BigInteger progress, BigInteger maxProgress) {
        if (maxProgress.compareTo(BigInteger.ZERO) <= 0) {
            return 0.0f;
        }
        return new BigDecimal(progress).divide(new BigDecimal(maxProgress), MathContext.DECIMAL32).floatValue();
    }
}

