/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jade.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.client.util.TooltipHelper;
import com.gregtechceu.gtceu.integration.ae2.machine.MEPatternBufferPartMachine;
import com.gregtechceu.gtceu.integration.ae2.machine.MEPatternBufferProxyPartMachine;
import com.gregtechceu.gtceu.integration.jade.provider.MEPatternBufferProvider;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class MEPatternBufferProxyProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        IMachineBlockEntity blockEntity;
        BlockEntity blockEntity2 = blockAccessor.getBlockEntity();
        if (blockEntity2 instanceof IMachineBlockEntity && (blockEntity = (IMachineBlockEntity)blockEntity2).getMetaMachine() instanceof MEPatternBufferProxyPartMachine) {
            CompoundTag serverData = blockAccessor.getServerData();
            if (!serverData.getBoolean("formed")) {
                return;
            }
            if (!serverData.getBoolean("bound")) {
                iTooltip.add((Component)Component.translatable((String)"gtceu.top.buffer_not_bound").withStyle(ChatFormatting.RED));
                return;
            }
            int[] pos = serverData.getIntArray("pos");
            iTooltip.add((Component)Component.translatable((String)"gtceu.top.buffer_bound_pos", (Object[])new Object[]{pos[0], pos[1], pos[2]}).withStyle(TooltipHelper.RAINBOW_HSL_SLOW));
            MEPatternBufferProvider.readBufferTag(iTooltip, serverData);
        }
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor blockAccessor) {
        IMachineBlockEntity blockEntity;
        MetaMachine metaMachine;
        BlockEntity blockEntity2 = blockAccessor.getBlockEntity();
        if (blockEntity2 instanceof IMachineBlockEntity && (metaMachine = (blockEntity = (IMachineBlockEntity)blockEntity2).getMetaMachine()) instanceof MEPatternBufferProxyPartMachine) {
            MEPatternBufferProxyPartMachine proxy = (MEPatternBufferProxyPartMachine)metaMachine;
            if (!proxy.isFormed()) {
                compoundTag.putBoolean("formed", false);
                return;
            }
            compoundTag.putBoolean("formed", true);
            MEPatternBufferPartMachine buffer = proxy.getBuffer();
            if (buffer == null) {
                compoundTag.putBoolean("bound", false);
                return;
            }
            compoundTag.putBoolean("bound", true);
            BlockPos pos = buffer.getPos();
            compoundTag.putIntArray("pos", new int[]{pos.getX(), pos.getY(), pos.getZ()});
            MEPatternBufferProvider.writeBufferTag(compoundTag, buffer);
        }
    }

    public ResourceLocation getUid() {
        return GTCEu.id("me_pattern_buffer_proxy");
    }
}

