/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.map.ftbchunks.veins.fluid;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.gui.misc.ProspectorMode;
import com.gregtechceu.gtceu.integration.map.ftbchunks.FTBChunksOptions;
import com.gregtechceu.gtceu.integration.map.layer.builtin.FluidRenderLayer;
import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.api.client.icon.MapIcon;
import dev.ftb.mods.ftbchunks.api.client.icon.MapType;
import dev.ftb.mods.ftbchunks.client.FTBChunksClientConfig;
import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.client.map.WaypointImpl;
import dev.ftb.mods.ftbchunks.client.map.WaypointType;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;

public class FluidVeinIcon
implements MapIcon {
    public static double MAX_DISTANCE = 256.0;
    private final ChunkPos chunkPos;
    private final ProspectorMode.FluidInfo fluidInfo;
    private int size;
    private Icon icon;

    public FluidVeinIcon(ChunkPos chunkPos, ProspectorMode.FluidInfo fluidInfo) {
        this.chunkPos = chunkPos;
        this.fluidInfo = fluidInfo;
        this.size = 1;
    }

    public boolean isEnabled() {
        return FTBChunksOptions.showLayer("bedrock_fluids") && (this.fluidInfo.left() > 0 || !FTBChunksOptions.hideDepleted());
    }

    public String getName() {
        return FluidRenderLayer.getName(this.fluidInfo).getString();
    }

    public int getColor() {
        int color = IClientFluidTypeExtensions.of((Fluid)this.fluidInfo.fluid()).getTintColor();
        Material material = ChemicalHelper.getMaterial(this.fluidInfo.fluid());
        if (!material.isNull()) {
            color = material.getMaterialARGB();
        }
        return color;
    }

    public double getIconScale(MapType mapType) {
        return mapType.isMinimap() ? (Double)FTBChunksClientConfig.MINIMAP_ZOOM.get() : (double)this.size;
    }

    public boolean isZoomDependant(MapType mapType) {
        return false;
    }

    public boolean isVisible(MapType mapType, double distanceToPlayer, boolean outsideVisibleArea) {
        return !outsideVisibleArea || distanceToPlayer <= MAX_DISTANCE;
    }

    public Vec3 getPos(float v) {
        return this.getMiddleBlock().getCenter();
    }

    public BlockPos getMiddleBlock() {
        return this.chunkPos.getBlockAt(7, 70, 7);
    }

    public boolean onMousePressed(BaseScreen baseScreen, MouseButton mouseButton) {
        if (!this.isEnabled()) {
            return false;
        }
        MapDimension.getCurrent().ifPresent(mapDimension -> FTBChunksAPI.clientApi().getWaypointManager(mapDimension.dimension).ifPresent(waypointManager -> {
            BlockPos pos = this.getMiddleBlock();
            WaypointImpl waypoint = new WaypointImpl(WaypointType.DEFAULT, mapDimension, pos);
            if (!waypointManager.getAllWaypoints().contains(waypoint)) {
                waypointManager.addWaypointAt(pos, this.getName()).setColor(this.getColor()).setHidden(false);
                baseScreen.refreshWidgets();
            }
        }));
        return true;
    }

    public void addTooltip(TooltipList list) {
        FluidRenderLayer.getTooltip(this.fluidInfo).forEach(arg_0 -> ((TooltipList)list).add(arg_0));
    }

    public boolean onKeyPressed(BaseScreen baseScreen, Key key) {
        return false;
    }

    public Icon getIcon(int alpha, boolean mouseOver) {
        int color = this.getColor();
        Icon fluidIcon = Icon.getIcon((ResourceLocation)IClientFluidTypeExtensions.of((Fluid)this.fluidInfo.fluid()).getStillTexture()).withColor(Color4I.rgba((int)color).withAlpha(alpha));
        if (mouseOver) {
            fluidIcon = fluidIcon.withBorder(Color4I.rgba((int)color), false);
        }
        return fluidIcon;
    }

    public void draw(MapType mapType, GuiGraphics graphics, int x, int y, int w, int h, boolean outsideVisibleArea, int iconAlpha) {
        if (!mapType.isMinimap() || !this.isEnabled()) {
            return;
        }
        if (this.icon == null) {
            this.icon = this.getIcon(200, false);
        }
        this.icon.draw(graphics, x, y, w, h);
    }

    @Generated
    public ChunkPos getChunkPos() {
        return this.chunkPos;
    }

    @Generated
    public ProspectorMode.FluidInfo getFluidInfo() {
        return this.fluidInfo;
    }

    @Generated
    public void setSize(int size) {
        this.size = size;
    }
}

