/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.top.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IExhaustVentMachine;
import com.gregtechceu.gtceu.integration.top.provider.CapabilityInfoProvider;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.styles.ItemStyle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class ExhaustVentInfoProvider
extends CapabilityInfoProvider<IExhaustVentMachine> {
    @Override
    @Nullable
    protected IExhaustVentMachine getCapability(Level level, BlockPos blockPos, @Nullable Direction direction) {
        MetaMachine metaMachine = MetaMachine.getMachine((BlockGetter)level, blockPos);
        if (metaMachine instanceof IExhaustVentMachine) {
            IExhaustVentMachine exhaustVentMachine = (IExhaustVentMachine)((Object)metaMachine);
            return exhaustVentMachine;
        }
        return null;
    }

    @Override
    protected boolean allowDisplaying(IExhaustVentMachine capability) {
        return super.allowDisplaying(capability);
    }

    @Override
    protected void addProbeInfo(IExhaustVentMachine iExhaustVentMachine, IProbeInfo iProbeInfo, Player player, BlockEntity blockEntity, IProbeHitData iProbeHitData) {
        IProbeInfo horizontalPane = iProbeInfo.horizontal(iProbeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
        Direction direction = iExhaustVentMachine.getVentingDirection();
        horizontalPane.text(CompoundText.create().info((Component)Component.translatable((String)"gtceu.top.exhaust_vent_direction", (Object[])new Object[]{StringUtils.capitalize((String)direction.getName()) + " "})));
        if (!iExhaustVentMachine.isVentingBlocked()) {
            return;
        }
        if (player.isShiftKeyDown()) {
            Level level = blockEntity.getLevel();
            BlockPos pos = blockEntity.getBlockPos().relative(direction);
            if (level != null) {
                ItemStack block = level.getBlockState(pos).getBlock().asItem().getDefaultInstance();
                horizontalPane.item(block, new ItemStyle().width(16).height(16)).text(" ");
            }
        }
        if (iExhaustVentMachine.isNeedsVenting()) {
            horizontalPane.text(CompoundText.create().text("(").error((Component)Component.translatable((String)"gtceu.top.exhaust_vent_blocked")).style(TextStyleClass.INFO).text(")"));
        }
    }

    public ResourceLocation getID() {
        return GTCEu.id("exhaust_vent_info");
    }
}

