/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.syncdata;

import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeSerializer;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.lowdragmc.lowdraglib.syncdata.payload.ObjectTypedPayload;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

public class GTRecipePayload
extends ObjectTypedPayload<GTRecipe> {
    private static RecipeManager getRecipeManager() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && Thread.currentThread() == server.getRunningThread()) {
            return server.getRecipeManager();
        }
        return Client.getRecipeManager();
    }

    @Nullable
    public Tag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putString("id", ((GTRecipe)this.payload).id.toString());
        tag.put("recipe", (Tag)GTRecipeSerializer.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)((GTRecipe)this.payload)).result().orElse(new CompoundTag()));
        tag.putInt("parallels", ((GTRecipe)this.payload).parallels);
        tag.putInt("ocLevel", ((GTRecipe)this.payload).ocLevel);
        return tag;
    }

    public void deserializeNBT(Tag tag) {
        RecipeManager recipeManager = GTRecipePayload.getRecipeManager();
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            this.payload = GTRecipeSerializer.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compoundTag.get("recipe")).result().orElse(null);
            if (this.payload != null) {
                ((GTRecipe)this.payload).id = new ResourceLocation(compoundTag.getString("id"));
                ((GTRecipe)this.payload).parallels = compoundTag.contains("parallels") ? compoundTag.getInt("parallels") : 1;
                ((GTRecipe)this.payload).ocLevel = compoundTag.getInt("ocLevel");
            }
        } else if (tag instanceof StringTag) {
            StringTag stringTag = (StringTag)tag;
            Recipe recipe = recipeManager.byKey(new ResourceLocation(stringTag.getAsString())).orElse(null);
            if (recipe instanceof GTRecipe) {
                GTRecipe gtRecipe = (GTRecipe)recipe;
                this.payload = gtRecipe;
            } else if (recipe instanceof SmeltingRecipe) {
                SmeltingRecipe smeltingRecipe = (SmeltingRecipe)recipe;
                this.payload = GTRecipeTypes.FURNACE_RECIPES.toGTrecipe(new ResourceLocation(stringTag.getAsString()), (Recipe<?>)smeltingRecipe);
            } else {
                this.payload = null;
            }
        } else if (tag instanceof ByteArrayTag) {
            ByteArrayTag byteArray = (ByteArrayTag)tag;
            ByteBuf copiedDataBuffer = Unpooled.copiedBuffer((byte[])byteArray.getAsByteArray());
            FriendlyByteBuf buf = new FriendlyByteBuf(copiedDataBuffer);
            this.payload = recipeManager.byKey(buf.readResourceLocation()).orElse(null);
            buf.release();
        }
    }

    public void writePayload(FriendlyByteBuf buf) {
        buf.writeResourceLocation(((GTRecipe)this.payload).id);
        GTRecipeSerializer.SERIALIZER.toNetwork(buf, (GTRecipe)this.payload);
        buf.writeInt(((GTRecipe)this.payload).parallels);
        buf.writeInt(((GTRecipe)this.payload).ocLevel);
    }

    public void readPayload(FriendlyByteBuf buf) {
        ResourceLocation id = buf.readResourceLocation();
        if (buf.isReadable()) {
            this.payload = GTRecipeSerializer.SERIALIZER.fromNetwork(id, buf);
            if (buf.isReadable()) {
                ((GTRecipe)this.payload).parallels = buf.readInt();
                ((GTRecipe)this.payload).ocLevel = buf.readInt();
            }
        } else {
            RecipeManager recipeManager = GTRecipePayload.getRecipeManager();
            this.payload = recipeManager.byKey(id).orElse(null);
        }
    }

    static class Client {
        Client() {
        }

        static RecipeManager getRecipeManager() {
            return Minecraft.getInstance().getConnection().getRecipeManager();
        }
    }
}

