/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import com.gregtechceu.gtceu.utils.GTUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayFIFOQueue;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.TriPredicate;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreadthFirstBlockSearch {
    public static Set<BlockPos> search(Predicate<BlockPos> value, BlockPos start, int limit) {
        HashSet<BlockPos> alreadyVisited = new HashSet<BlockPos>();
        LinkedHashSet<BlockPos> valid = new LinkedHashSet<BlockPos>();
        int iteration = 0;
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        queue.add(start);
        while (!queue.isEmpty()) {
            BlockPos currentNode = (BlockPos)queue.remove();
            if (value.test(currentNode)) {
                if (limit < iteration++) break;
                valid.add(currentNode);
                continue;
            }
            alreadyVisited.add(currentNode);
            queue.addAll(BreadthFirstBlockSearch.getNeighbors(currentNode));
            queue.removeAll(alreadyVisited);
        }
        return valid;
    }

    public static Collection<BlockPos> getNeighbors(BlockPos pos) {
        HashSet<BlockPos> neighbors = new HashSet<BlockPos>();
        for (Direction dir : GTUtil.DIRECTIONS) {
            neighbors.add(pos.relative(dir));
        }
        return neighbors;
    }

    public static <T extends BlockEntity> Set<T> conditionalBlockEntitySearch(Class<T> clazz, T start, TriPredicate<T, T, Direction> condition, int blockLimit, int iterationLimit) {
        return BreadthFirstBlockSearch.conditionalSearch(clazz, start, start.getLevel(), BlockEntity::getBlockPos, condition, blockLimit, iterationLimit);
    }

    public static <T> Set<T> conditionalSearch(Class<T> clazz, T start, @Nullable Level level, Function<T, @NotNull BlockPos> posGetter, TriPredicate<T, T, Direction> condition, int blockLimit, int iterationLimit) {
        if (level == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<Object> passed = new LinkedHashSet<Object>();
        ObjectArrayFIFOQueue queue = new ObjectArrayFIFOQueue(16);
        queue.enqueue((Object)new ImmutableTriple(null, start, null));
        int iterations = 0;
        while (!queue.isEmpty() && iterations < iterationLimit && passed.size() < blockLimit) {
            Triple tuple = (Triple)queue.dequeue();
            Object next = tuple.getMiddle();
            if (passed.contains(next)) continue;
            if (condition.test(tuple.getLeft(), next, (Object)((Direction)tuple.getRight()))) {
                passed.add(next);
                for (Direction direction : GTUtil.DIRECTIONS) {
                    T casted;
                    BlockEntity neighbor = level.getBlockEntity(posGetter.apply(next).relative(direction));
                    if (!clazz.isInstance(neighbor) || passed.contains(casted = clazz.cast(neighbor))) continue;
                    queue.enqueue((Object)new ImmutableTriple(next, casted, (Object)direction));
                }
            }
            ++iterations;
        }
        return passed;
    }

    public static Set<BlockPos> conditionalBlockPosSearch(BlockPos start, BiPredicate<BlockPos, BlockPos> condition, int blockLimit, int iterationLimit) {
        LinkedHashSet<BlockPos> passed = new LinkedHashSet<BlockPos>();
        ObjectArrayFIFOQueue queue = new ObjectArrayFIFOQueue(16);
        queue.enqueue((Object)new Tuple(null, (Object)start));
        int iterations = 0;
        while (!queue.isEmpty() && iterations < iterationLimit && passed.size() < blockLimit) {
            Tuple tuple = (Tuple)queue.dequeue();
            BlockPos next = (BlockPos)tuple.getB();
            if (passed.contains(next)) continue;
            if (condition.test((BlockPos)tuple.getA(), (BlockPos)tuple.getB())) {
                passed.add(next);
                BreadthFirstBlockSearch.getNeighbors(next).forEach(neighbor -> {
                    if (!passed.contains(neighbor)) {
                        queue.enqueue((Object)new Tuple((Object)next, neighbor));
                    }
                });
            }
            ++iterations;
        }
        return passed;
    }
}

