/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils.data;

import com.google.gson.JsonElement;
import com.gregtechceu.gtceu.api.registry.registrate.provider.GTBlockstateProvider;
import com.gregtechceu.gtceu.utils.data.RuntimeExistingFileHelper;
import com.tterrag.registrate.AbstractRegistrate;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.IGeneratedBlockState;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelProvider;

public class RuntimeBlockStateProvider
extends GTBlockstateProvider {
    protected final BiConsumer<ResourceLocation, JsonElement> consumer;

    public RuntimeBlockStateProvider(AbstractRegistrate<?> parent, PackOutput packOutput, BiConsumer<ResourceLocation, JsonElement> consumer) {
        super(parent, packOutput, RuntimeExistingFileHelper.INSTANCE);
        this.consumer = consumer;
    }

    protected void registerStatesAndModels() {
    }

    public void run() {
        this.processModelProvider((ModelProvider)this.models());
        this.processModelProvider((ModelProvider)this.itemModels());
        for (Map.Entry entry : this.registeredBlocks.entrySet()) {
            ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)((Block)entry.getKey())).withPrefix("blockstates/");
            this.consumer.accept(loc, (JsonElement)((IGeneratedBlockState)entry.getValue()).toJson());
        }
        this.models().generatedModels.clear();
        this.itemModels().generatedModels.clear();
        this.registeredBlocks.clear();
    }

    public <T extends ModelBuilder<T>> void processModelProvider(ModelProvider<T> provider) {
        for (ModelBuilder model : provider.generatedModels.values()) {
            ResourceLocation loc = model.getLocation().withPrefix("models/");
            this.consumer.accept(loc, (JsonElement)model.toJson());
        }
    }
}

