/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu;

import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.client.ClientProxy;
import com.gregtechceu.gtceu.common.CommonProxy;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import dev.emi.emi.config.EmiConfig;
import java.nio.file.Path;
import me.shedaniel.rei.api.client.REIRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="gtceu")
public class GTCEu {
    public static final String MOD_ID = "gtceu";
    private static final ResourceLocation TEMPLATE_LOCATION = new ResourceLocation("gtceu", "");
    public static final String NAME = "GregTechCEu";
    public static final Logger LOGGER = LogManager.getLogger((String)"GregTechCEu");

    public GTCEu() {
        GTCEu.init();
        GTCEuAPI.instance = this;
        DistExecutor.unsafeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    }

    public static void init() {
        LOGGER.info("{} is initializing...", (Object)NAME);
    }

    public static ResourceLocation id(String path) {
        if (path.isBlank()) {
            return TEMPLATE_LOCATION;
        }
        int i = path.indexOf(58);
        if (i > 0) {
            return new ResourceLocation(path);
        }
        if (i == 0) {
            path = path.substring(i + 1);
        }
        if (FormattingUtil.hasUpperCase(path)) {
            path = FormattingUtil.toLowerCaseUnderscore(path);
        }
        return TEMPLATE_LOCATION.withPath(path);
    }

    public static String appendIdString(String id) {
        int i = id.indexOf(58);
        if (i > 0) {
            return id;
        }
        if (i == 0) {
            return MOD_ID + id;
        }
        return "gtceu:" + id;
    }

    public static boolean isProd() {
        return FMLLoader.isProduction();
    }

    public static boolean isDev() {
        return !GTCEu.isProd();
    }

    public static boolean isDataGen() {
        return FMLLoader.getLaunchHandler().isData();
    }

    public static MinecraftServer getMinecraftServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    public static boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static boolean isClientThread() {
        return GTCEu.isClientSide() && Minecraft.getInstance().isSameThread();
    }

    public static boolean isClientSide() {
        return FMLEnvironment.dist.isClient();
    }

    public static boolean canGetServerLevel() {
        if (GTCEu.isClientSide()) {
            return Minecraft.getInstance().level != null;
        }
        MinecraftServer server = GTCEu.getMinecraftServer();
        return server != null && !server.isStopped() && !server.isShutdown() && server.isRunning() && !server.isCurrentlySaving();
    }

    public static Path getGameDir() {
        return FMLPaths.GAMEDIR.get();
    }

    public static class Mods {
        public static boolean isJEILoaded() {
            return !GTCEu.isModLoaded("emi") && !GTCEu.isModLoaded("roughlyenoughitems") && GTCEu.isModLoaded("jei");
        }

        public static boolean isREILoaded() {
            return GTCEu.isModLoaded("roughlyenoughitems") && (!GTCEu.isClientSide() || REIRuntime.getInstance().isOverlayVisible());
        }

        public static boolean isEMILoaded() {
            return GTCEu.isModLoaded("emi") && (!GTCEu.isClientSide() || EmiConfig.enabled);
        }

        public static boolean isKubeJSLoaded() {
            return GTCEu.isModLoaded("kubejs");
        }

        public static boolean isIrisOculusLoaded() {
            return GTCEu.isModLoaded("iris") || GTCEu.isModLoaded("oculus");
        }

        public static boolean isSodiumRubidiumEmbeddiumLoaded() {
            return GTCEu.isModLoaded("sodium") || GTCEu.isModLoaded("rubidium") || GTCEu.isModLoaded("embeddium");
        }

        public static boolean isAE2Loaded() {
            return GTCEu.isModLoaded("ae2");
        }

        public static boolean isCuriosLoaded() {
            return GTCEu.isModLoaded("curios");
        }

        public static boolean isShimmerLoaded() {
            return GTCEu.isModLoaded("shimmer");
        }

        public static boolean isModernFixLoaded() {
            return GTCEu.isModLoaded("modernfix");
        }

        public static boolean isJAVDLoaded() {
            return GTCEu.isModLoaded("javd");
        }

        public static boolean isFTBTeamsLoaded() {
            return GTCEu.isModLoaded("ftbteams");
        }

        public static boolean isHeraclesLoaded() {
            return GTCEu.isModLoaded("heracles");
        }

        public static boolean isFTBQuestsLoaded() {
            return GTCEu.isModLoaded("ftbquests");
        }

        public static boolean isArgonautsLoaded() {
            return GTCEu.isModLoaded("argonauts");
        }

        public static boolean isGameStagesLoaded() {
            return GTCEu.isModLoaded("gamestages");
        }

        public static boolean isCCTweakedLoaded() {
            return GTCEu.isModLoaded("computercraft");
        }

        public static boolean isCreateLoaded() {
            return GTCEu.isModLoaded("create");
        }
    }
}

