/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.blockentity;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.MaterialPipeBlock;
import com.gregtechceu.gtceu.api.block.PipeBlock;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.capability.IToolable;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.IToolGridHighlight;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.pipenet.IPipeNode;
import com.gregtechceu.gtceu.api.pipenet.LevelPipeNet;
import com.gregtechceu.gtceu.api.pipenet.PipeCoverContainer;
import com.gregtechceu.gtceu.api.pipenet.PipeNet;
import com.gregtechceu.gtceu.common.data.GTMaterialBlocks;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.datafixers.TagFixer;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.syncdata.IEnhancedManaged;
import com.lowdragmc.lowdraglib.syncdata.IManaged;
import com.lowdragmc.lowdraglib.syncdata.IManagedStorage;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.blockentity.IAsyncAutoSyncBlockEntity;
import com.lowdragmc.lowdraglib.syncdata.blockentity.IAutoPersistBlockEntity;
import com.lowdragmc.lowdraglib.syncdata.field.FieldManagedStorage;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.mojang.datafixers.util.Pair;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class PipeBlockEntity<PipeType extends Enum<PipeType>, NodeDataType>
extends BlockEntity
implements IPipeNode<PipeType, NodeDataType>,
IEnhancedManaged,
IAsyncAutoSyncBlockEntity,
IAutoPersistBlockEntity,
IToolGridHighlight,
IToolable {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(PipeBlockEntity.class);
    private final FieldManagedStorage syncStorage = new FieldManagedStorage((IManaged)this);
    private final long offset = GTValues.RNG.nextInt(20);
    @DescSynced
    @Persisted(key="cover")
    protected final PipeCoverContainer coverContainer;
    @DescSynced
    @Persisted
    @RequireRerender
    protected int connections = 0;
    @DescSynced
    @Persisted
    @RequireRerender
    private int blockedConnections = 0;
    private NodeDataType cachedNodeData;
    @Persisted
    @DescSynced
    @RequireRerender
    private int paintingColor = -1;
    @RequireRerender
    @DescSynced
    @Persisted
    @NotNull
    private Material frameMaterial = GTMaterials.NULL;
    private final List<TickableSubscription> serverTicks;
    private final List<TickableSubscription> waitingToAdd;

    public PipeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        this.coverContainer = new PipeCoverContainer(this);
        this.serverTicks = new ArrayList<TickableSubscription>();
        this.waitingToAdd = new ArrayList<TickableSubscription>();
    }

    @Override
    public void scheduleRenderUpdate() {
        IPipeNode.super.scheduleRenderUpdate();
    }

    public IManagedStorage getRootStorage() {
        return this.syncStorage;
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public void onChanged() {
        Level level = this.getLevel();
        if (level != null && !level.isClientSide && level.getServer() != null) {
            level.getServer().execute(this::setChanged);
        }
    }

    @Override
    public long getOffsetTimer() {
        return this.level == null ? this.offset : (long)this.level.getServer().getTickCount() + this.offset;
    }

    public void setRemoved() {
        super.setRemoved();
        this.coverContainer.onUnload();
    }

    public void clearRemoved() {
        super.clearRemoved();
        this.coverContainer.onLoad();
    }

    @Override
    public int getNumConnections() {
        int count = 0;
        for (int connections = this.getConnections(); connections > 0; connections &= connections - 1) {
            ++count;
        }
        return count;
    }

    @Override
    @NotNull
    public Material getFrameMaterial() {
        if (this.frameMaterial == null) {
            this.frameMaterial = GTMaterials.NULL;
        }
        return this.frameMaterial;
    }

    @Override
    public int getBlockedConnections() {
        return this.canHaveBlockedFaces() ? this.blockedConnections : 0;
    }

    @Override
    public NodeDataType getNodeData() {
        if (this.cachedNodeData == null) {
            this.cachedNodeData = this.getPipeBlock().createProperties(this);
        }
        return this.cachedNodeData;
    }

    @Override
    @Nullable
    public TickableSubscription subscribeServerTick(Runnable runnable) {
        if (!this.isRemote()) {
            TickableSubscription subscription = new TickableSubscription(runnable);
            this.waitingToAdd.add(subscription);
            return subscription;
        }
        return null;
    }

    @Override
    public void unsubscribe(@Nullable TickableSubscription current) {
        if (current != null) {
            current.unsubscribe();
        }
    }

    @Override
    public final void serverTick() {
        if (!this.waitingToAdd.isEmpty()) {
            this.serverTicks.addAll(this.waitingToAdd);
            this.waitingToAdd.clear();
        }
        Iterator<TickableSubscription> iter = this.serverTicks.iterator();
        while (iter.hasNext()) {
            TickableSubscription tickable = iter.next();
            if (tickable.isStillSubscribed()) {
                tickable.run();
            }
            if (tickable.isStillSubscribed()) continue;
            iter.remove();
        }
    }

    @Override
    public void setBlocked(Direction side, boolean isBlocked) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.canHaveBlockedFaces()) {
                this.blockedConnections = this.withSideConnection(this.blockedConnections, side, isBlocked);
                this.setChanged();
                Object worldPipeNet = this.getPipeBlock().getWorldPipeNet(serverLevel);
                Object net = ((LevelPipeNet)((Object)worldPipeNet)).getNetFromPos(this.getBlockPos());
                if (net != null) {
                    ((PipeNet)net).onPipeConnectionsUpdate();
                }
            }
        }
    }

    @Override
    public int getVisualConnections() {
        int visualConnections = this.connections;
        for (Direction side : GTUtil.DIRECTIONS) {
            CoverBehavior cover = this.getCoverContainer().getCoverAtSide(side);
            if (cover == null || !cover.canPipePassThrough()) continue;
            visualConnections |= 1 << side.ordinal();
        }
        return visualConnections;
    }

    @Override
    public void setConnection(Direction side, boolean connected, boolean fromNeighbor) {
        if (!this.getLevel().isClientSide) {
            CoverBehavior cover;
            IPipeNode pipeTile;
            if (this.isConnected(side) == connected) {
                return;
            }
            BlockEntity tile = this.getNeighbor(side);
            if (connected && tile instanceof IPipeNode && (pipeTile = (IPipeNode)tile).getPipeType().getClass() != this.getPipeType().getClass()) {
                return;
            }
            if (!connected && (cover = this.getCoverContainer().getCoverAtSide(side)) != null && cover.canPipePassThrough()) {
                return;
            }
            this.connections = this.withSideConnection(this.connections, side, connected);
            this.updateNetworkConnection(side, connected);
            this.getLevel().neighborChanged(this.getBlockPos().relative(side), (Block)this.getPipeBlock(), this.getBlockPos());
            this.setChanged();
            if (!fromNeighbor && tile instanceof IPipeNode) {
                pipeTile = (IPipeNode)tile;
                this.syncPipeConnections(side, pipeTile);
            }
        }
    }

    private void syncPipeConnections(Direction side, IPipeNode<?, ?> pipe) {
        Direction oppositeSide = side.getOpposite();
        boolean neighbourOpen = pipe.isConnected(oppositeSide);
        if (this.isConnected(side) == neighbourOpen) {
            return;
        }
        if (!neighbourOpen || pipe.getCoverContainer().getCoverAtSide(oppositeSide) == null) {
            pipe.setConnection(oppositeSide, !neighbourOpen, true);
        }
    }

    private void updateNetworkConnection(Direction side, boolean connected) {
        Object worldPipeNet = this.getPipeBlock().getWorldPipeNet((ServerLevel)this.getLevel());
        ((LevelPipeNet)((Object)worldPipeNet)).updateBlockedConnections(this.getPipePos(), side, !connected);
    }

    protected int withSideConnection(int blockedConnections, Direction side, boolean connected) {
        int index = 1 << side.ordinal();
        if (connected) {
            return blockedConnections | index;
        }
        return blockedConnections & ~index;
    }

    @Override
    public void notifyBlockUpdate() {
        this.getLevel().updateNeighborsAt(this.getBlockPos(), (Block)this.getPipeBlock());
        this.getPipeBlock().updateActiveNodeStatus(this.getLevel(), this.getBlockPos(), this);
    }

    public boolean triggerEvent(int id, int para) {
        if (id == 1) {
            if (this.level != null && this.level.isClientSide) {
                this.scheduleRenderUpdate();
            }
            return true;
        }
        return false;
    }

    public void setChanged() {
        if (this.getLevel() != null) {
            this.getLevel().blockEntityChanged(this.getBlockPos());
        }
    }

    @Override
    public boolean shouldRenderGrid(Player player, BlockPos pos, BlockState state, ItemStack held, Set<GTToolType> toolTypes) {
        if (toolTypes.contains(this.getPipeTuneTool())) {
            return true;
        }
        for (CoverBehavior cover : this.coverContainer.getCovers()) {
            if (!cover.shouldRenderGrid(player, pos, state, held, toolTypes)) continue;
            return true;
        }
        return false;
    }

    public ResourceTexture getPipeTexture(boolean isBlock) {
        return isBlock ? GuiTextures.TOOL_PIPE_CONNECT : GuiTextures.TOOL_PIPE_BLOCK;
    }

    @Override
    @Nullable
    public ResourceTexture sideTips(Player player, BlockPos pos, BlockState state, Set<GTToolType> toolTypes, Direction side) {
        if (toolTypes.contains(this.getPipeTuneTool())) {
            if (player.isShiftKeyDown() && this.canHaveBlockedFaces()) {
                return this.getPipeTexture(this.isBlocked(side));
            }
            return this.getPipeTexture(this.isConnected(side));
        }
        CoverBehavior cover = this.coverContainer.getCoverAtSide(side);
        if (cover != null) {
            return cover.sideTips(player, pos, state, toolTypes, side);
        }
        return null;
    }

    @Override
    public Pair<GTToolType, InteractionResult> onToolClick(Set<GTToolType> toolTypes, ItemStack itemStack, UseOnContext context) {
        CoverBehavior coverBehavior;
        Player playerIn = context.getPlayer();
        if (playerIn == null) {
            return Pair.of(null, (Object)InteractionResult.PASS);
        }
        InteractionHand hand = context.getHand();
        BlockHitResult hitResult = new BlockHitResult(context.getClickLocation(), context.getClickedFace(), context.getClickedPos(), false);
        Direction gridSide = ICoverable.determineGridSideHit(hitResult);
        CoverBehavior coverBehavior2 = coverBehavior = gridSide == null ? null : this.coverContainer.getCoverAtSide(gridSide);
        if (gridSide == null) {
            gridSide = hitResult.getDirection();
        }
        if (toolTypes.isEmpty() && playerIn.isShiftKeyDown() && coverBehavior != null) {
            return Pair.of(null, (Object)coverBehavior.onScrewdriverClick(playerIn, hand, hitResult));
        }
        if (toolTypes.contains(GTToolType.SCREWDRIVER)) {
            if (coverBehavior != null) {
                return Pair.of((Object)GTToolType.SCREWDRIVER, (Object)coverBehavior.onScrewdriverClick(playerIn, hand, hitResult));
            }
        } else if (toolTypes.contains(GTToolType.SOFT_MALLET)) {
            if (coverBehavior != null) {
                return Pair.of((Object)GTToolType.SOFT_MALLET, (Object)coverBehavior.onSoftMalletClick(playerIn, hand, hitResult));
            }
        } else {
            if (toolTypes.contains(this.getPipeTuneTool())) {
                if (playerIn.isShiftKeyDown() && this.canHaveBlockedFaces()) {
                    boolean isBlocked = this.isBlocked(gridSide);
                    this.setBlocked(gridSide, !isBlocked);
                } else {
                    boolean isOpen = this.isConnected(gridSide);
                    this.setConnection(gridSide, !isOpen, false);
                }
                return Pair.of((Object)this.getPipeTuneTool(), (Object)InteractionResult.sidedSuccess((boolean)playerIn.level().isClientSide));
            }
            if (toolTypes.contains(GTToolType.CROWBAR)) {
                if (coverBehavior != null) {
                    if (!this.isRemote()) {
                        this.getCoverContainer().removeCover(gridSide, playerIn);
                        return Pair.of((Object)GTToolType.CROWBAR, (Object)InteractionResult.sidedSuccess((boolean)playerIn.level().isClientSide));
                    }
                } else if (!this.frameMaterial.isNull()) {
                    Block.popResource((Level)this.getLevel(), (BlockPos)this.getPipePos(), (ItemStack)((BlockEntry)GTMaterialBlocks.MATERIAL_BLOCKS.get((Object)TagPrefix.frameGt, (Object)this.frameMaterial)).asStack());
                    this.frameMaterial = GTMaterials.NULL;
                    return Pair.of((Object)GTToolType.CROWBAR, (Object)InteractionResult.sidedSuccess((boolean)playerIn.level().isClientSide));
                }
            }
        }
        return Pair.of(null, (Object)InteractionResult.PASS);
    }

    public GTToolType getPipeTuneTool() {
        return GTToolType.WRENCH;
    }

    @Override
    public int getDefaultPaintingColor() {
        int n;
        PipeBlock pipeBlock = this.getPipeBlock();
        if (pipeBlock instanceof MaterialPipeBlock) {
            MaterialPipeBlock materialPipeBlock = (MaterialPipeBlock)pipeBlock;
            n = materialPipeBlock.material.getMaterialRGB();
        } else {
            n = IPipeNode.super.getDefaultPaintingColor();
        }
        return n;
    }

    public void doExplosion(float explosionPower) {
        this.getLevel().removeBlock(this.getPipePos(), false);
        if (!this.getLevel().isClientSide) {
            ((ServerLevel)this.getLevel()).sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)this.getPipePos().getX() + 0.5, (double)this.getPipePos().getY() + 0.5, (double)this.getPipePos().getZ() + 0.5, 10, 0.2, 0.2, 0.2, 0.0);
        }
        this.getLevel().explode(null, (double)this.getPipePos().getX() + 0.5, (double)this.getPipePos().getY() + 0.5, (double)this.getPipePos().getZ() + 0.5, explosionPower, Level.ExplosionInteraction.NONE);
    }

    public static boolean isFaceBlocked(int blockedConnections, Direction side) {
        return (blockedConnections & 1 << side.ordinal()) > 0;
    }

    public static boolean isConnected(int connections, Direction side) {
        return (connections & 1 << side.ordinal()) > 0;
    }

    public void load(CompoundTag tag) {
        TagFixer.fixFluidTags(tag);
        super.load(tag);
    }

    @Generated
    public FieldManagedStorage getSyncStorage() {
        return this.syncStorage;
    }

    @Override
    @Generated
    public PipeCoverContainer getCoverContainer() {
        return this.coverContainer;
    }

    @Override
    @Generated
    public int getConnections() {
        return this.connections;
    }

    @Override
    @Generated
    public void setConnections(int connections) {
        this.connections = connections;
    }

    @Generated
    public void setBlockedConnections(int blockedConnections) {
        this.blockedConnections = blockedConnections;
    }

    @Override
    @Generated
    public int getPaintingColor() {
        return this.paintingColor;
    }

    @Override
    @Generated
    public void setPaintingColor(int paintingColor) {
        this.paintingColor = paintingColor;
    }

    @Generated
    public void setFrameMaterial(@NotNull Material frameMaterial) {
        if (frameMaterial == null) {
            throw new NullPointerException("frameMaterial is marked non-null but is null");
        }
        this.frameMaterial = frameMaterial;
    }
}

