/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.capability.recipe;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.codec.DispatchedMapCodec;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.recipe.content.IContentSerializer;
import com.gregtechceu.gtceu.api.recipe.lookup.ingredient.AbstractMapIngredient;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.mojang.serialization.Codec;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RecipeCapability<T> {
    public static final Codec<RecipeCapability<?>> DIRECT_CODEC = GTRegistries.RECIPE_CAPABILITIES.codec();
    public static final Codec<Map<RecipeCapability<?>, List<Content>>> CODEC = new DispatchedMapCodec<RecipeCapability, List<Content>>(DIRECT_CODEC, RecipeCapability::contentCodec);
    public static final Comparator<RecipeCapability<?>> COMPARATOR = Comparator.comparingInt(o -> o.sortIndex);
    public final String name;
    public final int color;
    public final boolean doRenderSlot;
    public final int sortIndex;
    public final IContentSerializer<T> serializer;

    protected RecipeCapability(String name, int color, boolean doRenderSlot, int sortIndex, IContentSerializer<T> serializer) {
        this.name = name;
        this.color = color;
        this.doRenderSlot = doRenderSlot;
        this.sortIndex = sortIndex;
        this.serializer = serializer;
    }

    public static Codec<List<Content>> contentCodec(RecipeCapability<?> capability) {
        return Content.codec(capability).listOf();
    }

    public Tag contentToNbt(Object value) {
        return this.serializer.toNbt(this.of(value));
    }

    public T copyInner(T content) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        this.serializer.toNetwork(buf, content);
        return this.serializer.fromNetwork(buf);
    }

    public T copyWithModifier(T content, ContentModifier modifier) {
        return this.copyInner(content);
    }

    public final T copyContent(Object content) {
        return (T)this.copyInner(content);
    }

    public final T copyContent(Object content, ContentModifier modifier) {
        return (T)this.copyWithModifier(content, modifier);
    }

    public T of(Object o) {
        return this.serializer.of(o);
    }

    public String slotName(IO io) {
        return "%s_%s".formatted(this.name, io.name().toLowerCase(Locale.ROOT));
    }

    public String slotName(IO io, int index) {
        return "%s_%s_%s".formatted(this.name, io.name().toLowerCase(Locale.ROOT), index);
    }

    public MutableComponent getName() {
        return Component.translatable((String)"recipe.capability.%s.name".formatted(this.name));
    }

    public MutableComponent getColoredName() {
        return this.getName().withStyle(style -> style.withColor(this.color));
    }

    public boolean isRecipeSearchFilter() {
        return false;
    }

    public List<Object> compressIngredients(Collection<Object> ingredients) {
        return new ArrayList<Object>(ingredients);
    }

    @Nullable
    public List<AbstractMapIngredient> getDefaultMapIngredient(Object object) {
        return null;
    }

    public boolean doMatchInRecipe() {
        return true;
    }

    public int limitMaxParallelByOutput(IRecipeCapabilityHolder holder, GTRecipe recipe, int maxMultiplier, boolean tick) {
        return Integer.MAX_VALUE;
    }

    public int getMaxParallelByInput(IRecipeCapabilityHolder holder, GTRecipe recipe, int limit, boolean tick) {
        return Integer.MAX_VALUE;
    }

    public boolean doAddGuiSlots() {
        return this.isRecipeSearchFilter();
    }

    public void addXEIInfo(WidgetGroup group, int xOffset, GTRecipe recipe, List<Content> contents, boolean perTick, boolean isInput, MutableInt yOffset) {
    }

    @NotNull
    public List<Object> createXEIContainerContents(List<Content> contents, GTRecipe recipe, IO io) {
        return new ArrayList<Object>();
    }

    @Nullable
    public Object createXEIContainer(List<?> contents) {
        return null;
    }

    @Nullable(value="null when getWidgetClass() == null")
    public @Nullable(value="null when getWidgetClass() == null") Widget createWidget() {
        return null;
    }

    @Nullable
    public Class<? extends Widget> getWidgetClass() {
        return null;
    }

    public void applyWidgetInfo(@NotNull Widget widget, int index, boolean isXEI, IO io, @Nullable(value="null when storage == null")  @Nullable(value="null when storage == null") GTRecipeTypeUI.RecipeHolder recipeHolder, @NotNull GTRecipeType recipeType, @Nullable(value="null when content == null") @Nullable(value="null when content == null") GTRecipe recipe, @Nullable Content content, @Nullable Object storage, int recipeTier, int chanceTier) {
    }

    public Object2IntMap<T> makeChanceCache() {
        return new Object2IntOpenHashMap();
    }

    public boolean isTickSlot(int index, IO io, GTRecipe recipe) {
        return index >= (io == IO.IN ? recipe.getInputContents(this) : recipe.getOutputContents(this)).size();
    }

    public boolean shouldBypassDistinct() {
        return true;
    }
}

