/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen;

import com.google.common.collect.HashBiMap;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.IWorldGenLayer;
import com.gregtechceu.gtceu.api.data.worldgen.generator.IndicatorGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.VeinGenerator;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.utils.WeightedEntry;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class WorldGeneratorUtils {
    public static final RuleTest END_ORE_REPLACEABLES = new TagMatchTest(CustomTags.ENDSTONE_ORE_REPLACEABLES);
    private static final Map<ServerLevel, WorldOreVeinCache> oreVeinCache = new WeakHashMap<ServerLevel, WorldOreVeinCache>();
    public static final SortedMap<String, IWorldGenLayer> WORLD_GEN_LAYERS = new Object2ObjectLinkedOpenHashMap();
    public static final HashBiMap<ResourceLocation, Codec<? extends VeinGenerator>> VEIN_GENERATORS = HashBiMap.create();
    public static final HashBiMap<ResourceLocation, Function<GTOreDefinition, ? extends VeinGenerator>> VEIN_GENERATOR_FUNCTIONS = HashBiMap.create();
    public static final HashBiMap<ResourceLocation, Codec<? extends IndicatorGenerator>> INDICATOR_GENERATORS = HashBiMap.create();
    public static final HashBiMap<ResourceLocation, Function<GTOreDefinition, ? extends IndicatorGenerator>> INDICATOR_GENERATOR_FUNCTIONS = HashBiMap.create();

    public static List<WeightedVein> getCachedBiomeVeins(ServerLevel level, Holder<Biome> biome) {
        return oreVeinCache.computeIfAbsent(level, WorldOreVeinCache::new).getEntry(biome);
    }

    public static Optional<String> getWorldGenLayerKey(IWorldGenLayer layer) {
        return WORLD_GEN_LAYERS.entrySet().stream().filter(entry -> ((IWorldGenLayer)entry.getValue()).equals(layer)).map(Map.Entry::getKey).findFirst();
    }

    public static boolean isSameDimension(ResourceKey<Level> first, ResourceKey<Level> second) {
        return first == second;
    }

    public static <T> Map<ChunkPos, Map<BlockPos, T>> groupByChunks(Map<BlockPos, T> input) {
        return (Map)input.entrySet().stream().collect(Collectors.groupingBy(entry -> new ChunkPos((BlockPos)entry.getKey()), Object2ObjectOpenHashMap::new, Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, Object2ObjectOpenHashMap::new)));
    }

    public static <T> Map<ChunkPos, List<BlockPos>> groupByChunks(Collection<BlockPos> positions) {
        return positions.stream().collect(Collectors.groupingBy(ChunkPos::new));
    }

    public static Collection<ChunkPos> getChunks(Collection<BlockPos> positions) {
        return positions.stream().collect(Collectors.groupingBy(ChunkPos::new)).keySet();
    }

    public static void generateChunks(WorldGenLevel level, ChunkStatus requiredStatus, Collection<ChunkPos> chunks) {
        ObjectArrayList previouslyUnloadedChunks = new ObjectArrayList();
        ChunkSource chunkSource = level.getChunkSource();
        for (ChunkPos chunkPos : chunks) {
            LevelChunk chunk2 = chunkSource.getChunk(chunkPos.x, chunkPos.z, false);
            if (chunk2 == null) {
                previouslyUnloadedChunks.add(chunkPos);
            }
            chunkSource.getChunk(chunkPos.x, chunkPos.z, requiredStatus, true);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            previouslyUnloadedChunks.forEach(chunk -> serverLevel.unload(serverLevel.getChunk(chunk.x, chunk.z)));
        }
    }

    public static Optional<BlockPos> findBlockPos(BlockPos initialPos, Predicate<BlockPos> predicate, Consumer<BlockPos.MutableBlockPos> step, int maxSteps) {
        BlockPos.MutableBlockPos currentPos = initialPos.mutable();
        while (maxSteps-- >= 0) {
            step.accept(currentPos);
            if (!predicate.test((BlockPos)currentPos)) continue;
            return Optional.of(currentPos.immutable());
        }
        return Optional.empty();
    }

    public static void invalidateOreVeinCache() {
        oreVeinCache.clear();
    }

    private static class WorldOreVeinCache {
        private final List<GTOreDefinition> worldVeins;
        private final Map<Holder<Biome>, List<WeightedVein>> biomeVeins = new Object2ObjectOpenHashMap();

        public WorldOreVeinCache(ServerLevel level) {
            this.worldVeins = GTRegistries.ORE_VEINS.values().stream().filter(entry -> entry.dimensionFilter().stream().anyMatch(dim -> WorldGeneratorUtils.isSameDimension((ResourceKey<Level>)dim, (ResourceKey<Level>)level.dimension()))).collect(Collectors.toList());
        }

        private List<WeightedVein> getEntry(Holder<Biome> biome) {
            if (this.biomeVeins.containsKey(biome)) {
                return this.biomeVeins.get(biome);
            }
            List<WeightedVein> biomeVeins = this.worldVeins.stream().filter(vein -> vein.isForBiome(biome)).map(vein -> new WeightedVein((GTOreDefinition)vein, vein.weightForBiome(biome))).filter(vein -> vein.weight > 0).toList();
            this.biomeVeins.put(biome, biomeVeins);
            return biomeVeins;
        }
    }

    public record WeightedVein(GTOreDefinition vein, int weight) implements WeightedEntry
    {
    }
}

