/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.ores;

import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedIndicators;
import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedVein;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreBlockPlacer;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreGenCache;
import com.gregtechceu.gtceu.config.ConfigHolder;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class OrePlacer {
    private final OreGenCache oreGenCache = new OreGenCache();

    public void placeOres(WorldGenLevel level, ChunkGenerator chunkGenerator, ChunkAccess chunk) {
        if (!ConfigHolder.INSTANCE.dev.doSuperflatOres && chunkGenerator instanceof FlatLevelSource) {
            return;
        }
        XoroshiroRandomSource random = new XoroshiroRandomSource(level.getSeed() ^ chunk.getPos().toLong());
        List<GeneratedVein> generatedVeins = this.oreGenCache.consumeChunkVeins(level, chunkGenerator, chunk);
        List<GeneratedIndicators> generatedIndicators = this.oreGenCache.consumeChunkIndicators(level, chunkGenerator, chunk);
        try (BulkSectionAccess access = new BulkSectionAccess((LevelAccessor)level);){
            generatedVeins.forEach(generatedVein -> this.placeVein(chunk.getPos(), (RandomSource)random, access, (GeneratedVein)generatedVein, null));
            generatedIndicators.forEach(generatedIndicator -> this.placeIndicators(chunk, access, (GeneratedIndicators)generatedIndicator));
        }
    }

    public void placeVein(ChunkPos chunk, RandomSource random, BulkSectionAccess access, GeneratedVein generatedVein, @Nullable RuleTest targetOverride) {
        RuleTest layerTarget = targetOverride != null ? targetOverride : generatedVein.getLayer().getTarget();
        this.resolvePlacerLists(chunk, generatedVein).forEach((sectionPos, placers) -> {
            LevelChunkSection section = access.getSection(sectionPos.origin());
            if (section == null) {
                return;
            }
            placers.forEach((pos, placer) -> {
                BlockState blockState = section.getBlockState(SectionPos.sectionRelative((int)pos.getX()), SectionPos.sectionRelative((int)pos.getY()), SectionPos.sectionRelative((int)pos.getZ()));
                if (layerTarget.test(blockState, random)) {
                    placer.placeBlock(access, section);
                }
            });
        });
    }

    private Map<SectionPos, Map<BlockPos, OreBlockPlacer>> resolvePlacerLists(ChunkPos chunk, GeneratedVein vein) {
        return vein.consumeOres(chunk).entrySet().stream().collect(Collectors.groupingBy(entry -> SectionPos.of((BlockPos)((BlockPos)entry.getKey())), Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    private void placeIndicators(ChunkAccess chunk, BulkSectionAccess access, GeneratedIndicators generatedVein) {
        if (!ConfigHolder.INSTANCE.worldgen.oreVeins.oreIndicators) {
            return;
        }
        generatedVein.consumeIndicators(chunk.getPos()).forEach(placer -> placer.placeIndicators(access));
    }

    @Generated
    public OreGenCache getOreGenCache() {
        return this.oreGenCache;
    }
}

