/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item;

import com.gregtechceu.gtceu.api.block.IMachineBlock;
import com.gregtechceu.gtceu.api.block.PipeBlock;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.pipenet.IPipeNode;
import com.gregtechceu.gtceu.client.renderer.ItemWithBERModelRenderer;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MetaMachineItem
extends BlockItem {
    public MetaMachineItem(IMachineBlock block, Item.Properties properties) {
        super(block.self(), properties);
    }

    public MachineDefinition getDefinition() {
        return ((IMachineBlock)this.getBlock()).getDefinition();
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState state) {
        IPipeNode pipeTile;
        BlockPos possiblePipe;
        Block block;
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction side = context.getClickedFace();
        boolean superVal = super.placeBlock(context, state);
        if (!level.isClientSide && (block = level.getBlockState(possiblePipe = pos.offset(side.getOpposite().getNormal())).getBlock()) instanceof PipeBlock && (pipeTile = ((PipeBlock)block).getPipeTile((BlockGetter)level, possiblePipe)) != null && ((PipeBlock)block).canPipeConnectToBlock(pipeTile, side.getOpposite(), level.getBlockEntity(pos))) {
            pipeTile.setConnection(side, true, false);
        }
        return superVal;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return ItemWithBERModelRenderer.INSTANCE;
            }
        });
    }
}

