/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine;

import com.gregtechceu.gtceu.api.blockentity.ITickSubscription;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import java.util.function.BooleanSupplier;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.level.Level;

public class ConditionalSubscriptionHandler {
    private final ITickSubscription handler;
    private final Runnable runnable;
    private final BooleanSupplier condition;
    private TickableSubscription subscription;

    public ConditionalSubscriptionHandler(ITickSubscription handler, Runnable runnable, BooleanSupplier condition) {
        this.handler = handler;
        this.runnable = runnable;
        this.condition = condition;
    }

    public void initialize(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.initialize((BlockableEventLoop<TickTask>)serverLevel.getServer());
        }
    }

    protected void initialize(BlockableEventLoop<TickTask> server) {
        server.tell((Runnable)new TickTask(0, this::updateSubscription));
    }

    public void updateSubscription() {
        if (this.condition.getAsBoolean()) {
            this.subscription = this.handler.subscribeServerTick(this.subscription, this.runnable);
        } else if (this.subscription != null) {
            this.subscription.unsubscribe();
            this.subscription = null;
        }
    }

    public void unsubscribe() {
        if (this.subscription != null) {
            this.subscription.unsubscribe();
            this.subscription = null;
        }
    }
}

